/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StorFilestorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "7ef369fb8b133937b0ccee5d21ac1579";
    public static final String CONFIG_DEF_NAME = "stor-filestor";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "use_new_core bool default=false restart", "dir_spread int default=256 restart", "dir_levels int default=1 restart", "minimum_file_meta_slots int default=512", "maximum_file_meta_slots int default=13106", "minimum_file_header_block_size int default=102848", "maximum_file_header_block_size int default=33554432", "minimum_file_size int default=1048576", "maximum_file_size int default=268431360", "file_block_size int default=4096", "warn_on_slow_operations int default=5000", "fail_disk_after_error_count int default=1 restart", "disk_operation_timeout int default=0 restart", "time_future_limit int default=5", "time_past_limit int default=3600", "debug_verifications int default=0 restart", "fsync_after_each_operation bool default=false restart", "revert_time_period int default=300", "keep_remove_time_period int default=604800", "maximum_versions_of_single_document_stored int default=0", "threads[].lowestpri int default=255 restart", "max_priority_to_block int default=255 restart", "min_priority_to_be_blocking int default=0 restart", "bucket_merge_chunk_size int default=4190208 restart", "initial_index_read int default=61440", "initial_name_read int default=512 restart", "maximum_gap_to_read_through int default=65536", "remove_file_gaps_on_rewrite bool default=true restart", "body_block_order enum { ANY, TIMESTAMP, RGID } default=ANY restart", "only_reorder_body_in_memory bool default=true restart", "verify_checksum_on_regular_load bool default=true restart", "verify_checksum_on_visit bool default=true restart", "maximum_sustainable_index_buffer_size int default=1044480 restart", "maximum_sustainable_input_buffer_size int default=1044480 restart", "maximum_sustainable_output_buffer_size int default=1044480 restart", "downsize_index_buffer_immediately_after_use bool default=false restart", "downsize_input_buffer_immediately_after_use bool default=true restart", "downsize_output_buffer_immediately_after_use bool default=true restart", "minimum_continuous_file_write_buffer_size int default=1044480 restart", "maximum_continuous_file_write_buffer_size int default=1044480 restart", "minimum_join_source_body_read_buffer_size int default=1044480 restart", "maximum_join_source_body_read_buffer_size int default=16773120 restart", "minimum_export_source_body_read_buffer_size int default=1044480 restart", "maximum_export_source_body_read_buffer_size int default=33550336 restart", "minimum_defrag_source_body_read_buffer_size int default=1044480 restart", "maximum_defrag_source_body_read_buffer_size int default=1044480 restart", "common_merge_chain_optimalization_minimum_size int default=64 restart", "enable_merge_local_node_choose_docs_optimalization bool default=true restart", "read_only_used_header_part_when_possible bool default=true restart", "enable_slotfile_cache bool default=true restart", "slotfile_precache_header_after_access_count int default=512 restart", "enable_multibit_split_optimalization bool default=true restart", "use_direct_io bool default=true restart", "block_alignment_size int default=512 restart", "disk_full_factor double default=0.98 restart", "grow_factor double default=2.0", "min_fill_rate double default=0.1", "defrag_minimum_gain double default=1.0 restart", "overrepresent_meta_data_factor double default=1.2", "overrepresent_header_block_factor double default=1.1", "load_types_to_cache[] string restart"};
    private final BooleanNode use_new_core;
    private final IntegerNode dir_spread;
    private final IntegerNode dir_levels;
    private final IntegerNode minimum_file_meta_slots;
    private final IntegerNode maximum_file_meta_slots;
    private final IntegerNode minimum_file_header_block_size;
    private final IntegerNode maximum_file_header_block_size;
    private final IntegerNode minimum_file_size;
    private final IntegerNode maximum_file_size;
    private final IntegerNode file_block_size;
    private final IntegerNode warn_on_slow_operations;
    private final IntegerNode fail_disk_after_error_count;
    private final IntegerNode disk_operation_timeout;
    private final IntegerNode time_future_limit;
    private final IntegerNode time_past_limit;
    private final IntegerNode debug_verifications;
    private final BooleanNode fsync_after_each_operation;
    private final IntegerNode revert_time_period;
    private final IntegerNode keep_remove_time_period;
    private final IntegerNode maximum_versions_of_single_document_stored;
    private final InnerNodeVector<Threads> threads;
    private final IntegerNode max_priority_to_block;
    private final IntegerNode min_priority_to_be_blocking;
    private final IntegerNode bucket_merge_chunk_size;
    private final IntegerNode initial_index_read;
    private final IntegerNode initial_name_read;
    private final IntegerNode maximum_gap_to_read_through;
    private final BooleanNode remove_file_gaps_on_rewrite;
    private final Body_block_order body_block_order;
    private final BooleanNode only_reorder_body_in_memory;
    private final BooleanNode verify_checksum_on_regular_load;
    private final BooleanNode verify_checksum_on_visit;
    private final IntegerNode maximum_sustainable_index_buffer_size;
    private final IntegerNode maximum_sustainable_input_buffer_size;
    private final IntegerNode maximum_sustainable_output_buffer_size;
    private final BooleanNode downsize_index_buffer_immediately_after_use;
    private final BooleanNode downsize_input_buffer_immediately_after_use;
    private final BooleanNode downsize_output_buffer_immediately_after_use;
    private final IntegerNode minimum_continuous_file_write_buffer_size;
    private final IntegerNode maximum_continuous_file_write_buffer_size;
    private final IntegerNode minimum_join_source_body_read_buffer_size;
    private final IntegerNode maximum_join_source_body_read_buffer_size;
    private final IntegerNode minimum_export_source_body_read_buffer_size;
    private final IntegerNode maximum_export_source_body_read_buffer_size;
    private final IntegerNode minimum_defrag_source_body_read_buffer_size;
    private final IntegerNode maximum_defrag_source_body_read_buffer_size;
    private final IntegerNode common_merge_chain_optimalization_minimum_size;
    private final BooleanNode enable_merge_local_node_choose_docs_optimalization;
    private final BooleanNode read_only_used_header_part_when_possible;
    private final BooleanNode enable_slotfile_cache;
    private final IntegerNode slotfile_precache_header_after_access_count;
    private final BooleanNode enable_multibit_split_optimalization;
    private final BooleanNode use_direct_io;
    private final IntegerNode block_alignment_size;
    private final DoubleNode disk_full_factor;
    private final DoubleNode grow_factor;
    private final DoubleNode min_fill_rate;
    private final DoubleNode defrag_minimum_gain;
    private final DoubleNode overrepresent_meta_data_factor;
    private final DoubleNode overrepresent_header_block_factor;
    private final LeafNodeVector<String, StringNode> load_types_to_cache;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorFilestorConfig(Builder builder) {
        this(builder, true);
    }

    private StorFilestorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-filestor must be initialized: " + builder.__uninitialized);
        }
        this.use_new_core = builder.use_new_core == null ? new BooleanNode(false) : new BooleanNode(builder.use_new_core.booleanValue());
        this.dir_spread = builder.dir_spread == null ? new IntegerNode(256) : new IntegerNode(builder.dir_spread.intValue());
        this.dir_levels = builder.dir_levels == null ? new IntegerNode(1) : new IntegerNode(builder.dir_levels.intValue());
        this.minimum_file_meta_slots = builder.minimum_file_meta_slots == null ? new IntegerNode(512) : new IntegerNode(builder.minimum_file_meta_slots.intValue());
        this.maximum_file_meta_slots = builder.maximum_file_meta_slots == null ? new IntegerNode(13106) : new IntegerNode(builder.maximum_file_meta_slots.intValue());
        this.minimum_file_header_block_size = builder.minimum_file_header_block_size == null ? new IntegerNode(102848) : new IntegerNode(builder.minimum_file_header_block_size.intValue());
        this.maximum_file_header_block_size = builder.maximum_file_header_block_size == null ? new IntegerNode(0x2000000) : new IntegerNode(builder.maximum_file_header_block_size.intValue());
        this.minimum_file_size = builder.minimum_file_size == null ? new IntegerNode(0x100000) : new IntegerNode(builder.minimum_file_size.intValue());
        this.maximum_file_size = builder.maximum_file_size == null ? new IntegerNode(0xFFFF000) : new IntegerNode(builder.maximum_file_size.intValue());
        this.file_block_size = builder.file_block_size == null ? new IntegerNode(4096) : new IntegerNode(builder.file_block_size.intValue());
        this.warn_on_slow_operations = builder.warn_on_slow_operations == null ? new IntegerNode(5000) : new IntegerNode(builder.warn_on_slow_operations.intValue());
        this.fail_disk_after_error_count = builder.fail_disk_after_error_count == null ? new IntegerNode(1) : new IntegerNode(builder.fail_disk_after_error_count.intValue());
        this.disk_operation_timeout = builder.disk_operation_timeout == null ? new IntegerNode(0) : new IntegerNode(builder.disk_operation_timeout.intValue());
        this.time_future_limit = builder.time_future_limit == null ? new IntegerNode(5) : new IntegerNode(builder.time_future_limit.intValue());
        this.time_past_limit = builder.time_past_limit == null ? new IntegerNode(3600) : new IntegerNode(builder.time_past_limit.intValue());
        this.debug_verifications = builder.debug_verifications == null ? new IntegerNode(0) : new IntegerNode(builder.debug_verifications.intValue());
        this.fsync_after_each_operation = builder.fsync_after_each_operation == null ? new BooleanNode(false) : new BooleanNode(builder.fsync_after_each_operation.booleanValue());
        this.revert_time_period = builder.revert_time_period == null ? new IntegerNode(300) : new IntegerNode(builder.revert_time_period.intValue());
        this.keep_remove_time_period = builder.keep_remove_time_period == null ? new IntegerNode(604800) : new IntegerNode(builder.keep_remove_time_period.intValue());
        this.maximum_versions_of_single_document_stored = builder.maximum_versions_of_single_document_stored == null ? new IntegerNode(0) : new IntegerNode(builder.maximum_versions_of_single_document_stored.intValue());
        this.threads = Threads.createVector(builder.threads);
        this.max_priority_to_block = builder.max_priority_to_block == null ? new IntegerNode(255) : new IntegerNode(builder.max_priority_to_block.intValue());
        this.min_priority_to_be_blocking = builder.min_priority_to_be_blocking == null ? new IntegerNode(0) : new IntegerNode(builder.min_priority_to_be_blocking.intValue());
        this.bucket_merge_chunk_size = builder.bucket_merge_chunk_size == null ? new IntegerNode(0x3FF000) : new IntegerNode(builder.bucket_merge_chunk_size.intValue());
        this.initial_index_read = builder.initial_index_read == null ? new IntegerNode(61440) : new IntegerNode(builder.initial_index_read.intValue());
        this.initial_name_read = builder.initial_name_read == null ? new IntegerNode(512) : new IntegerNode(builder.initial_name_read.intValue());
        this.maximum_gap_to_read_through = builder.maximum_gap_to_read_through == null ? new IntegerNode(65536) : new IntegerNode(builder.maximum_gap_to_read_through.intValue());
        this.remove_file_gaps_on_rewrite = builder.remove_file_gaps_on_rewrite == null ? new BooleanNode(true) : new BooleanNode(builder.remove_file_gaps_on_rewrite.booleanValue());
        this.body_block_order = builder.body_block_order == null ? new Body_block_order(Body_block_order.ANY) : new Body_block_order(builder.body_block_order);
        this.only_reorder_body_in_memory = builder.only_reorder_body_in_memory == null ? new BooleanNode(true) : new BooleanNode(builder.only_reorder_body_in_memory.booleanValue());
        this.verify_checksum_on_regular_load = builder.verify_checksum_on_regular_load == null ? new BooleanNode(true) : new BooleanNode(builder.verify_checksum_on_regular_load.booleanValue());
        this.verify_checksum_on_visit = builder.verify_checksum_on_visit == null ? new BooleanNode(true) : new BooleanNode(builder.verify_checksum_on_visit.booleanValue());
        this.maximum_sustainable_index_buffer_size = builder.maximum_sustainable_index_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.maximum_sustainable_index_buffer_size.intValue());
        this.maximum_sustainable_input_buffer_size = builder.maximum_sustainable_input_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.maximum_sustainable_input_buffer_size.intValue());
        this.maximum_sustainable_output_buffer_size = builder.maximum_sustainable_output_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.maximum_sustainable_output_buffer_size.intValue());
        this.downsize_index_buffer_immediately_after_use = builder.downsize_index_buffer_immediately_after_use == null ? new BooleanNode(false) : new BooleanNode(builder.downsize_index_buffer_immediately_after_use.booleanValue());
        this.downsize_input_buffer_immediately_after_use = builder.downsize_input_buffer_immediately_after_use == null ? new BooleanNode(true) : new BooleanNode(builder.downsize_input_buffer_immediately_after_use.booleanValue());
        this.downsize_output_buffer_immediately_after_use = builder.downsize_output_buffer_immediately_after_use == null ? new BooleanNode(true) : new BooleanNode(builder.downsize_output_buffer_immediately_after_use.booleanValue());
        this.minimum_continuous_file_write_buffer_size = builder.minimum_continuous_file_write_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.minimum_continuous_file_write_buffer_size.intValue());
        this.maximum_continuous_file_write_buffer_size = builder.maximum_continuous_file_write_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.maximum_continuous_file_write_buffer_size.intValue());
        this.minimum_join_source_body_read_buffer_size = builder.minimum_join_source_body_read_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.minimum_join_source_body_read_buffer_size.intValue());
        this.maximum_join_source_body_read_buffer_size = builder.maximum_join_source_body_read_buffer_size == null ? new IntegerNode(0xFFF000) : new IntegerNode(builder.maximum_join_source_body_read_buffer_size.intValue());
        this.minimum_export_source_body_read_buffer_size = builder.minimum_export_source_body_read_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.minimum_export_source_body_read_buffer_size.intValue());
        this.maximum_export_source_body_read_buffer_size = builder.maximum_export_source_body_read_buffer_size == null ? new IntegerNode(0x1FFF000) : new IntegerNode(builder.maximum_export_source_body_read_buffer_size.intValue());
        this.minimum_defrag_source_body_read_buffer_size = builder.minimum_defrag_source_body_read_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.minimum_defrag_source_body_read_buffer_size.intValue());
        this.maximum_defrag_source_body_read_buffer_size = builder.maximum_defrag_source_body_read_buffer_size == null ? new IntegerNode(1044480) : new IntegerNode(builder.maximum_defrag_source_body_read_buffer_size.intValue());
        this.common_merge_chain_optimalization_minimum_size = builder.common_merge_chain_optimalization_minimum_size == null ? new IntegerNode(64) : new IntegerNode(builder.common_merge_chain_optimalization_minimum_size.intValue());
        this.enable_merge_local_node_choose_docs_optimalization = builder.enable_merge_local_node_choose_docs_optimalization == null ? new BooleanNode(true) : new BooleanNode(builder.enable_merge_local_node_choose_docs_optimalization.booleanValue());
        this.read_only_used_header_part_when_possible = builder.read_only_used_header_part_when_possible == null ? new BooleanNode(true) : new BooleanNode(builder.read_only_used_header_part_when_possible.booleanValue());
        this.enable_slotfile_cache = builder.enable_slotfile_cache == null ? new BooleanNode(true) : new BooleanNode(builder.enable_slotfile_cache.booleanValue());
        this.slotfile_precache_header_after_access_count = builder.slotfile_precache_header_after_access_count == null ? new IntegerNode(512) : new IntegerNode(builder.slotfile_precache_header_after_access_count.intValue());
        this.enable_multibit_split_optimalization = builder.enable_multibit_split_optimalization == null ? new BooleanNode(true) : new BooleanNode(builder.enable_multibit_split_optimalization.booleanValue());
        this.use_direct_io = builder.use_direct_io == null ? new BooleanNode(true) : new BooleanNode(builder.use_direct_io.booleanValue());
        this.block_alignment_size = builder.block_alignment_size == null ? new IntegerNode(512) : new IntegerNode(builder.block_alignment_size.intValue());
        this.disk_full_factor = builder.disk_full_factor == null ? new DoubleNode(0.98) : new DoubleNode(builder.disk_full_factor.doubleValue());
        this.grow_factor = builder.grow_factor == null ? new DoubleNode(2.0) : new DoubleNode(builder.grow_factor.doubleValue());
        this.min_fill_rate = builder.min_fill_rate == null ? new DoubleNode(0.1) : new DoubleNode(builder.min_fill_rate.doubleValue());
        this.defrag_minimum_gain = builder.defrag_minimum_gain == null ? new DoubleNode(1.0) : new DoubleNode(builder.defrag_minimum_gain.doubleValue());
        this.overrepresent_meta_data_factor = builder.overrepresent_meta_data_factor == null ? new DoubleNode(1.2) : new DoubleNode(builder.overrepresent_meta_data_factor.doubleValue());
        this.overrepresent_header_block_factor = builder.overrepresent_header_block_factor == null ? new DoubleNode(1.1) : new DoubleNode(builder.overrepresent_header_block_factor.doubleValue());
        this.load_types_to_cache = new LeafNodeVector(builder.load_types_to_cache, (LeafNode)new StringNode());
    }

    public boolean use_new_core() {
        return this.use_new_core.value();
    }

    public int dir_spread() {
        return this.dir_spread.value();
    }

    public int dir_levels() {
        return this.dir_levels.value();
    }

    public int minimum_file_meta_slots() {
        return this.minimum_file_meta_slots.value();
    }

    public int maximum_file_meta_slots() {
        return this.maximum_file_meta_slots.value();
    }

    public int minimum_file_header_block_size() {
        return this.minimum_file_header_block_size.value();
    }

    public int maximum_file_header_block_size() {
        return this.maximum_file_header_block_size.value();
    }

    public int minimum_file_size() {
        return this.minimum_file_size.value();
    }

    public int maximum_file_size() {
        return this.maximum_file_size.value();
    }

    public int file_block_size() {
        return this.file_block_size.value();
    }

    public int warn_on_slow_operations() {
        return this.warn_on_slow_operations.value();
    }

    public int fail_disk_after_error_count() {
        return this.fail_disk_after_error_count.value();
    }

    public int disk_operation_timeout() {
        return this.disk_operation_timeout.value();
    }

    public int time_future_limit() {
        return this.time_future_limit.value();
    }

    public int time_past_limit() {
        return this.time_past_limit.value();
    }

    public int debug_verifications() {
        return this.debug_verifications.value();
    }

    public boolean fsync_after_each_operation() {
        return this.fsync_after_each_operation.value();
    }

    public int revert_time_period() {
        return this.revert_time_period.value();
    }

    public int keep_remove_time_period() {
        return this.keep_remove_time_period.value();
    }

    public int maximum_versions_of_single_document_stored() {
        return this.maximum_versions_of_single_document_stored.value();
    }

    public List<Threads> threads() {
        return this.threads;
    }

    public Threads threads(int i) {
        return (Threads)((Object)this.threads.get(i));
    }

    public int max_priority_to_block() {
        return this.max_priority_to_block.value();
    }

    public int min_priority_to_be_blocking() {
        return this.min_priority_to_be_blocking.value();
    }

    public int bucket_merge_chunk_size() {
        return this.bucket_merge_chunk_size.value();
    }

    public int initial_index_read() {
        return this.initial_index_read.value();
    }

    public int initial_name_read() {
        return this.initial_name_read.value();
    }

    public int maximum_gap_to_read_through() {
        return this.maximum_gap_to_read_through.value();
    }

    public boolean remove_file_gaps_on_rewrite() {
        return this.remove_file_gaps_on_rewrite.value();
    }

    public Body_block_order.Enum body_block_order() {
        return (Body_block_order.Enum)((Object)this.body_block_order.value());
    }

    public boolean only_reorder_body_in_memory() {
        return this.only_reorder_body_in_memory.value();
    }

    public boolean verify_checksum_on_regular_load() {
        return this.verify_checksum_on_regular_load.value();
    }

    public boolean verify_checksum_on_visit() {
        return this.verify_checksum_on_visit.value();
    }

    public int maximum_sustainable_index_buffer_size() {
        return this.maximum_sustainable_index_buffer_size.value();
    }

    public int maximum_sustainable_input_buffer_size() {
        return this.maximum_sustainable_input_buffer_size.value();
    }

    public int maximum_sustainable_output_buffer_size() {
        return this.maximum_sustainable_output_buffer_size.value();
    }

    public boolean downsize_index_buffer_immediately_after_use() {
        return this.downsize_index_buffer_immediately_after_use.value();
    }

    public boolean downsize_input_buffer_immediately_after_use() {
        return this.downsize_input_buffer_immediately_after_use.value();
    }

    public boolean downsize_output_buffer_immediately_after_use() {
        return this.downsize_output_buffer_immediately_after_use.value();
    }

    public int minimum_continuous_file_write_buffer_size() {
        return this.minimum_continuous_file_write_buffer_size.value();
    }

    public int maximum_continuous_file_write_buffer_size() {
        return this.maximum_continuous_file_write_buffer_size.value();
    }

    public int minimum_join_source_body_read_buffer_size() {
        return this.minimum_join_source_body_read_buffer_size.value();
    }

    public int maximum_join_source_body_read_buffer_size() {
        return this.maximum_join_source_body_read_buffer_size.value();
    }

    public int minimum_export_source_body_read_buffer_size() {
        return this.minimum_export_source_body_read_buffer_size.value();
    }

    public int maximum_export_source_body_read_buffer_size() {
        return this.maximum_export_source_body_read_buffer_size.value();
    }

    public int minimum_defrag_source_body_read_buffer_size() {
        return this.minimum_defrag_source_body_read_buffer_size.value();
    }

    public int maximum_defrag_source_body_read_buffer_size() {
        return this.maximum_defrag_source_body_read_buffer_size.value();
    }

    public int common_merge_chain_optimalization_minimum_size() {
        return this.common_merge_chain_optimalization_minimum_size.value();
    }

    public boolean enable_merge_local_node_choose_docs_optimalization() {
        return this.enable_merge_local_node_choose_docs_optimalization.value();
    }

    public boolean read_only_used_header_part_when_possible() {
        return this.read_only_used_header_part_when_possible.value();
    }

    public boolean enable_slotfile_cache() {
        return this.enable_slotfile_cache.value();
    }

    public int slotfile_precache_header_after_access_count() {
        return this.slotfile_precache_header_after_access_count.value();
    }

    public boolean enable_multibit_split_optimalization() {
        return this.enable_multibit_split_optimalization.value();
    }

    public boolean use_direct_io() {
        return this.use_direct_io.value();
    }

    public int block_alignment_size() {
        return this.block_alignment_size.value();
    }

    public double disk_full_factor() {
        return this.disk_full_factor.value();
    }

    public double grow_factor() {
        return this.grow_factor.value();
    }

    public double min_fill_rate() {
        return this.min_fill_rate.value();
    }

    public double defrag_minimum_gain() {
        return this.defrag_minimum_gain.value();
    }

    public double overrepresent_meta_data_factor() {
        return this.overrepresent_meta_data_factor.value();
    }

    public double overrepresent_header_block_factor() {
        return this.overrepresent_header_block_factor.value();
    }

    public List<String> load_types_to_cache() {
        return this.load_types_to_cache.asList();
    }

    public String load_types_to_cache(int i) {
        return ((StringNode)this.load_types_to_cache.get(i)).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorFilestorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.use_new_core, (Node)newConfig.use_new_core, "use_new_core", "Use the new storage core");
        changes.compare((Node)this.dir_spread, (Node)newConfig.dir_spread, "dir_spread", "FILE LAYOUT PARAMETERS\n\nNumber of directories per level to spread files across\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.dir_levels, (Node)newConfig.dir_levels, "dir_levels", "Number of directory levels\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.fail_disk_after_error_count, (Node)newConfig.fail_disk_after_error_count, "fail_disk_after_error_count", "After seeing given number of errors on a disk, storage will disable the\ndisk and restart. If set to 0, storage will never disable disks. Note\nthat if you get disk errors, which arent automatically fixed, this will\nmake storage keep failing all operations towards this disk, and all\nretries will use the same disk and same file, so you might end up with a\nlot of operations that can never succeed. Thus, it is not recommended to\nturn this off.");
        changes.compare((Node)this.disk_operation_timeout, (Node)newConfig.disk_operation_timeout, "disk_operation_timeout", "If a disk operation takes more time in seconds than the disk operation\ntimeout, storage will consider that a disk failure, and mark the disk\nbad, restart and not use the disk anymore. Note that currently, this\nincludes CPU time too, so if used, this parameter should be set fairly\nhigh as we still sometimes have some operations that might take a few\nseconds. Disabled by default as we currently have these long operations\nduring normal load.");
        changes.compare((Node)this.debug_verifications, (Node)newConfig.debug_verifications, "debug_verifications", "Enabling debug verifications will make storage do extra verifications\nto find errors as soon as possible. These extra verifications will use up\na lot of resources though, and should not be needed in normal operations.\nThey are mostly to be used during test phases or when debugging problems.\nThe value itself is a bit mask, where you can enable different kinds of\nverifications by setting given bits.");
        changes.compare((Node)this.fsync_after_each_operation, (Node)newConfig.fsync_after_each_operation, "fsync_after_each_operation", "CONSISTENCY PARAMETERS\n\nIf true, fsync after all disk operations, to ensure no dirty OS file\ncache afterwards. This is only useful if using cached IO, which is not\nrecommended to start with.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compareArray(this.threads, newConfig.threads, "threads", CONFIG_DEF_VERSION, (a, b) -> ((Threads)a).getChangesRequiringRestart((Threads)b));
        changes.compare((Node)this.max_priority_to_block, (Node)newConfig.max_priority_to_block, "max_priority_to_block", "Pause operations (and block new ones from starting) with priority\nlower than this value when executing operations with higher pri than\nmin_priority_to_be_blocking");
        changes.compare((Node)this.min_priority_to_be_blocking, (Node)newConfig.min_priority_to_be_blocking, "min_priority_to_be_blocking", CONFIG_DEF_VERSION);
        changes.compare((Node)this.bucket_merge_chunk_size, (Node)newConfig.bucket_merge_chunk_size, "bucket_merge_chunk_size", "Chunksize to use while merging buckets between nodes.\n \nDefault is set to 4 MB - 4k. This is to allow for malloc to waste some bytes\nwith tracking info or to align to 512b without passing allocation limit,\nwhile still reading 4k blocks from disk.");
        changes.compare((Node)this.initial_name_read, (Node)newConfig.initial_name_read, "initial_name_read", "Similar to index read, when reading the document identifiers, one does\nnot know the length of the name prior to reading. Thus, if you read less\nthan the size, you will have to do an extra read to get the rest. If you\nuse very long document identifiers you should increase this value to be\nlarger than most of your identifiers.\nrestart flag was added automatically and needs to be verified.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.remove_file_gaps_on_rewrite, (Node)newConfig.remove_file_gaps_on_rewrite, "remove_file_gaps_on_rewrite", "Currently not in here as we dont have append functionality yet. Might\nimprove performance in some cases.\nmax_file_appends int default=0\n\nWhen writing with direct IO, we need to align blocks to 512b, and to\navoid reading we write garbage after each doc to fill 512b block. When\nresizing or splitting the file we can realign the files such that we\nremove the gaps of existing data, as we will rewrite everything anyhow.\nIf using very small documents this might improve your disk space\nutilization. For larger documents it doesnt really reduce much, so might\nbe useful to turn it off to save CPU.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.body_block_order, (Node)newConfig.body_block_order, "body_block_order", "The order we try to enforce in file body blocks. Visitors that only need\nto visit some of the data in a bucket will be able to read less if what\nit needs to read is located next to each other on disk. However, as we\ndont enforce order on write operations, this demands that resize/split\noperations do the resorting, which, if we cant do it all in memory is\nvery expensive. ANY will not do any reordering. Timestamp will enforce\ntimestamp order, which is fairly close to order that will normally be\nwritten anyway, so it should be cheap to reorder even if we cant do it\nall in memory. This might be useful if you often visit subsets based on\ntime. RGID uses reverse GID, which stores data from one location\ntogether. This is useful if you want to visit data from one user from\nbuckets that have many users often. This is a much more expensive sort\nthough, and should only be done if we have enough memory.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.only_reorder_body_in_memory, (Node)newConfig.only_reorder_body_in_memory, "only_reorder_body_in_memory", "If set to true, we will refuse to do reordering of memory unless we have\nenough memory to do it all in memory. See body_block_order comments.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.verify_checksum_on_regular_load, (Node)newConfig.verify_checksum_on_regular_load, "verify_checksum_on_regular_load", "Whether or not we should verify checksums of all read data during regular\noperations like put, get & remove. Note that some operations, like merge\nand bucket integrity verify operations will still check checksums even if\nthis is set false.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.verify_checksum_on_visit, (Node)newConfig.verify_checksum_on_visit, "verify_checksum_on_visit", "For streaming search, visiting is very performance critical. Thus you can\nspecifically disable checksum verification for visiting.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.maximum_sustainable_index_buffer_size, (Node)newConfig.maximum_sustainable_index_buffer_size, "maximum_sustainable_index_buffer_size", "Maximum size of index buffer that will be allowed to stay in memory and\nnot being reduced back to this size after we no longer need it.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.maximum_sustainable_input_buffer_size, (Node)newConfig.maximum_sustainable_input_buffer_size, "maximum_sustainable_input_buffer_size", "Maximum size of input buffer that will be allowed to stay in memory and\nnot being reduced back to this size after we no longer need it.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.maximum_sustainable_output_buffer_size, (Node)newConfig.maximum_sustainable_output_buffer_size, "maximum_sustainable_output_buffer_size", "Maximum size of output buffer that will be allowed to stay in memory and\nnot being reduced back to this size after we no longer need it.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.downsize_index_buffer_immediately_after_use, (Node)newConfig.downsize_index_buffer_immediately_after_use, "downsize_index_buffer_immediately_after_use", "Whether to downsize index buffer immediately after usage if its above the\nmaximum size. If not, it will not be resized down until someone requests\nto use it that needs less data in the buffer. Index buffer is used all\nthe time so there should be little reason for immediately downsizing it.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.downsize_input_buffer_immediately_after_use, (Node)newConfig.downsize_input_buffer_immediately_after_use, "downsize_input_buffer_immediately_after_use", "Whether to downsize input buffer immediately after usage if its above the\nmaximum size. If not, it will not be resized down until someone requests\nto use it that needs less data in the buffer. Input buffer is not used\nthat often, so downsizing it immediately might save some memory.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.downsize_output_buffer_immediately_after_use, (Node)newConfig.downsize_output_buffer_immediately_after_use, "downsize_output_buffer_immediately_after_use", "Whether to downsize output buffer immediately after usage if its above\nthe maximum size. If not, it will not be resized down until someone\nrequests to use it that needs less data in the buffer. Input buffer is\nnot used that often, so downsizing it immediately might save some memory.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.minimum_continuous_file_write_buffer_size, (Node)newConfig.minimum_continuous_file_write_buffer_size, "minimum_continuous_file_write_buffer_size", "Minimum size of buffer used to write a continuous file. If maximum amount\nof memory is not available. At least this amount will be allocated.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.maximum_continuous_file_write_buffer_size, (Node)newConfig.maximum_continuous_file_write_buffer_size, "maximum_continuous_file_write_buffer_size", "Maximum size of buffer used to write a continuous file. If set above max\nfile size we will always write new files in one go, which probably makes\nfor the least chance of getting fragmentation, but will also consume the\nmost memory. Default of writing a MB at a time, should make for little\nperformance loss because of disk seek time, and hopefully get little\nfragmentation while keeping memory usage down.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.minimum_join_source_body_read_buffer_size, (Node)newConfig.minimum_join_source_body_read_buffer_size, "minimum_join_source_body_read_buffer_size", "Minimum amount of memory allocated to read source data during join. This\namount of memory will be forced allocated.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.maximum_join_source_body_read_buffer_size, (Node)newConfig.maximum_join_source_body_read_buffer_size, "maximum_join_source_body_read_buffer_size", "This sets the maximum size of the buffer used in join to read source\ndata. Join uses the least IO if this buffer is as big as the body block\nof the source file. Due to the memory manager, each join might get that\nmuch memory though.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.minimum_export_source_body_read_buffer_size, (Node)newConfig.minimum_export_source_body_read_buffer_size, "minimum_export_source_body_read_buffer_size", "Minimum amount of memory allocated to read source data during export. This\namount of memory will be forced allocated.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.maximum_export_source_body_read_buffer_size, (Node)newConfig.maximum_export_source_body_read_buffer_size, "maximum_export_source_body_read_buffer_size", "This sets the maximum size of the buffer used in export to read source\ndata. Export uses the least IO if this buffer is as big as the body block\nof the source file. In addition, reordering of body block might not be\nfeasibly unless the buffer is big enough to include the whole body block.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.minimum_defrag_source_body_read_buffer_size, (Node)newConfig.minimum_defrag_source_body_read_buffer_size, "minimum_defrag_source_body_read_buffer_size", "Minimum size of buffer used to read data during defragmentation.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.maximum_defrag_source_body_read_buffer_size, (Node)newConfig.maximum_defrag_source_body_read_buffer_size, "maximum_defrag_source_body_read_buffer_size", "This sets the maximum size of the buffer used in defragmentation to read\nsource data. Defragmentation uses the least IO if this buffer is as big\nas the body block of the source file, but this might consume some memory.\nDefragmentation is not enabled by default.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.common_merge_chain_optimalization_minimum_size, (Node)newConfig.common_merge_chain_optimalization_minimum_size, "common_merge_chain_optimalization_minimum_size", "When merging, if we find more than this number of documents that exist on all\nof the same copies, send a separate apply bucket diff with these entries\nto an optimized merge chain that guarantuees minimum data transfer.");
        changes.compare((Node)this.enable_merge_local_node_choose_docs_optimalization, (Node)newConfig.enable_merge_local_node_choose_docs_optimalization, "enable_merge_local_node_choose_docs_optimalization", "When merging, it is possible to send more metadata than needed in order to\nlet local nodes in merge decide which entries fits best to add this time\nbased on disk location. Toggle this option on to use it. Note that memory\nconsumption might increase in a 4.1 to 4.2 upgrade due to this, as 4.1\ndont support to only fill in part of the metadata provided and will always\nfill all.");
        changes.compare((Node)this.read_only_used_header_part_when_possible, (Node)newConfig.read_only_used_header_part_when_possible, "read_only_used_header_part_when_possible", "If set, when we need to cache the entire header, and we already have cached\nall the metadata, read the metadata to find max header position, and only\nread the part containing information.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.enable_slotfile_cache, (Node)newConfig.enable_slotfile_cache, "enable_slotfile_cache", "Enable the slotfile read cache. The cache holds recent metadata and header\nblocks read from disks, and even if small, is very useful for localized\naccess.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.slotfile_precache_header_after_access_count, (Node)newConfig.slotfile_precache_header_after_access_count, "slotfile_precache_header_after_access_count", "Let the slotfile cache the whole header on a header only operation not\nneeding the entire header, if this amount of header only accesses needing\npart of the header has already happened.\n \nSet very high to begin with to never reduce performance. If you have heavy\nheader only access to some files, you may get better performance by tuning\nthis value.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.enable_multibit_split_optimalization, (Node)newConfig.enable_multibit_split_optimalization, "enable_multibit_split_optimalization", "Whether or not to enable the multibit split optimalization. This is useful\nif splitting is expensive, but listing document identifiers is fairly cheap.\nThis is true for memfile persistence layer, but not for vespa search.");
        changes.compare((Node)this.use_direct_io, (Node)newConfig.use_direct_io, "use_direct_io", "STORAGE SPACE vs IO/CPU PERFORMANCE OPTIONS\n\nIf true, use direct IO, bypassing OS caches for disk access. This is very\nuseful as VDS does a random distribution dividing load, so it is unlikely\nthat the OS cache will ever hit, and thus it is a huge performance drain.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.block_alignment_size, (Node)newConfig.block_alignment_size, "block_alignment_size", "All IO operations will be aligned to this amount of bytes if direct IO is\nenabled.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.disk_full_factor, (Node)newConfig.disk_full_factor, "disk_full_factor", "When a disk is fuller than this factor, we will not allow more data to be\nwritten to the system, unless this data is written in order to reduce\nstorage consumption, such as resizing files to become smaller or add\nmeta entries to write remove entries into. This value is set high as\ndefault as we expect a lot of users to have formatted their disks to\nalready reserve 8% of the data to root user which is often default. We\nsuggest using 0% reserved for root, and rather set this parameter lower\nto reserve space. That way, VDS have more space available in worst case\nin order to resize files to become smaller.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compare((Node)this.defrag_minimum_gain, (Node)newConfig.defrag_minimum_gain, "defrag_minimum_gain", "Minimum part of defragmented space one need to reclaim to allow\ndefragmentation of file. This value is given as a ratio of reclaimed\nspace compared to the total size of the data block.\nExample: A body block of 100 MB, has 15 MB free space, with largest\ncontinuos free space of 5 MB. Gain of defragmentation will then be 0.1.\nDEPRECATED: see stor-memfilepersistence config instead");
        changes.compareArray(this.load_types_to_cache, newConfig.load_types_to_cache, "load_types_to_cache", "Load types to use cache for. If empty, cache for all.\nDEPRECATED: see stor-memfilepersistence config instead", (a, b) -> new ChangesRequiringRestart("load_types_to_cache").compare(a, b, CONFIG_DEF_VERSION, "Load types to use cache for. If empty, cache for all.\nDEPRECATED: see stor-memfilepersistence config instead"));
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Body_block_order
    extends EnumNode<Enum> {
        public static final Enum ANY = Enum.ANY;
        public static final Enum TIMESTAMP = Enum.TIMESTAMP;
        public static final Enum RGID = Enum.RGID;

        public Body_block_order() {
            this.value = null;
        }

        public Body_block_order(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(@NonNull String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ANY,
            TIMESTAMP,
            RGID;

        }
    }

    public static final class Threads
    extends InnerNode {
        private final IntegerNode lowestpri;

        @Deprecated
        private Threads() {
            this(new Builder(), false);
        }

        public Threads(Builder builder) {
            this(builder, true);
        }

        private Threads(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-filestor.threads[] must be initialized: " + builder.__uninitialized);
            }
            this.lowestpri = builder.lowestpri == null ? new IntegerNode(255) : new IntegerNode(builder.lowestpri.intValue());
        }

        public int lowestpri() {
            return this.lowestpri.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Threads newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("threads");
            changes.compare((Node)this.lowestpri, (Node)newConfig.lowestpri, "lowestpri", "PERFORMANCE PARAMETERS\n\nNumber of threads to use for each mountpoint. VDS needs memory per thread\nto perform disk operations, so increasing this number will increase\nmemory usage, but it will also make the disk queue on a given disk be\nable to be larger, such that the disk can choose operations to optimize\nseek time.\nSee benchmarks for performance/memory tradeoff.");
            return changes;
        }

        private static InnerNodeVector<Threads> createVector(List<Builder> builders) {
            ArrayList<Threads> elems = new ArrayList<Threads>();
            for (Builder b : builders) {
                elems.add(new Threads(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Threads());
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer lowestpri = null;

            public Builder() {
            }

            public Builder(Threads config) {
                this.lowestpri(config.lowestpri());
            }

            private Builder override(Builder __superior) {
                if (__superior.lowestpri != null) {
                    this.lowestpri(__superior.lowestpri);
                }
                return this;
            }

            public Builder lowestpri(int __value) {
                this.lowestpri = __value;
                return this;
            }

            private Builder lowestpri(String __value) {
                return this.lowestpri(Integer.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean use_new_core = null;
        private Integer dir_spread = null;
        private Integer dir_levels = null;
        private Integer minimum_file_meta_slots = null;
        private Integer maximum_file_meta_slots = null;
        private Integer minimum_file_header_block_size = null;
        private Integer maximum_file_header_block_size = null;
        private Integer minimum_file_size = null;
        private Integer maximum_file_size = null;
        private Integer file_block_size = null;
        private Integer warn_on_slow_operations = null;
        private Integer fail_disk_after_error_count = null;
        private Integer disk_operation_timeout = null;
        private Integer time_future_limit = null;
        private Integer time_past_limit = null;
        private Integer debug_verifications = null;
        private Boolean fsync_after_each_operation = null;
        private Integer revert_time_period = null;
        private Integer keep_remove_time_period = null;
        private Integer maximum_versions_of_single_document_stored = null;
        public List<Threads.Builder> threads = new ArrayList<Threads.Builder>();
        private Integer max_priority_to_block = null;
        private Integer min_priority_to_be_blocking = null;
        private Integer bucket_merge_chunk_size = null;
        private Integer initial_index_read = null;
        private Integer initial_name_read = null;
        private Integer maximum_gap_to_read_through = null;
        private Boolean remove_file_gaps_on_rewrite = null;
        private Body_block_order.Enum body_block_order = null;
        private Boolean only_reorder_body_in_memory = null;
        private Boolean verify_checksum_on_regular_load = null;
        private Boolean verify_checksum_on_visit = null;
        private Integer maximum_sustainable_index_buffer_size = null;
        private Integer maximum_sustainable_input_buffer_size = null;
        private Integer maximum_sustainable_output_buffer_size = null;
        private Boolean downsize_index_buffer_immediately_after_use = null;
        private Boolean downsize_input_buffer_immediately_after_use = null;
        private Boolean downsize_output_buffer_immediately_after_use = null;
        private Integer minimum_continuous_file_write_buffer_size = null;
        private Integer maximum_continuous_file_write_buffer_size = null;
        private Integer minimum_join_source_body_read_buffer_size = null;
        private Integer maximum_join_source_body_read_buffer_size = null;
        private Integer minimum_export_source_body_read_buffer_size = null;
        private Integer maximum_export_source_body_read_buffer_size = null;
        private Integer minimum_defrag_source_body_read_buffer_size = null;
        private Integer maximum_defrag_source_body_read_buffer_size = null;
        private Integer common_merge_chain_optimalization_minimum_size = null;
        private Boolean enable_merge_local_node_choose_docs_optimalization = null;
        private Boolean read_only_used_header_part_when_possible = null;
        private Boolean enable_slotfile_cache = null;
        private Integer slotfile_precache_header_after_access_count = null;
        private Boolean enable_multibit_split_optimalization = null;
        private Boolean use_direct_io = null;
        private Integer block_alignment_size = null;
        private Double disk_full_factor = null;
        private Double grow_factor = null;
        private Double min_fill_rate = null;
        private Double defrag_minimum_gain = null;
        private Double overrepresent_meta_data_factor = null;
        private Double overrepresent_header_block_factor = null;
        public List<String> load_types_to_cache = new ArrayList<String>();

        public Builder() {
        }

        public Builder(StorFilestorConfig config) {
            this.use_new_core(config.use_new_core());
            this.dir_spread(config.dir_spread());
            this.dir_levels(config.dir_levels());
            this.minimum_file_meta_slots(config.minimum_file_meta_slots());
            this.maximum_file_meta_slots(config.maximum_file_meta_slots());
            this.minimum_file_header_block_size(config.minimum_file_header_block_size());
            this.maximum_file_header_block_size(config.maximum_file_header_block_size());
            this.minimum_file_size(config.minimum_file_size());
            this.maximum_file_size(config.maximum_file_size());
            this.file_block_size(config.file_block_size());
            this.warn_on_slow_operations(config.warn_on_slow_operations());
            this.fail_disk_after_error_count(config.fail_disk_after_error_count());
            this.disk_operation_timeout(config.disk_operation_timeout());
            this.time_future_limit(config.time_future_limit());
            this.time_past_limit(config.time_past_limit());
            this.debug_verifications(config.debug_verifications());
            this.fsync_after_each_operation(config.fsync_after_each_operation());
            this.revert_time_period(config.revert_time_period());
            this.keep_remove_time_period(config.keep_remove_time_period());
            this.maximum_versions_of_single_document_stored(config.maximum_versions_of_single_document_stored());
            for (Threads t : config.threads()) {
                this.threads(new Threads.Builder(t));
            }
            this.max_priority_to_block(config.max_priority_to_block());
            this.min_priority_to_be_blocking(config.min_priority_to_be_blocking());
            this.bucket_merge_chunk_size(config.bucket_merge_chunk_size());
            this.initial_index_read(config.initial_index_read());
            this.initial_name_read(config.initial_name_read());
            this.maximum_gap_to_read_through(config.maximum_gap_to_read_through());
            this.remove_file_gaps_on_rewrite(config.remove_file_gaps_on_rewrite());
            this.body_block_order(config.body_block_order());
            this.only_reorder_body_in_memory(config.only_reorder_body_in_memory());
            this.verify_checksum_on_regular_load(config.verify_checksum_on_regular_load());
            this.verify_checksum_on_visit(config.verify_checksum_on_visit());
            this.maximum_sustainable_index_buffer_size(config.maximum_sustainable_index_buffer_size());
            this.maximum_sustainable_input_buffer_size(config.maximum_sustainable_input_buffer_size());
            this.maximum_sustainable_output_buffer_size(config.maximum_sustainable_output_buffer_size());
            this.downsize_index_buffer_immediately_after_use(config.downsize_index_buffer_immediately_after_use());
            this.downsize_input_buffer_immediately_after_use(config.downsize_input_buffer_immediately_after_use());
            this.downsize_output_buffer_immediately_after_use(config.downsize_output_buffer_immediately_after_use());
            this.minimum_continuous_file_write_buffer_size(config.minimum_continuous_file_write_buffer_size());
            this.maximum_continuous_file_write_buffer_size(config.maximum_continuous_file_write_buffer_size());
            this.minimum_join_source_body_read_buffer_size(config.minimum_join_source_body_read_buffer_size());
            this.maximum_join_source_body_read_buffer_size(config.maximum_join_source_body_read_buffer_size());
            this.minimum_export_source_body_read_buffer_size(config.minimum_export_source_body_read_buffer_size());
            this.maximum_export_source_body_read_buffer_size(config.maximum_export_source_body_read_buffer_size());
            this.minimum_defrag_source_body_read_buffer_size(config.minimum_defrag_source_body_read_buffer_size());
            this.maximum_defrag_source_body_read_buffer_size(config.maximum_defrag_source_body_read_buffer_size());
            this.common_merge_chain_optimalization_minimum_size(config.common_merge_chain_optimalization_minimum_size());
            this.enable_merge_local_node_choose_docs_optimalization(config.enable_merge_local_node_choose_docs_optimalization());
            this.read_only_used_header_part_when_possible(config.read_only_used_header_part_when_possible());
            this.enable_slotfile_cache(config.enable_slotfile_cache());
            this.slotfile_precache_header_after_access_count(config.slotfile_precache_header_after_access_count());
            this.enable_multibit_split_optimalization(config.enable_multibit_split_optimalization());
            this.use_direct_io(config.use_direct_io());
            this.block_alignment_size(config.block_alignment_size());
            this.disk_full_factor(config.disk_full_factor());
            this.grow_factor(config.grow_factor());
            this.min_fill_rate(config.min_fill_rate());
            this.defrag_minimum_gain(config.defrag_minimum_gain());
            this.overrepresent_meta_data_factor(config.overrepresent_meta_data_factor());
            this.overrepresent_header_block_factor(config.overrepresent_header_block_factor());
            this.load_types_to_cache(config.load_types_to_cache());
        }

        private Builder override(Builder __superior) {
            if (__superior.use_new_core != null) {
                this.use_new_core(__superior.use_new_core);
            }
            if (__superior.dir_spread != null) {
                this.dir_spread(__superior.dir_spread);
            }
            if (__superior.dir_levels != null) {
                this.dir_levels(__superior.dir_levels);
            }
            if (__superior.minimum_file_meta_slots != null) {
                this.minimum_file_meta_slots(__superior.minimum_file_meta_slots);
            }
            if (__superior.maximum_file_meta_slots != null) {
                this.maximum_file_meta_slots(__superior.maximum_file_meta_slots);
            }
            if (__superior.minimum_file_header_block_size != null) {
                this.minimum_file_header_block_size(__superior.minimum_file_header_block_size);
            }
            if (__superior.maximum_file_header_block_size != null) {
                this.maximum_file_header_block_size(__superior.maximum_file_header_block_size);
            }
            if (__superior.minimum_file_size != null) {
                this.minimum_file_size(__superior.minimum_file_size);
            }
            if (__superior.maximum_file_size != null) {
                this.maximum_file_size(__superior.maximum_file_size);
            }
            if (__superior.file_block_size != null) {
                this.file_block_size(__superior.file_block_size);
            }
            if (__superior.warn_on_slow_operations != null) {
                this.warn_on_slow_operations(__superior.warn_on_slow_operations);
            }
            if (__superior.fail_disk_after_error_count != null) {
                this.fail_disk_after_error_count(__superior.fail_disk_after_error_count);
            }
            if (__superior.disk_operation_timeout != null) {
                this.disk_operation_timeout(__superior.disk_operation_timeout);
            }
            if (__superior.time_future_limit != null) {
                this.time_future_limit(__superior.time_future_limit);
            }
            if (__superior.time_past_limit != null) {
                this.time_past_limit(__superior.time_past_limit);
            }
            if (__superior.debug_verifications != null) {
                this.debug_verifications(__superior.debug_verifications);
            }
            if (__superior.fsync_after_each_operation != null) {
                this.fsync_after_each_operation(__superior.fsync_after_each_operation);
            }
            if (__superior.revert_time_period != null) {
                this.revert_time_period(__superior.revert_time_period);
            }
            if (__superior.keep_remove_time_period != null) {
                this.keep_remove_time_period(__superior.keep_remove_time_period);
            }
            if (__superior.maximum_versions_of_single_document_stored != null) {
                this.maximum_versions_of_single_document_stored(__superior.maximum_versions_of_single_document_stored);
            }
            if (!__superior.threads.isEmpty()) {
                this.threads.addAll(__superior.threads);
            }
            if (__superior.max_priority_to_block != null) {
                this.max_priority_to_block(__superior.max_priority_to_block);
            }
            if (__superior.min_priority_to_be_blocking != null) {
                this.min_priority_to_be_blocking(__superior.min_priority_to_be_blocking);
            }
            if (__superior.bucket_merge_chunk_size != null) {
                this.bucket_merge_chunk_size(__superior.bucket_merge_chunk_size);
            }
            if (__superior.initial_index_read != null) {
                this.initial_index_read(__superior.initial_index_read);
            }
            if (__superior.initial_name_read != null) {
                this.initial_name_read(__superior.initial_name_read);
            }
            if (__superior.maximum_gap_to_read_through != null) {
                this.maximum_gap_to_read_through(__superior.maximum_gap_to_read_through);
            }
            if (__superior.remove_file_gaps_on_rewrite != null) {
                this.remove_file_gaps_on_rewrite(__superior.remove_file_gaps_on_rewrite);
            }
            if (__superior.body_block_order != null) {
                this.body_block_order(__superior.body_block_order);
            }
            if (__superior.only_reorder_body_in_memory != null) {
                this.only_reorder_body_in_memory(__superior.only_reorder_body_in_memory);
            }
            if (__superior.verify_checksum_on_regular_load != null) {
                this.verify_checksum_on_regular_load(__superior.verify_checksum_on_regular_load);
            }
            if (__superior.verify_checksum_on_visit != null) {
                this.verify_checksum_on_visit(__superior.verify_checksum_on_visit);
            }
            if (__superior.maximum_sustainable_index_buffer_size != null) {
                this.maximum_sustainable_index_buffer_size(__superior.maximum_sustainable_index_buffer_size);
            }
            if (__superior.maximum_sustainable_input_buffer_size != null) {
                this.maximum_sustainable_input_buffer_size(__superior.maximum_sustainable_input_buffer_size);
            }
            if (__superior.maximum_sustainable_output_buffer_size != null) {
                this.maximum_sustainable_output_buffer_size(__superior.maximum_sustainable_output_buffer_size);
            }
            if (__superior.downsize_index_buffer_immediately_after_use != null) {
                this.downsize_index_buffer_immediately_after_use(__superior.downsize_index_buffer_immediately_after_use);
            }
            if (__superior.downsize_input_buffer_immediately_after_use != null) {
                this.downsize_input_buffer_immediately_after_use(__superior.downsize_input_buffer_immediately_after_use);
            }
            if (__superior.downsize_output_buffer_immediately_after_use != null) {
                this.downsize_output_buffer_immediately_after_use(__superior.downsize_output_buffer_immediately_after_use);
            }
            if (__superior.minimum_continuous_file_write_buffer_size != null) {
                this.minimum_continuous_file_write_buffer_size(__superior.minimum_continuous_file_write_buffer_size);
            }
            if (__superior.maximum_continuous_file_write_buffer_size != null) {
                this.maximum_continuous_file_write_buffer_size(__superior.maximum_continuous_file_write_buffer_size);
            }
            if (__superior.minimum_join_source_body_read_buffer_size != null) {
                this.minimum_join_source_body_read_buffer_size(__superior.minimum_join_source_body_read_buffer_size);
            }
            if (__superior.maximum_join_source_body_read_buffer_size != null) {
                this.maximum_join_source_body_read_buffer_size(__superior.maximum_join_source_body_read_buffer_size);
            }
            if (__superior.minimum_export_source_body_read_buffer_size != null) {
                this.minimum_export_source_body_read_buffer_size(__superior.minimum_export_source_body_read_buffer_size);
            }
            if (__superior.maximum_export_source_body_read_buffer_size != null) {
                this.maximum_export_source_body_read_buffer_size(__superior.maximum_export_source_body_read_buffer_size);
            }
            if (__superior.minimum_defrag_source_body_read_buffer_size != null) {
                this.minimum_defrag_source_body_read_buffer_size(__superior.minimum_defrag_source_body_read_buffer_size);
            }
            if (__superior.maximum_defrag_source_body_read_buffer_size != null) {
                this.maximum_defrag_source_body_read_buffer_size(__superior.maximum_defrag_source_body_read_buffer_size);
            }
            if (__superior.common_merge_chain_optimalization_minimum_size != null) {
                this.common_merge_chain_optimalization_minimum_size(__superior.common_merge_chain_optimalization_minimum_size);
            }
            if (__superior.enable_merge_local_node_choose_docs_optimalization != null) {
                this.enable_merge_local_node_choose_docs_optimalization(__superior.enable_merge_local_node_choose_docs_optimalization);
            }
            if (__superior.read_only_used_header_part_when_possible != null) {
                this.read_only_used_header_part_when_possible(__superior.read_only_used_header_part_when_possible);
            }
            if (__superior.enable_slotfile_cache != null) {
                this.enable_slotfile_cache(__superior.enable_slotfile_cache);
            }
            if (__superior.slotfile_precache_header_after_access_count != null) {
                this.slotfile_precache_header_after_access_count(__superior.slotfile_precache_header_after_access_count);
            }
            if (__superior.enable_multibit_split_optimalization != null) {
                this.enable_multibit_split_optimalization(__superior.enable_multibit_split_optimalization);
            }
            if (__superior.use_direct_io != null) {
                this.use_direct_io(__superior.use_direct_io);
            }
            if (__superior.block_alignment_size != null) {
                this.block_alignment_size(__superior.block_alignment_size);
            }
            if (__superior.disk_full_factor != null) {
                this.disk_full_factor(__superior.disk_full_factor);
            }
            if (__superior.grow_factor != null) {
                this.grow_factor(__superior.grow_factor);
            }
            if (__superior.min_fill_rate != null) {
                this.min_fill_rate(__superior.min_fill_rate);
            }
            if (__superior.defrag_minimum_gain != null) {
                this.defrag_minimum_gain(__superior.defrag_minimum_gain);
            }
            if (__superior.overrepresent_meta_data_factor != null) {
                this.overrepresent_meta_data_factor(__superior.overrepresent_meta_data_factor);
            }
            if (__superior.overrepresent_header_block_factor != null) {
                this.overrepresent_header_block_factor(__superior.overrepresent_header_block_factor);
            }
            if (!__superior.load_types_to_cache.isEmpty()) {
                this.load_types_to_cache.addAll(__superior.load_types_to_cache);
            }
            return this;
        }

        public Builder use_new_core(boolean __value) {
            this.use_new_core = __value;
            return this;
        }

        private Builder use_new_core(String __value) {
            return this.use_new_core(Boolean.valueOf(__value));
        }

        public Builder dir_spread(int __value) {
            this.dir_spread = __value;
            return this;
        }

        private Builder dir_spread(String __value) {
            return this.dir_spread(Integer.valueOf(__value));
        }

        public Builder dir_levels(int __value) {
            this.dir_levels = __value;
            return this;
        }

        private Builder dir_levels(String __value) {
            return this.dir_levels(Integer.valueOf(__value));
        }

        public Builder minimum_file_meta_slots(int __value) {
            this.minimum_file_meta_slots = __value;
            return this;
        }

        private Builder minimum_file_meta_slots(String __value) {
            return this.minimum_file_meta_slots(Integer.valueOf(__value));
        }

        public Builder maximum_file_meta_slots(int __value) {
            this.maximum_file_meta_slots = __value;
            return this;
        }

        private Builder maximum_file_meta_slots(String __value) {
            return this.maximum_file_meta_slots(Integer.valueOf(__value));
        }

        public Builder minimum_file_header_block_size(int __value) {
            this.minimum_file_header_block_size = __value;
            return this;
        }

        private Builder minimum_file_header_block_size(String __value) {
            return this.minimum_file_header_block_size(Integer.valueOf(__value));
        }

        public Builder maximum_file_header_block_size(int __value) {
            this.maximum_file_header_block_size = __value;
            return this;
        }

        private Builder maximum_file_header_block_size(String __value) {
            return this.maximum_file_header_block_size(Integer.valueOf(__value));
        }

        public Builder minimum_file_size(int __value) {
            this.minimum_file_size = __value;
            return this;
        }

        private Builder minimum_file_size(String __value) {
            return this.minimum_file_size(Integer.valueOf(__value));
        }

        public Builder maximum_file_size(int __value) {
            this.maximum_file_size = __value;
            return this;
        }

        private Builder maximum_file_size(String __value) {
            return this.maximum_file_size(Integer.valueOf(__value));
        }

        public Builder file_block_size(int __value) {
            this.file_block_size = __value;
            return this;
        }

        private Builder file_block_size(String __value) {
            return this.file_block_size(Integer.valueOf(__value));
        }

        public Builder warn_on_slow_operations(int __value) {
            this.warn_on_slow_operations = __value;
            return this;
        }

        private Builder warn_on_slow_operations(String __value) {
            return this.warn_on_slow_operations(Integer.valueOf(__value));
        }

        public Builder fail_disk_after_error_count(int __value) {
            this.fail_disk_after_error_count = __value;
            return this;
        }

        private Builder fail_disk_after_error_count(String __value) {
            return this.fail_disk_after_error_count(Integer.valueOf(__value));
        }

        public Builder disk_operation_timeout(int __value) {
            this.disk_operation_timeout = __value;
            return this;
        }

        private Builder disk_operation_timeout(String __value) {
            return this.disk_operation_timeout(Integer.valueOf(__value));
        }

        public Builder time_future_limit(int __value) {
            this.time_future_limit = __value;
            return this;
        }

        private Builder time_future_limit(String __value) {
            return this.time_future_limit(Integer.valueOf(__value));
        }

        public Builder time_past_limit(int __value) {
            this.time_past_limit = __value;
            return this;
        }

        private Builder time_past_limit(String __value) {
            return this.time_past_limit(Integer.valueOf(__value));
        }

        public Builder debug_verifications(int __value) {
            this.debug_verifications = __value;
            return this;
        }

        private Builder debug_verifications(String __value) {
            return this.debug_verifications(Integer.valueOf(__value));
        }

        public Builder fsync_after_each_operation(boolean __value) {
            this.fsync_after_each_operation = __value;
            return this;
        }

        private Builder fsync_after_each_operation(String __value) {
            return this.fsync_after_each_operation(Boolean.valueOf(__value));
        }

        public Builder revert_time_period(int __value) {
            this.revert_time_period = __value;
            return this;
        }

        private Builder revert_time_period(String __value) {
            return this.revert_time_period(Integer.valueOf(__value));
        }

        public Builder keep_remove_time_period(int __value) {
            this.keep_remove_time_period = __value;
            return this;
        }

        private Builder keep_remove_time_period(String __value) {
            return this.keep_remove_time_period(Integer.valueOf(__value));
        }

        public Builder maximum_versions_of_single_document_stored(int __value) {
            this.maximum_versions_of_single_document_stored = __value;
            return this;
        }

        private Builder maximum_versions_of_single_document_stored(String __value) {
            return this.maximum_versions_of_single_document_stored(Integer.valueOf(__value));
        }

        public Builder threads(Threads.Builder __builder) {
            this.threads.add(__builder);
            return this;
        }

        public Builder threads(List<Threads.Builder> __builders) {
            this.threads = __builders;
            return this;
        }

        public Builder max_priority_to_block(int __value) {
            this.max_priority_to_block = __value;
            return this;
        }

        private Builder max_priority_to_block(String __value) {
            return this.max_priority_to_block(Integer.valueOf(__value));
        }

        public Builder min_priority_to_be_blocking(int __value) {
            this.min_priority_to_be_blocking = __value;
            return this;
        }

        private Builder min_priority_to_be_blocking(String __value) {
            return this.min_priority_to_be_blocking(Integer.valueOf(__value));
        }

        public Builder bucket_merge_chunk_size(int __value) {
            this.bucket_merge_chunk_size = __value;
            return this;
        }

        private Builder bucket_merge_chunk_size(String __value) {
            return this.bucket_merge_chunk_size(Integer.valueOf(__value));
        }

        public Builder initial_index_read(int __value) {
            this.initial_index_read = __value;
            return this;
        }

        private Builder initial_index_read(String __value) {
            return this.initial_index_read(Integer.valueOf(__value));
        }

        public Builder initial_name_read(int __value) {
            this.initial_name_read = __value;
            return this;
        }

        private Builder initial_name_read(String __value) {
            return this.initial_name_read(Integer.valueOf(__value));
        }

        public Builder maximum_gap_to_read_through(int __value) {
            this.maximum_gap_to_read_through = __value;
            return this;
        }

        private Builder maximum_gap_to_read_through(String __value) {
            return this.maximum_gap_to_read_through(Integer.valueOf(__value));
        }

        public Builder remove_file_gaps_on_rewrite(boolean __value) {
            this.remove_file_gaps_on_rewrite = __value;
            return this;
        }

        private Builder remove_file_gaps_on_rewrite(String __value) {
            return this.remove_file_gaps_on_rewrite(Boolean.valueOf(__value));
        }

        public Builder body_block_order(Body_block_order.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.body_block_order = __value;
            return this;
        }

        private Builder body_block_order(String __value) {
            return this.body_block_order(Body_block_order.Enum.valueOf(__value));
        }

        public Builder only_reorder_body_in_memory(boolean __value) {
            this.only_reorder_body_in_memory = __value;
            return this;
        }

        private Builder only_reorder_body_in_memory(String __value) {
            return this.only_reorder_body_in_memory(Boolean.valueOf(__value));
        }

        public Builder verify_checksum_on_regular_load(boolean __value) {
            this.verify_checksum_on_regular_load = __value;
            return this;
        }

        private Builder verify_checksum_on_regular_load(String __value) {
            return this.verify_checksum_on_regular_load(Boolean.valueOf(__value));
        }

        public Builder verify_checksum_on_visit(boolean __value) {
            this.verify_checksum_on_visit = __value;
            return this;
        }

        private Builder verify_checksum_on_visit(String __value) {
            return this.verify_checksum_on_visit(Boolean.valueOf(__value));
        }

        public Builder maximum_sustainable_index_buffer_size(int __value) {
            this.maximum_sustainable_index_buffer_size = __value;
            return this;
        }

        private Builder maximum_sustainable_index_buffer_size(String __value) {
            return this.maximum_sustainable_index_buffer_size(Integer.valueOf(__value));
        }

        public Builder maximum_sustainable_input_buffer_size(int __value) {
            this.maximum_sustainable_input_buffer_size = __value;
            return this;
        }

        private Builder maximum_sustainable_input_buffer_size(String __value) {
            return this.maximum_sustainable_input_buffer_size(Integer.valueOf(__value));
        }

        public Builder maximum_sustainable_output_buffer_size(int __value) {
            this.maximum_sustainable_output_buffer_size = __value;
            return this;
        }

        private Builder maximum_sustainable_output_buffer_size(String __value) {
            return this.maximum_sustainable_output_buffer_size(Integer.valueOf(__value));
        }

        public Builder downsize_index_buffer_immediately_after_use(boolean __value) {
            this.downsize_index_buffer_immediately_after_use = __value;
            return this;
        }

        private Builder downsize_index_buffer_immediately_after_use(String __value) {
            return this.downsize_index_buffer_immediately_after_use(Boolean.valueOf(__value));
        }

        public Builder downsize_input_buffer_immediately_after_use(boolean __value) {
            this.downsize_input_buffer_immediately_after_use = __value;
            return this;
        }

        private Builder downsize_input_buffer_immediately_after_use(String __value) {
            return this.downsize_input_buffer_immediately_after_use(Boolean.valueOf(__value));
        }

        public Builder downsize_output_buffer_immediately_after_use(boolean __value) {
            this.downsize_output_buffer_immediately_after_use = __value;
            return this;
        }

        private Builder downsize_output_buffer_immediately_after_use(String __value) {
            return this.downsize_output_buffer_immediately_after_use(Boolean.valueOf(__value));
        }

        public Builder minimum_continuous_file_write_buffer_size(int __value) {
            this.minimum_continuous_file_write_buffer_size = __value;
            return this;
        }

        private Builder minimum_continuous_file_write_buffer_size(String __value) {
            return this.minimum_continuous_file_write_buffer_size(Integer.valueOf(__value));
        }

        public Builder maximum_continuous_file_write_buffer_size(int __value) {
            this.maximum_continuous_file_write_buffer_size = __value;
            return this;
        }

        private Builder maximum_continuous_file_write_buffer_size(String __value) {
            return this.maximum_continuous_file_write_buffer_size(Integer.valueOf(__value));
        }

        public Builder minimum_join_source_body_read_buffer_size(int __value) {
            this.minimum_join_source_body_read_buffer_size = __value;
            return this;
        }

        private Builder minimum_join_source_body_read_buffer_size(String __value) {
            return this.minimum_join_source_body_read_buffer_size(Integer.valueOf(__value));
        }

        public Builder maximum_join_source_body_read_buffer_size(int __value) {
            this.maximum_join_source_body_read_buffer_size = __value;
            return this;
        }

        private Builder maximum_join_source_body_read_buffer_size(String __value) {
            return this.maximum_join_source_body_read_buffer_size(Integer.valueOf(__value));
        }

        public Builder minimum_export_source_body_read_buffer_size(int __value) {
            this.minimum_export_source_body_read_buffer_size = __value;
            return this;
        }

        private Builder minimum_export_source_body_read_buffer_size(String __value) {
            return this.minimum_export_source_body_read_buffer_size(Integer.valueOf(__value));
        }

        public Builder maximum_export_source_body_read_buffer_size(int __value) {
            this.maximum_export_source_body_read_buffer_size = __value;
            return this;
        }

        private Builder maximum_export_source_body_read_buffer_size(String __value) {
            return this.maximum_export_source_body_read_buffer_size(Integer.valueOf(__value));
        }

        public Builder minimum_defrag_source_body_read_buffer_size(int __value) {
            this.minimum_defrag_source_body_read_buffer_size = __value;
            return this;
        }

        private Builder minimum_defrag_source_body_read_buffer_size(String __value) {
            return this.minimum_defrag_source_body_read_buffer_size(Integer.valueOf(__value));
        }

        public Builder maximum_defrag_source_body_read_buffer_size(int __value) {
            this.maximum_defrag_source_body_read_buffer_size = __value;
            return this;
        }

        private Builder maximum_defrag_source_body_read_buffer_size(String __value) {
            return this.maximum_defrag_source_body_read_buffer_size(Integer.valueOf(__value));
        }

        public Builder common_merge_chain_optimalization_minimum_size(int __value) {
            this.common_merge_chain_optimalization_minimum_size = __value;
            return this;
        }

        private Builder common_merge_chain_optimalization_minimum_size(String __value) {
            return this.common_merge_chain_optimalization_minimum_size(Integer.valueOf(__value));
        }

        public Builder enable_merge_local_node_choose_docs_optimalization(boolean __value) {
            this.enable_merge_local_node_choose_docs_optimalization = __value;
            return this;
        }

        private Builder enable_merge_local_node_choose_docs_optimalization(String __value) {
            return this.enable_merge_local_node_choose_docs_optimalization(Boolean.valueOf(__value));
        }

        public Builder read_only_used_header_part_when_possible(boolean __value) {
            this.read_only_used_header_part_when_possible = __value;
            return this;
        }

        private Builder read_only_used_header_part_when_possible(String __value) {
            return this.read_only_used_header_part_when_possible(Boolean.valueOf(__value));
        }

        public Builder enable_slotfile_cache(boolean __value) {
            this.enable_slotfile_cache = __value;
            return this;
        }

        private Builder enable_slotfile_cache(String __value) {
            return this.enable_slotfile_cache(Boolean.valueOf(__value));
        }

        public Builder slotfile_precache_header_after_access_count(int __value) {
            this.slotfile_precache_header_after_access_count = __value;
            return this;
        }

        private Builder slotfile_precache_header_after_access_count(String __value) {
            return this.slotfile_precache_header_after_access_count(Integer.valueOf(__value));
        }

        public Builder enable_multibit_split_optimalization(boolean __value) {
            this.enable_multibit_split_optimalization = __value;
            return this;
        }

        private Builder enable_multibit_split_optimalization(String __value) {
            return this.enable_multibit_split_optimalization(Boolean.valueOf(__value));
        }

        public Builder use_direct_io(boolean __value) {
            this.use_direct_io = __value;
            return this;
        }

        private Builder use_direct_io(String __value) {
            return this.use_direct_io(Boolean.valueOf(__value));
        }

        public Builder block_alignment_size(int __value) {
            this.block_alignment_size = __value;
            return this;
        }

        private Builder block_alignment_size(String __value) {
            return this.block_alignment_size(Integer.valueOf(__value));
        }

        public Builder disk_full_factor(double __value) {
            this.disk_full_factor = __value;
            return this;
        }

        private Builder disk_full_factor(String __value) {
            return this.disk_full_factor(Double.valueOf(__value));
        }

        public Builder grow_factor(double __value) {
            this.grow_factor = __value;
            return this;
        }

        private Builder grow_factor(String __value) {
            return this.grow_factor(Double.valueOf(__value));
        }

        public Builder min_fill_rate(double __value) {
            this.min_fill_rate = __value;
            return this;
        }

        private Builder min_fill_rate(String __value) {
            return this.min_fill_rate(Double.valueOf(__value));
        }

        public Builder defrag_minimum_gain(double __value) {
            this.defrag_minimum_gain = __value;
            return this;
        }

        private Builder defrag_minimum_gain(String __value) {
            return this.defrag_minimum_gain(Double.valueOf(__value));
        }

        public Builder overrepresent_meta_data_factor(double __value) {
            this.overrepresent_meta_data_factor = __value;
            return this;
        }

        private Builder overrepresent_meta_data_factor(String __value) {
            return this.overrepresent_meta_data_factor(Double.valueOf(__value));
        }

        public Builder overrepresent_header_block_factor(double __value) {
            this.overrepresent_header_block_factor = __value;
            return this;
        }

        private Builder overrepresent_header_block_factor(String __value) {
            return this.overrepresent_header_block_factor(Double.valueOf(__value));
        }

        public Builder load_types_to_cache(String __value) {
            this.load_types_to_cache.add(__value);
            return this;
        }

        public Builder load_types_to_cache(Collection<String> __values) {
            this.load_types_to_cache.addAll(__values);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorFilestorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorFilestorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorFilestorConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

