/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.storage;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StorMemfilepersistenceConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "56644cf408a34a193f91ad38729ef228";
    public static final String CONFIG_DEF_NAME = "stor-memfilepersistence";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.storage";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.storage", "dir_spread int default=256 restart", "dir_levels int default=1 restart", "minimum_file_meta_slots int default=512", "maximum_file_meta_slots int default=13106", "minimum_file_header_block_size int default=102848", "maximum_file_header_block_size int default=33554432", "minimum_file_size int default=1048576", "maximum_file_size int default=268431360", "file_block_size int default=4096 restart", "fsync_after_each_operation bool default=false restart", "revert_time_period int default=300", "keep_remove_time_period int default=604800", "threads[].lowestpri int default=255 restart", "max_priority_to_block int default=255 restart", "min_priority_to_be_blocking int default=0 restart", "initial_index_read int default=61440", "maximum_gap_to_read_through int default=65536", "cache_size long default=1073741824 restart", "cache_size_meta_percentage long default=33 restart", "cache_size_header_percentage long default=33 restart", "cache_size_body_percentage long default=34 restart", "disk_full_factor double default=0.98 restart", "disk_full_factor_move double default=0.80 restart", "grow_factor double default=2.0", "min_fill_rate double default=0.1", "overrepresent_meta_data_factor double default=1.2", "overrepresent_header_block_factor double default=1.1", "store_50_backwards_compatible_remove_entries_with_doctype string default=\"\""};
    private final IntegerNode dir_spread;
    private final IntegerNode dir_levels;
    private final IntegerNode minimum_file_meta_slots;
    private final IntegerNode maximum_file_meta_slots;
    private final IntegerNode minimum_file_header_block_size;
    private final IntegerNode maximum_file_header_block_size;
    private final IntegerNode minimum_file_size;
    private final IntegerNode maximum_file_size;
    private final IntegerNode file_block_size;
    private final BooleanNode fsync_after_each_operation;
    private final IntegerNode revert_time_period;
    private final IntegerNode keep_remove_time_period;
    private final InnerNodeVector<Threads> threads;
    private final IntegerNode max_priority_to_block;
    private final IntegerNode min_priority_to_be_blocking;
    private final IntegerNode initial_index_read;
    private final IntegerNode maximum_gap_to_read_through;
    private final LongNode cache_size;
    private final LongNode cache_size_meta_percentage;
    private final LongNode cache_size_header_percentage;
    private final LongNode cache_size_body_percentage;
    private final DoubleNode disk_full_factor;
    private final DoubleNode disk_full_factor_move;
    private final DoubleNode grow_factor;
    private final DoubleNode min_fill_rate;
    private final DoubleNode overrepresent_meta_data_factor;
    private final DoubleNode overrepresent_header_block_factor;
    private final StringNode store_50_backwards_compatible_remove_entries_with_doctype;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorMemfilepersistenceConfig(Builder builder) {
        this(builder, true);
    }

    private StorMemfilepersistenceConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-memfilepersistence must be initialized: " + builder.__uninitialized);
        }
        this.dir_spread = builder.dir_spread == null ? new IntegerNode(256) : new IntegerNode(builder.dir_spread.intValue());
        this.dir_levels = builder.dir_levels == null ? new IntegerNode(1) : new IntegerNode(builder.dir_levels.intValue());
        this.minimum_file_meta_slots = builder.minimum_file_meta_slots == null ? new IntegerNode(512) : new IntegerNode(builder.minimum_file_meta_slots.intValue());
        this.maximum_file_meta_slots = builder.maximum_file_meta_slots == null ? new IntegerNode(13106) : new IntegerNode(builder.maximum_file_meta_slots.intValue());
        this.minimum_file_header_block_size = builder.minimum_file_header_block_size == null ? new IntegerNode(102848) : new IntegerNode(builder.minimum_file_header_block_size.intValue());
        this.maximum_file_header_block_size = builder.maximum_file_header_block_size == null ? new IntegerNode(0x2000000) : new IntegerNode(builder.maximum_file_header_block_size.intValue());
        this.minimum_file_size = builder.minimum_file_size == null ? new IntegerNode(0x100000) : new IntegerNode(builder.minimum_file_size.intValue());
        this.maximum_file_size = builder.maximum_file_size == null ? new IntegerNode(0xFFFF000) : new IntegerNode(builder.maximum_file_size.intValue());
        this.file_block_size = builder.file_block_size == null ? new IntegerNode(4096) : new IntegerNode(builder.file_block_size.intValue());
        this.fsync_after_each_operation = builder.fsync_after_each_operation == null ? new BooleanNode(false) : new BooleanNode(builder.fsync_after_each_operation.booleanValue());
        this.revert_time_period = builder.revert_time_period == null ? new IntegerNode(300) : new IntegerNode(builder.revert_time_period.intValue());
        this.keep_remove_time_period = builder.keep_remove_time_period == null ? new IntegerNode(604800) : new IntegerNode(builder.keep_remove_time_period.intValue());
        this.threads = Threads.createVector(builder.threads);
        this.max_priority_to_block = builder.max_priority_to_block == null ? new IntegerNode(255) : new IntegerNode(builder.max_priority_to_block.intValue());
        this.min_priority_to_be_blocking = builder.min_priority_to_be_blocking == null ? new IntegerNode(0) : new IntegerNode(builder.min_priority_to_be_blocking.intValue());
        this.initial_index_read = builder.initial_index_read == null ? new IntegerNode(61440) : new IntegerNode(builder.initial_index_read.intValue());
        this.maximum_gap_to_read_through = builder.maximum_gap_to_read_through == null ? new IntegerNode(65536) : new IntegerNode(builder.maximum_gap_to_read_through.intValue());
        this.cache_size = builder.cache_size == null ? new LongNode(0x40000000L) : new LongNode(builder.cache_size.longValue());
        this.cache_size_meta_percentage = builder.cache_size_meta_percentage == null ? new LongNode(33L) : new LongNode(builder.cache_size_meta_percentage.longValue());
        this.cache_size_header_percentage = builder.cache_size_header_percentage == null ? new LongNode(33L) : new LongNode(builder.cache_size_header_percentage.longValue());
        this.cache_size_body_percentage = builder.cache_size_body_percentage == null ? new LongNode(34L) : new LongNode(builder.cache_size_body_percentage.longValue());
        this.disk_full_factor = builder.disk_full_factor == null ? new DoubleNode(0.98) : new DoubleNode(builder.disk_full_factor.doubleValue());
        this.disk_full_factor_move = builder.disk_full_factor_move == null ? new DoubleNode(0.8) : new DoubleNode(builder.disk_full_factor_move.doubleValue());
        this.grow_factor = builder.grow_factor == null ? new DoubleNode(2.0) : new DoubleNode(builder.grow_factor.doubleValue());
        this.min_fill_rate = builder.min_fill_rate == null ? new DoubleNode(0.1) : new DoubleNode(builder.min_fill_rate.doubleValue());
        this.overrepresent_meta_data_factor = builder.overrepresent_meta_data_factor == null ? new DoubleNode(1.2) : new DoubleNode(builder.overrepresent_meta_data_factor.doubleValue());
        this.overrepresent_header_block_factor = builder.overrepresent_header_block_factor == null ? new DoubleNode(1.1) : new DoubleNode(builder.overrepresent_header_block_factor.doubleValue());
        this.store_50_backwards_compatible_remove_entries_with_doctype = builder.store_50_backwards_compatible_remove_entries_with_doctype == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.store_50_backwards_compatible_remove_entries_with_doctype);
    }

    public int dir_spread() {
        return this.dir_spread.value();
    }

    public int dir_levels() {
        return this.dir_levels.value();
    }

    public int minimum_file_meta_slots() {
        return this.minimum_file_meta_slots.value();
    }

    public int maximum_file_meta_slots() {
        return this.maximum_file_meta_slots.value();
    }

    public int minimum_file_header_block_size() {
        return this.minimum_file_header_block_size.value();
    }

    public int maximum_file_header_block_size() {
        return this.maximum_file_header_block_size.value();
    }

    public int minimum_file_size() {
        return this.minimum_file_size.value();
    }

    public int maximum_file_size() {
        return this.maximum_file_size.value();
    }

    public int file_block_size() {
        return this.file_block_size.value();
    }

    public boolean fsync_after_each_operation() {
        return this.fsync_after_each_operation.value();
    }

    public int revert_time_period() {
        return this.revert_time_period.value();
    }

    public int keep_remove_time_period() {
        return this.keep_remove_time_period.value();
    }

    public List<Threads> threads() {
        return this.threads;
    }

    public Threads threads(int i) {
        return (Threads)((Object)this.threads.get(i));
    }

    public int max_priority_to_block() {
        return this.max_priority_to_block.value();
    }

    public int min_priority_to_be_blocking() {
        return this.min_priority_to_be_blocking.value();
    }

    public int initial_index_read() {
        return this.initial_index_read.value();
    }

    public int maximum_gap_to_read_through() {
        return this.maximum_gap_to_read_through.value();
    }

    public long cache_size() {
        return this.cache_size.value();
    }

    public long cache_size_meta_percentage() {
        return this.cache_size_meta_percentage.value();
    }

    public long cache_size_header_percentage() {
        return this.cache_size_header_percentage.value();
    }

    public long cache_size_body_percentage() {
        return this.cache_size_body_percentage.value();
    }

    public double disk_full_factor() {
        return this.disk_full_factor.value();
    }

    public double disk_full_factor_move() {
        return this.disk_full_factor_move.value();
    }

    public double grow_factor() {
        return this.grow_factor.value();
    }

    public double min_fill_rate() {
        return this.min_fill_rate.value();
    }

    public double overrepresent_meta_data_factor() {
        return this.overrepresent_meta_data_factor.value();
    }

    public double overrepresent_header_block_factor() {
        return this.overrepresent_header_block_factor.value();
    }

    public String store_50_backwards_compatible_remove_entries_with_doctype() {
        return this.store_50_backwards_compatible_remove_entries_with_doctype.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorMemfilepersistenceConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.dir_spread, (Node)newConfig.dir_spread, "dir_spread", "FILE LAYOUT PARAMETERS\n\nNumber of directories per level to spread files across");
        changes.compare((Node)this.dir_levels, (Node)newConfig.dir_levels, "dir_levels", "Number of directory levels");
        changes.compare((Node)this.file_block_size, (Node)newConfig.file_block_size, "file_block_size", "When creating new files, always create files as a multiplum of this size.\nShould be set to the block size on the disk, or possibly a multiplum of\nthat, though we know no advantage of setting it to more than the block\nsize. If you want more free space in files, you should rather adjust that\nwith growfactor or min file sizes.");
        changes.compare((Node)this.fsync_after_each_operation, (Node)newConfig.fsync_after_each_operation, "fsync_after_each_operation", "CONSISTENCY PARAMETERS\n\nIf true, fsync after all disk operations, to ensure no dirty OS file\ncache afterwards. This is only useful if using cached IO, which is not\nrecommended to start with.");
        changes.compareArray(this.threads, newConfig.threads, "threads", CONFIG_DEF_VERSION, (a, b) -> ((Threads)a).getChangesRequiringRestart((Threads)b));
        changes.compare((Node)this.max_priority_to_block, (Node)newConfig.max_priority_to_block, "max_priority_to_block", "Pause operations (and block new ones from starting) with priority\nlower than this value when executing operations with higher pri than\nmin_priority_to_be_blocking");
        changes.compare((Node)this.min_priority_to_be_blocking, (Node)newConfig.min_priority_to_be_blocking, "min_priority_to_be_blocking", CONFIG_DEF_VERSION);
        changes.compare((Node)this.cache_size, (Node)newConfig.cache_size, "cache_size", "Size of the cache.");
        changes.compare((Node)this.cache_size_meta_percentage, (Node)newConfig.cache_size_meta_percentage, "cache_size_meta_percentage", "Soft limit on bytes used in cache for meta data, written as a percentage\nof the total");
        changes.compare((Node)this.cache_size_header_percentage, (Node)newConfig.cache_size_header_percentage, "cache_size_header_percentage", "Soft limit on bytes used in cache for meta data, written as a percentage\nof the total");
        changes.compare((Node)this.cache_size_body_percentage, (Node)newConfig.cache_size_body_percentage, "cache_size_body_percentage", "Soft limit on bytes used in cache for meta data, written as a percentage\nof the total");
        changes.compare((Node)this.disk_full_factor, (Node)newConfig.disk_full_factor, "disk_full_factor", "When a disk is fuller than this factor, we will not allow more data to be\nwritten to the system, unless this data is written in order to reduce\nstorage consumption, such as resizing files to become smaller or add\nmeta entries to write remove entries into. This value is set high as\ndefault as we expect a lot of users to have formatted their disks to\nalready reserve 8% of the data to root user which is often default. We\nsuggest using 0% reserved for root, and rather set this parameter lower\nto reserve space. That way, VDS have more space available in worst case\nin order to resize files to become smaller.");
        changes.compare((Node)this.disk_full_factor_move, (Node)newConfig.disk_full_factor_move, "disk_full_factor_move", "We don't allow disk moves to any disk that is fuller than this. This is a\nsafeguard to avoid disk movement to fill up a disk.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Threads
    extends InnerNode {
        private final IntegerNode lowestpri;

        @Deprecated
        private Threads() {
            this(new Builder(), false);
        }

        public Threads(Builder builder) {
            this(builder, true);
        }

        private Threads(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-memfilepersistence.threads[] must be initialized: " + builder.__uninitialized);
            }
            this.lowestpri = builder.lowestpri == null ? new IntegerNode(255) : new IntegerNode(builder.lowestpri.intValue());
        }

        public int lowestpri() {
            return this.lowestpri.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Threads newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("threads");
            changes.compare((Node)this.lowestpri, (Node)newConfig.lowestpri, "lowestpri", "PERFORMANCE PARAMETERS\n\nNumber of threads to use for each mountpoint. VDS needs memory per thread\nto perform disk operations, so increasing this number will increase\nmemory usage, but it will also make the disk queue on a given disk be\nable to be larger, such that the disk can choose operations to optimize\nseek time.\nSee benchmarks for performance/memory tradeoff.");
            return changes;
        }

        private static InnerNodeVector<Threads> createVector(List<Builder> builders) {
            ArrayList<Threads> elems = new ArrayList<Threads>();
            for (Builder b : builders) {
                elems.add(new Threads(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Threads());
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer lowestpri = null;

            public Builder() {
            }

            public Builder(Threads config) {
                this.lowestpri(config.lowestpri());
            }

            private Builder override(Builder __superior) {
                if (__superior.lowestpri != null) {
                    this.lowestpri(__superior.lowestpri);
                }
                return this;
            }

            public Builder lowestpri(int __value) {
                this.lowestpri = __value;
                return this;
            }

            private Builder lowestpri(String __value) {
                return this.lowestpri(Integer.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer dir_spread = null;
        private Integer dir_levels = null;
        private Integer minimum_file_meta_slots = null;
        private Integer maximum_file_meta_slots = null;
        private Integer minimum_file_header_block_size = null;
        private Integer maximum_file_header_block_size = null;
        private Integer minimum_file_size = null;
        private Integer maximum_file_size = null;
        private Integer file_block_size = null;
        private Boolean fsync_after_each_operation = null;
        private Integer revert_time_period = null;
        private Integer keep_remove_time_period = null;
        public List<Threads.Builder> threads = new ArrayList<Threads.Builder>();
        private Integer max_priority_to_block = null;
        private Integer min_priority_to_be_blocking = null;
        private Integer initial_index_read = null;
        private Integer maximum_gap_to_read_through = null;
        private Long cache_size = null;
        private Long cache_size_meta_percentage = null;
        private Long cache_size_header_percentage = null;
        private Long cache_size_body_percentage = null;
        private Double disk_full_factor = null;
        private Double disk_full_factor_move = null;
        private Double grow_factor = null;
        private Double min_fill_rate = null;
        private Double overrepresent_meta_data_factor = null;
        private Double overrepresent_header_block_factor = null;
        private String store_50_backwards_compatible_remove_entries_with_doctype = null;

        public Builder() {
        }

        public Builder(StorMemfilepersistenceConfig config) {
            this.dir_spread(config.dir_spread());
            this.dir_levels(config.dir_levels());
            this.minimum_file_meta_slots(config.minimum_file_meta_slots());
            this.maximum_file_meta_slots(config.maximum_file_meta_slots());
            this.minimum_file_header_block_size(config.minimum_file_header_block_size());
            this.maximum_file_header_block_size(config.maximum_file_header_block_size());
            this.minimum_file_size(config.minimum_file_size());
            this.maximum_file_size(config.maximum_file_size());
            this.file_block_size(config.file_block_size());
            this.fsync_after_each_operation(config.fsync_after_each_operation());
            this.revert_time_period(config.revert_time_period());
            this.keep_remove_time_period(config.keep_remove_time_period());
            for (Threads t : config.threads()) {
                this.threads(new Threads.Builder(t));
            }
            this.max_priority_to_block(config.max_priority_to_block());
            this.min_priority_to_be_blocking(config.min_priority_to_be_blocking());
            this.initial_index_read(config.initial_index_read());
            this.maximum_gap_to_read_through(config.maximum_gap_to_read_through());
            this.cache_size(config.cache_size());
            this.cache_size_meta_percentage(config.cache_size_meta_percentage());
            this.cache_size_header_percentage(config.cache_size_header_percentage());
            this.cache_size_body_percentage(config.cache_size_body_percentage());
            this.disk_full_factor(config.disk_full_factor());
            this.disk_full_factor_move(config.disk_full_factor_move());
            this.grow_factor(config.grow_factor());
            this.min_fill_rate(config.min_fill_rate());
            this.overrepresent_meta_data_factor(config.overrepresent_meta_data_factor());
            this.overrepresent_header_block_factor(config.overrepresent_header_block_factor());
            this.store_50_backwards_compatible_remove_entries_with_doctype(config.store_50_backwards_compatible_remove_entries_with_doctype());
        }

        private Builder override(Builder __superior) {
            if (__superior.dir_spread != null) {
                this.dir_spread(__superior.dir_spread);
            }
            if (__superior.dir_levels != null) {
                this.dir_levels(__superior.dir_levels);
            }
            if (__superior.minimum_file_meta_slots != null) {
                this.minimum_file_meta_slots(__superior.minimum_file_meta_slots);
            }
            if (__superior.maximum_file_meta_slots != null) {
                this.maximum_file_meta_slots(__superior.maximum_file_meta_slots);
            }
            if (__superior.minimum_file_header_block_size != null) {
                this.minimum_file_header_block_size(__superior.minimum_file_header_block_size);
            }
            if (__superior.maximum_file_header_block_size != null) {
                this.maximum_file_header_block_size(__superior.maximum_file_header_block_size);
            }
            if (__superior.minimum_file_size != null) {
                this.minimum_file_size(__superior.minimum_file_size);
            }
            if (__superior.maximum_file_size != null) {
                this.maximum_file_size(__superior.maximum_file_size);
            }
            if (__superior.file_block_size != null) {
                this.file_block_size(__superior.file_block_size);
            }
            if (__superior.fsync_after_each_operation != null) {
                this.fsync_after_each_operation(__superior.fsync_after_each_operation);
            }
            if (__superior.revert_time_period != null) {
                this.revert_time_period(__superior.revert_time_period);
            }
            if (__superior.keep_remove_time_period != null) {
                this.keep_remove_time_period(__superior.keep_remove_time_period);
            }
            if (!__superior.threads.isEmpty()) {
                this.threads.addAll(__superior.threads);
            }
            if (__superior.max_priority_to_block != null) {
                this.max_priority_to_block(__superior.max_priority_to_block);
            }
            if (__superior.min_priority_to_be_blocking != null) {
                this.min_priority_to_be_blocking(__superior.min_priority_to_be_blocking);
            }
            if (__superior.initial_index_read != null) {
                this.initial_index_read(__superior.initial_index_read);
            }
            if (__superior.maximum_gap_to_read_through != null) {
                this.maximum_gap_to_read_through(__superior.maximum_gap_to_read_through);
            }
            if (__superior.cache_size != null) {
                this.cache_size(__superior.cache_size);
            }
            if (__superior.cache_size_meta_percentage != null) {
                this.cache_size_meta_percentage(__superior.cache_size_meta_percentage);
            }
            if (__superior.cache_size_header_percentage != null) {
                this.cache_size_header_percentage(__superior.cache_size_header_percentage);
            }
            if (__superior.cache_size_body_percentage != null) {
                this.cache_size_body_percentage(__superior.cache_size_body_percentage);
            }
            if (__superior.disk_full_factor != null) {
                this.disk_full_factor(__superior.disk_full_factor);
            }
            if (__superior.disk_full_factor_move != null) {
                this.disk_full_factor_move(__superior.disk_full_factor_move);
            }
            if (__superior.grow_factor != null) {
                this.grow_factor(__superior.grow_factor);
            }
            if (__superior.min_fill_rate != null) {
                this.min_fill_rate(__superior.min_fill_rate);
            }
            if (__superior.overrepresent_meta_data_factor != null) {
                this.overrepresent_meta_data_factor(__superior.overrepresent_meta_data_factor);
            }
            if (__superior.overrepresent_header_block_factor != null) {
                this.overrepresent_header_block_factor(__superior.overrepresent_header_block_factor);
            }
            if (__superior.store_50_backwards_compatible_remove_entries_with_doctype != null) {
                this.store_50_backwards_compatible_remove_entries_with_doctype(__superior.store_50_backwards_compatible_remove_entries_with_doctype);
            }
            return this;
        }

        public Builder dir_spread(int __value) {
            this.dir_spread = __value;
            return this;
        }

        private Builder dir_spread(String __value) {
            return this.dir_spread(Integer.valueOf(__value));
        }

        public Builder dir_levels(int __value) {
            this.dir_levels = __value;
            return this;
        }

        private Builder dir_levels(String __value) {
            return this.dir_levels(Integer.valueOf(__value));
        }

        public Builder minimum_file_meta_slots(int __value) {
            this.minimum_file_meta_slots = __value;
            return this;
        }

        private Builder minimum_file_meta_slots(String __value) {
            return this.minimum_file_meta_slots(Integer.valueOf(__value));
        }

        public Builder maximum_file_meta_slots(int __value) {
            this.maximum_file_meta_slots = __value;
            return this;
        }

        private Builder maximum_file_meta_slots(String __value) {
            return this.maximum_file_meta_slots(Integer.valueOf(__value));
        }

        public Builder minimum_file_header_block_size(int __value) {
            this.minimum_file_header_block_size = __value;
            return this;
        }

        private Builder minimum_file_header_block_size(String __value) {
            return this.minimum_file_header_block_size(Integer.valueOf(__value));
        }

        public Builder maximum_file_header_block_size(int __value) {
            this.maximum_file_header_block_size = __value;
            return this;
        }

        private Builder maximum_file_header_block_size(String __value) {
            return this.maximum_file_header_block_size(Integer.valueOf(__value));
        }

        public Builder minimum_file_size(int __value) {
            this.minimum_file_size = __value;
            return this;
        }

        private Builder minimum_file_size(String __value) {
            return this.minimum_file_size(Integer.valueOf(__value));
        }

        public Builder maximum_file_size(int __value) {
            this.maximum_file_size = __value;
            return this;
        }

        private Builder maximum_file_size(String __value) {
            return this.maximum_file_size(Integer.valueOf(__value));
        }

        public Builder file_block_size(int __value) {
            this.file_block_size = __value;
            return this;
        }

        private Builder file_block_size(String __value) {
            return this.file_block_size(Integer.valueOf(__value));
        }

        public Builder fsync_after_each_operation(boolean __value) {
            this.fsync_after_each_operation = __value;
            return this;
        }

        private Builder fsync_after_each_operation(String __value) {
            return this.fsync_after_each_operation(Boolean.valueOf(__value));
        }

        public Builder revert_time_period(int __value) {
            this.revert_time_period = __value;
            return this;
        }

        private Builder revert_time_period(String __value) {
            return this.revert_time_period(Integer.valueOf(__value));
        }

        public Builder keep_remove_time_period(int __value) {
            this.keep_remove_time_period = __value;
            return this;
        }

        private Builder keep_remove_time_period(String __value) {
            return this.keep_remove_time_period(Integer.valueOf(__value));
        }

        public Builder threads(Threads.Builder __builder) {
            this.threads.add(__builder);
            return this;
        }

        public Builder threads(List<Threads.Builder> __builders) {
            this.threads = __builders;
            return this;
        }

        public Builder max_priority_to_block(int __value) {
            this.max_priority_to_block = __value;
            return this;
        }

        private Builder max_priority_to_block(String __value) {
            return this.max_priority_to_block(Integer.valueOf(__value));
        }

        public Builder min_priority_to_be_blocking(int __value) {
            this.min_priority_to_be_blocking = __value;
            return this;
        }

        private Builder min_priority_to_be_blocking(String __value) {
            return this.min_priority_to_be_blocking(Integer.valueOf(__value));
        }

        public Builder initial_index_read(int __value) {
            this.initial_index_read = __value;
            return this;
        }

        private Builder initial_index_read(String __value) {
            return this.initial_index_read(Integer.valueOf(__value));
        }

        public Builder maximum_gap_to_read_through(int __value) {
            this.maximum_gap_to_read_through = __value;
            return this;
        }

        private Builder maximum_gap_to_read_through(String __value) {
            return this.maximum_gap_to_read_through(Integer.valueOf(__value));
        }

        public Builder cache_size(long __value) {
            this.cache_size = __value;
            return this;
        }

        private Builder cache_size(String __value) {
            return this.cache_size(Long.valueOf(__value));
        }

        public Builder cache_size_meta_percentage(long __value) {
            this.cache_size_meta_percentage = __value;
            return this;
        }

        private Builder cache_size_meta_percentage(String __value) {
            return this.cache_size_meta_percentage(Long.valueOf(__value));
        }

        public Builder cache_size_header_percentage(long __value) {
            this.cache_size_header_percentage = __value;
            return this;
        }

        private Builder cache_size_header_percentage(String __value) {
            return this.cache_size_header_percentage(Long.valueOf(__value));
        }

        public Builder cache_size_body_percentage(long __value) {
            this.cache_size_body_percentage = __value;
            return this;
        }

        private Builder cache_size_body_percentage(String __value) {
            return this.cache_size_body_percentage(Long.valueOf(__value));
        }

        public Builder disk_full_factor(double __value) {
            this.disk_full_factor = __value;
            return this;
        }

        private Builder disk_full_factor(String __value) {
            return this.disk_full_factor(Double.valueOf(__value));
        }

        public Builder disk_full_factor_move(double __value) {
            this.disk_full_factor_move = __value;
            return this;
        }

        private Builder disk_full_factor_move(String __value) {
            return this.disk_full_factor_move(Double.valueOf(__value));
        }

        public Builder grow_factor(double __value) {
            this.grow_factor = __value;
            return this;
        }

        private Builder grow_factor(String __value) {
            return this.grow_factor(Double.valueOf(__value));
        }

        public Builder min_fill_rate(double __value) {
            this.min_fill_rate = __value;
            return this;
        }

        private Builder min_fill_rate(String __value) {
            return this.min_fill_rate(Double.valueOf(__value));
        }

        public Builder overrepresent_meta_data_factor(double __value) {
            this.overrepresent_meta_data_factor = __value;
            return this;
        }

        private Builder overrepresent_meta_data_factor(String __value) {
            return this.overrepresent_meta_data_factor(Double.valueOf(__value));
        }

        public Builder overrepresent_header_block_factor(double __value) {
            this.overrepresent_header_block_factor = __value;
            return this;
        }

        private Builder overrepresent_header_block_factor(String __value) {
            return this.overrepresent_header_block_factor(Double.valueOf(__value));
        }

        public Builder store_50_backwards_compatible_remove_entries_with_doctype(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.store_50_backwards_compatible_remove_entries_with_doctype = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorMemfilepersistenceConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorMemfilepersistenceConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorMemfilepersistenceConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

