/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ClusterInfoConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "265155ead666b8fd9fb5890587c84e48";
    public static final String CONFIG_DEF_NAME = "cluster-info";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "clusterId string", "nodeCount int", "services[].index int default=-1", "services[].hostname string default=\"(nohostname)\"", "services[].ports[].number int default=-1", "services[].ports[].tags string default=\"(notags)\""};
    private final StringNode clusterId;
    private final IntegerNode nodeCount;
    private final InnerNodeVector<Services> services;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ClusterInfoConfig(Builder builder) {
        this(builder, true);
    }

    private ClusterInfoConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for cluster-info must be initialized: " + builder.__uninitialized);
        }
        this.clusterId = builder.clusterId == null ? new StringNode() : new StringNode(builder.clusterId);
        this.nodeCount = builder.nodeCount == null ? new IntegerNode() : new IntegerNode(builder.nodeCount.intValue());
        this.services = Services.createVector(builder.services);
    }

    public String clusterId() {
        return this.clusterId.value();
    }

    public int nodeCount() {
        return this.nodeCount.value();
    }

    public List<Services> services() {
        return this.services;
    }

    public Services services(int i) {
        return (Services)((Object)this.services.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ClusterInfoConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Services
    extends InnerNode {
        private final IntegerNode index;
        private final StringNode hostname;
        private final InnerNodeVector<Ports> ports;

        @Deprecated
        private Services() {
            this(new Builder(), false);
        }

        public Services(Builder builder) {
            this(builder, true);
        }

        private Services(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for cluster-info.services[] must be initialized: " + builder.__uninitialized);
            }
            this.index = builder.index == null ? new IntegerNode(-1) : new IntegerNode(builder.index.intValue());
            this.hostname = builder.hostname == null ? new StringNode("(nohostname)") : new StringNode(builder.hostname);
            this.ports = Ports.createVector(builder.ports);
        }

        public int index() {
            return this.index.value();
        }

        public String hostname() {
            return this.hostname.value();
        }

        public List<Ports> ports() {
            return this.ports;
        }

        public Ports ports(int i) {
            return (Ports)((Object)this.ports.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Services newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("services");
            return changes;
        }

        private static InnerNodeVector<Services> createVector(List<Builder> builders) {
            ArrayList<Services> elems = new ArrayList<Services>();
            for (Builder b : builders) {
                elems.add(new Services(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Services());
        }

        public static final class Ports
        extends InnerNode {
            private final IntegerNode number;
            private final StringNode tags;

            @Deprecated
            private Ports() {
                this(new Builder(), false);
            }

            public Ports(Builder builder) {
                this(builder, true);
            }

            private Ports(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for cluster-info.services[].ports[] must be initialized: " + builder.__uninitialized);
                }
                this.number = builder.number == null ? new IntegerNode(-1) : new IntegerNode(builder.number.intValue());
                this.tags = builder.tags == null ? new StringNode("(notags)") : new StringNode(builder.tags);
            }

            public int number() {
                return this.number.value();
            }

            public String tags() {
                return this.tags.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Ports newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("ports");
                return changes;
            }

            private static InnerNodeVector<Ports> createVector(List<Builder> builders) {
                ArrayList<Ports> elems = new ArrayList<Ports>();
                for (Builder b : builders) {
                    elems.add(new Ports(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Ports());
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Integer number = null;
                private String tags = null;

                public Builder() {
                }

                public Builder(Ports config) {
                    this.number(config.number());
                    this.tags(config.tags());
                }

                private Builder override(Builder __superior) {
                    if (__superior.number != null) {
                        this.number(__superior.number);
                    }
                    if (__superior.tags != null) {
                        this.tags(__superior.tags);
                    }
                    return this;
                }

                public Builder number(int __value) {
                    this.number = __value;
                    return this;
                }

                private Builder number(String __value) {
                    return this.number(Integer.valueOf(__value));
                }

                public Builder tags(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.tags = __value;
                    return this;
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer index = null;
            private String hostname = null;
            public List<Ports.Builder> ports = new ArrayList<Ports.Builder>();

            public Builder() {
            }

            public Builder(Services config) {
                this.index(config.index());
                this.hostname(config.hostname());
                for (Ports p : config.ports()) {
                    this.ports(new Ports.Builder(p));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.index != null) {
                    this.index(__superior.index);
                }
                if (__superior.hostname != null) {
                    this.hostname(__superior.hostname);
                }
                if (!__superior.ports.isEmpty()) {
                    this.ports.addAll(__superior.ports);
                }
                return this;
            }

            public Builder index(int __value) {
                this.index = __value;
                return this;
            }

            private Builder index(String __value) {
                return this.index(Integer.valueOf(__value));
            }

            public Builder hostname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.hostname = __value;
                return this;
            }

            public Builder ports(Ports.Builder __builder) {
                this.ports.add(__builder);
                return this;
            }

            public Builder ports(List<Ports.Builder> __builders) {
                this.ports = __builders;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("clusterId", "nodeCount"));
        private String clusterId = null;
        private Integer nodeCount = null;
        public List<Services.Builder> services = new ArrayList<Services.Builder>();

        public Builder() {
        }

        public Builder(ClusterInfoConfig config) {
            this.clusterId(config.clusterId());
            this.nodeCount(config.nodeCount());
            for (Services s : config.services()) {
                this.services(new Services.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.clusterId != null) {
                this.clusterId(__superior.clusterId);
            }
            if (__superior.nodeCount != null) {
                this.nodeCount(__superior.nodeCount);
            }
            if (!__superior.services.isEmpty()) {
                this.services.addAll(__superior.services);
            }
            return this;
        }

        public Builder clusterId(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.clusterId = __value;
            this.__uninitialized.remove("clusterId");
            return this;
        }

        public Builder nodeCount(int __value) {
            this.nodeCount = __value;
            this.__uninitialized.remove("nodeCount");
            return this;
        }

        private Builder nodeCount(String __value) {
            return this.nodeCount(Integer.valueOf(__value));
        }

        public Builder services(Services.Builder __builder) {
            this.services.add(__builder);
            return this;
        }

        public Builder services(List<Services.Builder> __builders) {
            this.services = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ClusterInfoConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ClusterInfoConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ClusterInfoConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

