/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.config.subscription.impl.JRTManagedConnectionPools;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.text.internal.SnippetGenerator;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.ErrorCode;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.JRTConfigRequestFactory;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JRTConfigRequester
implements RequestWaiter {
    private static final Logger log = Logger.getLogger(JRTConfigRequester.class.getName());
    public static final ConfigSourceSet defaultSourceSet = ConfigSourceSet.createDefault();
    private static final JRTManagedConnectionPools managedPool = new JRTManagedConnectionPools();
    private static final int TRACELEVEL = 6;
    private static final Duration delayBetweenWarnings = Duration.ofSeconds(60L);
    static final float randomFraction = 0.2f;
    private static final Duration additionalTimeForClientTimeout = Duration.ofSeconds(10L);
    private final TimingValues timingValues;
    private final ScheduledThreadPoolExecutor scheduler;
    private final ConnectionPool connectionPool;
    private final ConfigSourceSet configSourceSet;
    private Instant timeForLastLogWarning;
    private int failures = 0;
    private volatile boolean closed = false;

    JRTConfigRequester(ConfigSourceSet configSourceSet, ScheduledThreadPoolExecutor scheduler, ConnectionPool connectionPool, TimingValues timingValues) {
        this.configSourceSet = configSourceSet;
        this.scheduler = scheduler;
        this.connectionPool = connectionPool;
        this.timingValues = timingValues;
        this.timeForLastLogWarning = Instant.now().minus(delayBetweenWarnings).plus(Duration.ofSeconds(5L));
    }

    public JRTConfigRequester(ConnectionPool connectionPool, TimingValues timingValues) {
        this(null, new ScheduledThreadPoolExecutor(1), connectionPool, timingValues);
    }

    public static JRTConfigRequester create(ConfigSourceSet sourceSet, TimingValues timingValues) {
        return managedPool.acquire(sourceSet, timingValues);
    }

    public <T extends ConfigInstance> void request(JRTConfigSubscription<T> sub) {
        JRTClientConfigRequest req = JRTConfigRequestFactory.createFromSub(sub);
        this.doRequest(sub, req);
    }

    private <T extends ConfigInstance> void doRequest(JRTConfigSubscription<T> sub, JRTClientConfigRequest req) {
        Connection connection = this.connectionPool.getCurrent();
        Request request = req.getRequest();
        request.setContext((Object)new RequestContext(sub, req, connection));
        if (!req.validateParameters()) {
            throw new ConfigurationRuntimeException("Error in parameters for config request: " + req);
        }
        Duration jrtClientTimeout = this.getClientTimeout(req);
        log.log(Level.FINE, () -> "Requesting config for " + sub + " on connection " + connection + " with client timeout " + jrtClientTimeout + (String)(log.isLoggable(Level.FINEST) ? ",defcontent=" + req.getDefContent().asString() : ""));
        connection.invokeAsync(request, jrtClientTimeout, this);
    }

    public void handleRequestDone(Request req) {
        JRTConfigSubscription sub = null;
        try {
            RequestContext context = (RequestContext)req.getContext();
            sub = context.sub;
            this.doHandle(sub, context.jrtReq, context.connection);
        }
        catch (RuntimeException e) {
            if (sub != null) {
                sub.setException(e);
            }
            log.log(Level.SEVERE, "Failed to get subscription object from JRT config callback: " + Exceptions.toMessageString((Throwable)e));
        }
    }

    private void doHandle(JRTConfigSubscription<ConfigInstance> sub, JRTClientConfigRequest jrtReq, Connection connection) {
        if (sub.isClosed()) {
            return;
        }
        boolean validResponse = jrtReq.validateResponse();
        log.log(Level.FINE, () -> "Request callback " + (validResponse ? "valid" : "invalid") + ". Req: " + jrtReq + "\nSpec: " + connection);
        Trace trace = jrtReq.getResponseTrace();
        trace.trace(6, "JRTConfigRequester.doHandle()");
        log.log(Level.FINEST, () -> trace.toString());
        if (validResponse) {
            this.handleOKRequest(jrtReq, sub);
        } else {
            this.handleFailedRequest(jrtReq, sub, connection);
        }
    }

    private void logError(JRTClientConfigRequest jrtReq, Connection connection) {
        switch (jrtReq.errorCode()) {
            case 104: {
                log.log(Level.FINE, () -> "Request callback failed: " + jrtReq.errorMessage() + "\nConnection spec: " + connection);
                break;
            }
            case 100005: 
            case 100300: {
                this.logWarning(jrtReq, connection);
                break;
            }
            default: {
                log.log(Level.WARNING, "Request callback failed. Req: " + jrtReq + "\nSpec: " + connection.getAddress() + " . Req error message: " + jrtReq.errorMessage());
            }
        }
    }

    private void logWarning(JRTClientConfigRequest jrtReq, Connection connection) {
        if (!this.closed && this.timeForLastLogWarning.isBefore(Instant.now().minus(delayBetweenWarnings))) {
            log.log(Level.WARNING, "Request callback failed: " + ErrorCode.getName(jrtReq.errorCode()) + ". Connection spec: " + connection.getAddress() + ", error message: " + jrtReq.errorMessage());
            this.timeForLastLogWarning = Instant.now();
        }
    }

    private void handleFailedRequest(JRTClientConfigRequest jrtReq, JRTConfigSubscription<ConfigInstance> sub, Connection connection) {
        this.logError(jrtReq, connection);
        this.connectionPool.switchConnection(connection);
        if (this.failures < 10) {
            ++this.failures;
        }
        long delay = JRTConfigRequester.calculateFailedRequestDelay(this.failures, this.timingValues);
        log.log(Level.FINE, () -> "Request for config " + jrtReq.getShortDescription() + "' failed with error code " + jrtReq.errorCode() + " (" + jrtReq.errorMessage() + "), scheduling new request  in " + delay + " ms");
        this.scheduleNextRequest(jrtReq, sub, delay, this.calculateErrorTimeout());
    }

    static long calculateFailedRequestDelay(int failures, TimingValues timingValues) {
        long delay = timingValues.getFixedDelay() * (long)Math.pow(2.0, failures);
        delay = Math.max(timingValues.getFixedDelay(), Math.min(60000L, delay));
        delay = timingValues.getPlusMinusFractionRandom(delay, 0.2f);
        return delay;
    }

    private long calculateErrorTimeout() {
        return this.timingValues.getPlusMinusFractionRandom(this.timingValues.getErrorTimeout(), 0.2f);
    }

    private void handleOKRequest(JRTClientConfigRequest jrtReq, JRTConfigSubscription<ConfigInstance> sub) {
        this.failures = 0;
        sub.setLastCallBackOKTS(Instant.now());
        log.log(Level.FINE, () -> "OK response received in handleOkRequest: " + jrtReq);
        if (jrtReq.hasUpdatedGeneration()) {
            sub.updateConfig(jrtReq);
        } else if (jrtReq.hasUpdatedConfig()) {
            SnippetGenerator generator = new SnippetGenerator();
            int sizeHint = 500;
            String config = jrtReq.getNewPayload().toString();
            log.log(Level.WARNING, "Config " + jrtReq.getConfigKey() + " has changed without a change in config generation: generation " + jrtReq.getNewGeneration() + ", config: " + generator.makeSnippet(config, sizeHint) + ". This might happen when a newly upgraded config server responds with different config when bootstrapping   (changes to code generating config that are different between versions) or non-deterministic config generation (e.g. when using collections with non-deterministic iteration order)");
        }
        this.scheduleNextRequest(jrtReq, sub, this.calculateSuccessDelay(), this.calculateSuccessTimeout());
    }

    private long calculateSuccessTimeout() {
        return this.timingValues.getPlusMinusFractionRandom(this.timingValues.getSuccessTimeout(), 0.2f);
    }

    private long calculateSuccessDelay() {
        return this.timingValues.getPlusMinusFractionRandom(this.timingValues.getFixedDelay(), 0.2f);
    }

    private void scheduleNextRequest(JRTClientConfigRequest jrtReq, JRTConfigSubscription<?> sub, long delay, long timeout) {
        long delayBeforeSendingRequest = delay < 0L ? 0L : delay;
        JRTClientConfigRequest jrtReqNew = jrtReq.nextRequest(timeout);
        log.log(Level.FINEST, () -> this.timingValues.toString());
        log.log(Level.FINE, () -> "Scheduling new request " + delayBeforeSendingRequest + " millis from now for " + jrtReqNew.getConfigKey());
        this.scheduler.schedule(new GetConfigTask(jrtReqNew, sub), delayBeforeSendingRequest, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.closed = true;
        if (this.configSourceSet != null) {
            managedPool.release(this.configSourceSet);
        }
    }

    int getFailures() {
        return this.failures;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private Duration getClientTimeout(JRTClientConfigRequest request) {
        return Duration.ofMillis(request.getTimeout()).plus(additionalTimeForClientTimeout);
    }

    private static class RequestContext {
        final JRTConfigSubscription sub;
        final JRTClientConfigRequest jrtReq;
        final Connection connection;

        private RequestContext(JRTConfigSubscription sub, JRTClientConfigRequest jrtReq, Connection connection) {
            this.sub = sub;
            this.jrtReq = jrtReq;
            this.connection = connection;
        }
    }

    private class GetConfigTask
    implements Runnable {
        private final JRTClientConfigRequest jrtReq;
        private final JRTConfigSubscription<?> sub;

        GetConfigTask(JRTClientConfigRequest jrtReq, JRTConfigSubscription<?> sub) {
            this.jrtReq = jrtReq;
            this.sub = sub;
        }

        @Override
        public void run() {
            JRTConfigRequester.this.doRequest(this.sub, this.jrtReq);
        }
    }
}

