/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class JRTConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private final JRTConfigRequester requester;
    private final TimingValues timingValues;
    private Instant lastOK = Instant.MIN;
    private BlockingQueue<JRTClientConfigRequest> responseQueue = new LinkedBlockingQueue<JRTClientConfigRequest>();

    public JRTConfigSubscription(ConfigKey<T> key, JRTConfigRequester requester, TimingValues timingValues) {
        super(key);
        this.timingValues = timingValues;
        this.requester = requester;
    }

    @Override
    public boolean nextConfig(long timeoutMillis) {
        JRTClientConfigRequest response = this.pollForNewConfig(timeoutMillis);
        if (response == null) {
            return this.newConfigOrException();
        }
        log.log(Level.FINE, () -> "Polled queue and found config " + response);
        if (response.hasUpdatedGeneration()) {
            this.setApplyOnRestart(response.responseIsApplyOnRestart());
            if (response.hasUpdatedConfig()) {
                this.setNewConfig(response);
            } else {
                this.setNewConfigAndGeneration(response);
            }
        }
        return this.newConfigOrException();
    }

    private synchronized JRTClientConfigRequest pollForNewConfig(long timeoutMillis) {
        JRTClientConfigRequest response;
        JRTClientConfigRequest temp = response = this.pollQueue(timeoutMillis);
        while (temp != null) {
            temp = this.pollQueue(0L);
            if (temp == null) continue;
            response = temp;
        }
        return response;
    }

    private boolean newConfigOrException() {
        ConfigSubscription.ConfigState configState = this.getConfigState();
        return configState.isGenerationChanged() || configState.isConfigChanged() || this.hasException();
    }

    private JRTClientConfigRequest pollQueue(long timeoutMillis) {
        try {
            return this.responseQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            throw new ConfigInterruptedException(e1);
        }
    }

    protected void setNewConfig(JRTClientConfigRequest jrtReq) {
        try {
            T configInstance = this.toConfigInstance(jrtReq);
            this.setConfig(jrtReq.getNewGeneration(), jrtReq.responseIsApplyOnRestart(), configInstance, jrtReq.getNewChecksums());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad config in response", e);
        }
    }

    protected void setNewConfigAndGeneration(JRTClientConfigRequest jrtReq) {
        try {
            T configInstance = this.toConfigInstance(jrtReq);
            this.setConfigAndGeneration(jrtReq.getNewGeneration(), jrtReq.responseIsApplyOnRestart(), configInstance, jrtReq.getNewChecksums());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad config in response", e);
        }
    }

    private T toConfigInstance(JRTClientConfigRequest jrtRequest) {
        Payload payload = jrtRequest.getNewPayload();
        ConfigPayload configPayload = ConfigPayload.fromUtf8Array(payload.withCompression(CompressionType.UNCOMPRESSED).getData());
        Object configInstance = configPayload.toInstance(this.configClass, jrtRequest.getConfigKey().getConfigId());
        return (T)configInstance;
    }

    void updateConfig(JRTClientConfigRequest jrtReq) {
        if (!this.responseQueue.offer(jrtReq)) {
            this.setException((RuntimeException)new ConfigurationRuntimeException("Failed offering returned request to queue of subscription " + this));
        }
    }

    @Override
    public boolean subscribe(long timeout) {
        this.lastOK = Instant.now();
        this.requester.request(this);
        JRTClientConfigRequest req = (JRTClientConfigRequest)this.responseQueue.peek();
        while (req == null && Instant.now().isBefore(this.lastOK.plus(Duration.ofMillis(timeout)))) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ConfigInterruptedException(e);
            }
            req = (JRTClientConfigRequest)this.responseQueue.peek();
        }
        return req != null;
    }

    @Override
    public void close() {
        super.close();
        this.responseQueue = new LinkedBlockingQueue<JRTClientConfigRequest>(){

            @Override
            public void put(JRTClientConfigRequest e) {
            }
        };
    }

    public TimingValues timingValues() {
        return this.timingValues;
    }

    public JRTConfigRequester requester() {
        return this.requester;
    }

    @Override
    public void reload(long generation) {
        log.log(Level.FINE, "reload() is without effect on a JRTConfigSubscription.");
    }

    void setLastCallBackOKTS(Instant lastCallBackOKTS) {
        this.lastOK = lastCallBackOKTS;
    }

    static void printStatus(JRTClientConfigRequest request, String message) {
        String name = request.getConfigKey().getName();
        if (name.equals("components") || name.equals("chains")) {
            log.log(Level.INFO, message + ":" + name + ":, request=" + request);
        }
    }
}

