/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.ConfigInstance;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.List;
import java.util.Optional;

public class RawConfig
extends ConfigInstance {
    private final ConfigKey<?> key;
    private final String defMd5;
    private final List<String> defContent;
    private final Payload payload;
    private final int errorCode;
    private final PayloadChecksums payloadChecksums;
    private final Optional<VespaVersion> vespaVersion;
    private long generation;
    private boolean applyOnRestart;

    public RawConfig(ConfigKey<?> key, String defMd5) {
        this(key, defMd5, null, PayloadChecksums.empty(), 0L, false, 0, List.of(), Optional.empty());
    }

    public RawConfig(ConfigKey<?> key, String defMd5, Payload payload, PayloadChecksums payloadChecksums, long generation, boolean applyOnRestart, List<String> defContent, Optional<VespaVersion> vespaVersion) {
        this(key, defMd5, payload, payloadChecksums, generation, applyOnRestart, 0, defContent, vespaVersion);
    }

    public RawConfig(RawConfig rawConfig) {
        this(rawConfig.key, rawConfig.defMd5, rawConfig.payload, rawConfig.payloadChecksums, rawConfig.generation, rawConfig.applyOnRestart, rawConfig.errorCode, rawConfig.defContent, rawConfig.getVespaVersion());
    }

    public RawConfig(ConfigKey<?> key, String defMd5, Payload payload, PayloadChecksums payloadChecksums, long generation, boolean applyOnRestart, int errorCode, List<String> defContent, Optional<VespaVersion> vespaVersion) {
        this.key = key;
        this.defMd5 = ConfigUtils.getDefMd5FromRequest(defMd5, defContent);
        this.payload = payload;
        this.payloadChecksums = payloadChecksums;
        this.generation = generation;
        this.applyOnRestart = applyOnRestart;
        this.errorCode = errorCode;
        this.defContent = defContent;
        this.vespaVersion = vespaVersion;
    }

    public static RawConfig createFromResponseParameters(JRTClientConfigRequest req) {
        return new RawConfig(req.getConfigKey(), ConfigUtils.getDefMd5(req.getDefContent().asList()), req.getNewPayload(), req.getNewChecksums(), req.getNewGeneration(), req.responseIsApplyOnRestart(), 0, req.getDefContent().asList(), req.getVespaVersion());
    }

    public static RawConfig createFromServerRequest(JRTServerConfigRequest req) {
        return new RawConfig(req.getConfigKey(), ConfigUtils.getDefMd5(req.getDefContent().asList()), Payload.from((AbstractUtf8Array)new Utf8String(""), CompressionInfo.uncompressed()), req.getRequestConfigChecksums(), req.getRequestGeneration(), req.applyOnRestart(), 0, req.getDefContent().asList(), req.getVespaVersion());
    }

    public ConfigKey<?> getKey() {
        return this.key;
    }

    public String getName() {
        return this.key.getName();
    }

    public String getNamespace() {
        return this.key.getNamespace();
    }

    public String getConfigId() {
        return this.key.getConfigId();
    }

    public String getDefMd5() {
        return this.defMd5;
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration(long generation) {
        this.generation = generation;
    }

    public void setApplyOnRestart(boolean applyOnRestart) {
        this.applyOnRestart = applyOnRestart;
    }

    public boolean applyOnRestart() {
        return this.applyOnRestart;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public int errorCode() {
        return this.errorCode;
    }

    public String getDefNamespace() {
        return this.key.getNamespace();
    }

    public Optional<VespaVersion> getVespaVersion() {
        return this.vespaVersion;
    }

    public PayloadChecksums getPayloadChecksums() {
        return this.payloadChecksums;
    }

    public boolean hasEqualConfig(JRTServerConfigRequest req) {
        PayloadChecksums payloadChecksums = this.getPayloadChecksums();
        PayloadChecksum xxhash64 = payloadChecksums.getForType(PayloadChecksum.Type.XXHASH64);
        PayloadChecksum md5 = payloadChecksums.getForType(PayloadChecksum.Type.MD5);
        if (xxhash64 != null) {
            return xxhash64.equals(req.getRequestConfigChecksums().getForType(PayloadChecksum.Type.XXHASH64));
        }
        if (md5 != null) {
            return md5.equals(req.getRequestConfigChecksums().getForType(PayloadChecksum.Type.MD5));
        }
        return true;
    }

    public boolean hasNewerGeneration(JRTServerConfigRequest req) {
        return this.getGeneration() > req.getRequestGeneration();
    }

    public boolean isError() {
        return this.errorCode() != 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawConfig)) {
            return false;
        }
        RawConfig other = (RawConfig)((Object)o);
        if (!this.key.equals(other.key) || !this.defMd5.equals(other.defMd5) || this.errorCode != other.errorCode) {
            return false;
        }
        if (this.isError()) {
            return true;
        }
        if (this.generation != other.generation) {
            return false;
        }
        return this.payloadChecksums.equals(((RawConfig)((Object)o)).payloadChecksums);
    }

    public int hashCode() {
        int hash = 17;
        if (this.key != null) {
            hash = 31 * hash + this.key.hashCode();
        }
        if (this.defMd5 != null) {
            hash = 31 * hash + this.defMd5.hashCode();
        }
        hash = 31 * hash + this.errorCode;
        if (!this.isError()) {
            hash = 31 * hash + (int)(this.generation ^ this.generation >>> 32);
            hash = 31 * hash + this.payloadChecksums.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.getNamespace()).append(".").append(this.key.getName());
        sb.append(",");
        sb.append(this.getDefMd5());
        sb.append(",");
        sb.append(this.key.getConfigId());
        sb.append(",");
        sb.append(this.payloadChecksums);
        sb.append(",");
        sb.append(this.getGeneration());
        sb.append(",");
        sb.append(this.getPayload());
        return sb.toString();
    }

    public List<String> getDefContent() {
        return this.defContent;
    }
}

