/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.vespa.config.ConfigKey;
import java.util.Objects;

public class ConfigDefinitionKey {
    private final String name;
    private final String namespace;

    public ConfigDefinitionKey(String name, String namespace) {
        ConfigDefinitionKey.require(name, "A config name cannot be null or empty");
        ConfigDefinitionKey.require(namespace, "A config namespace cannot be null or empty");
        this.name = name;
        this.namespace = namespace;
    }

    private static void require(String object, String message) {
        Objects.requireNonNull(object, message);
        if (object.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public ConfigDefinitionKey(ConfigKey<?> key) {
        this(key.getName(), key.getNamespace());
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String asFileName() {
        return this.namespace + "." + this.name + ".def";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigDefinitionKey)) {
            return false;
        }
        ConfigDefinitionKey other = (ConfigDefinitionKey)o;
        return this.name.equals(other.getName()) && this.namespace.equals(other.getNamespace());
    }

    public int hashCode() {
        return this.namespace.hashCode() + this.name.hashCode();
    }

    public String toString() {
        return this.namespace + "." + this.name;
    }
}

