/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JRTConnectionPool
implements ConnectionPool {
    private static final Logger log = Logger.getLogger(JRTConnectionPool.class.getName());
    private final Supervisor supervisor;
    private final Map<String, JRTConnection> connections = new LinkedHashMap<String, JRTConnection>();
    private final String poolName;
    private ConfigSourceSet sourceSet = null;
    private volatile JRTConnection currentConnection;

    public JRTConnectionPool(ConfigSourceSet sourceSet) {
        this(sourceSet, new Supervisor(new Transport("config-pool-" + sourceSet.hashCode())).setDropEmptyBuffers(true));
    }

    public JRTConnectionPool(ConfigSourceSet sourceSet, Supervisor supervisor) {
        if (sourceSet.getSources().isEmpty()) {
            throw new IllegalArgumentException("sourceSet cannot be empty");
        }
        this.supervisor = supervisor;
        this.poolName = supervisor.transport().getName();
        this.addSources(sourceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSources(ConfigSourceSet sourceSet) {
        this.sourceSet = sourceSet;
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            for (String address : sourceSet.getSources()) {
                this.connections.put(address, new JRTConnection(address, this.supervisor));
            }
        }
        this.currentConnection = this.initialize();
    }

    @Override
    public synchronized JRTConnection getCurrent() {
        return this.currentConnection;
    }

    @Override
    public synchronized JRTConnection switchConnection(Connection failingConnection) {
        List<JRTConnection> sources = this.getSources();
        if (sources.size() <= 1) {
            return this.currentConnection;
        }
        if (!this.currentConnection.equals(failingConnection)) {
            return this.currentConnection;
        }
        return this.switchConnection();
    }

    synchronized JRTConnection switchConnection() {
        if (this.getSources().size() <= 1) {
            throw new IllegalStateException("Cannot switch connection, not enough sources");
        }
        List<JRTConnection> sourceCandidates = this.getSources();
        sourceCandidates.remove(this.currentConnection);
        JRTConnection newConnection = this.pickNewConnectionRandomly(sourceCandidates);
        log.log(Level.INFO, () -> this.poolName + ": Switching from " + String.valueOf(this.currentConnection) + " to " + String.valueOf(newConnection));
        this.currentConnection = newConnection;
        return this.currentConnection;
    }

    private synchronized JRTConnection initialize() {
        return this.pickNewConnectionRandomly(this.getSources());
    }

    protected final JRTConnection pickNewConnectionRandomly(List<JRTConnection> sources) {
        return sources.get(ThreadLocalRandom.current().nextInt(0, sources.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<JRTConnection> getSources() {
        ArrayList<JRTConnection> ret;
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            ret = new ArrayList<JRTConnection>(this.connections.values());
        }
        return ret;
    }

    ConfigSourceSet getSourceSet() {
        return this.sourceSet;
    }

    public JRTConnectionPool updateSources(List<String> addresses) {
        ConfigSourceSet newSources = new ConfigSourceSet(addresses);
        return this.updateSources(newSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRTConnectionPool updateSources(ConfigSourceSet sourceSet) {
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            for (JRTConnection conn : this.connections.values()) {
                conn.getTarget().close();
            }
            this.connections.clear();
            this.addSources(sourceSet);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(this.poolName + ": ");
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            for (JRTConnection conn : this.connections.values()) {
                sb.append(conn.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void close() {
        this.supervisor.transport().shutdown().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            return this.connections.size();
        }
    }

    @Override
    public List<Connection> connections() {
        return List.copyOf(this.connections.values());
    }
}

