/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.CfgConfigPayloadBuilder;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.PayloadChecksums;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private final String jarName;
    private final String path;
    private ZipEntry zipEntry = null;

    JarConfigSubscription(ConfigKey<T> key, String jarName, String path) {
        super(key);
        this.jarName = jarName;
        this.path = path;
    }

    @Override
    public boolean nextConfig(long timeout) {
        if (this.checkReloaded()) {
            return true;
        }
        if (this.zipEntry == null) {
            Object config;
            JarFile jarFile;
            try {
                jarFile = new JarFile(this.jarName);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            this.zipEntry = this.getEntry(jarFile, this.path);
            if (this.zipEntry == null) {
                throw new IllegalArgumentException("Config '" + this.key.getName() + "' not found in '" + this.jarName + "!/" + this.path + "'.");
            }
            try {
                ConfigPayload payload = new CfgConfigPayloadBuilder().deserialize(List.of(IOUtils.readAll((Reader)new InputStreamReader(jarFile.getInputStream(this.zipEntry), StandardCharsets.UTF_8)).split("\n")));
                config = payload.toInstance(this.configClass, this.key.getConfigId());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new ConfigurationRuntimeException((Throwable)e);
            }
            this.setConfig(0L, false, config, PayloadChecksums.empty());
            try {
                jarFile.close();
            }
            catch (IOException e) {
                throw new ConfigurationRuntimeException((Throwable)e);
            }
            return true;
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
        return false;
    }

    private ZipEntry getEntry(JarFile jarFile, String dir) {
        if (!((String)dir).endsWith("/")) {
            dir = (String)dir + "/";
        }
        return jarFile.getEntry((String)dir + JarConfigSubscription.getConfigFilename(this.key));
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }
}

