/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.JRTMethods;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.NoCopyByteArrayOutputStream;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.RequestValidation;
import com.yahoo.vespa.config.protocol.SlimeRequestData;
import com.yahoo.vespa.config.protocol.SlimeResponseData;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JRTClientConfigRequestV3
implements JRTClientConfigRequest {
    protected static final Logger log = Logger.getLogger(JRTClientConfigRequestV3.class.getName());
    protected final SlimeRequestData requestData;
    protected final Request request;
    private final SlimeResponseData responseData;

    protected JRTClientConfigRequestV3(ConfigKey<?> key, String hostname, DefContent defSchema, PayloadChecksums payloadChecksums, long generation, long timeout, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        Slime data = SlimeRequestData.encodeRequest(key, hostname, defSchema, payloadChecksums, generation, timeout, trace, this.getProtocolVersion(), compressionType, vespaVersion);
        Request jrtReq = new Request(this.getJRTMethodName());
        jrtReq.parameters().add((Value)new StringValue(JRTClientConfigRequestV3.encodeAsUtf8String(data)));
        this.requestData = new SlimeRequestData(jrtReq, data);
        this.responseData = new SlimeResponseData(jrtReq);
        this.request = jrtReq;
    }

    protected static String encodeAsUtf8String(Slime data) {
        NoCopyByteArrayOutputStream baos = new NoCopyByteArrayOutputStream();
        try {
            new JsonFormat(true).encode((OutputStream)baos, data);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode config request", e);
        }
        return Utf8.toString((byte[])((ByteArrayOutputStream)baos).toByteArray());
    }

    protected String getJRTMethodName() {
        return "config.v3.getConfig";
    }

    protected boolean checkReturnTypes(Request request) {
        return JRTMethods.checkV3ReturnTypes(request);
    }

    @Override
    public Payload getNewPayload() {
        CompressionInfo compressionInfo = this.getResponseData().getCompressionInfo();
        Utf8Array payload = new Utf8Array(this.request.returnValues().get(1).asData());
        return Payload.from((AbstractUtf8Array)payload, compressionInfo);
    }

    @Override
    public long getProtocolVersion() {
        return 3L;
    }

    @Override
    public JRTClientConfigRequest nextRequest(long timeout) {
        return new JRTClientConfigRequestV3(this.getConfigKey(), this.getClientHostName(), this.getDefContent(), this.isError() ? this.getRequestConfigChecksums() : this.newConfigChecksums(), this.isError() ? this.getRequestGeneration() : this.newGen(), timeout, Trace.createNew(), this.requestData.getCompressionType(), this.requestData.getVespaVersion());
    }

    public static <T extends ConfigInstance> JRTClientConfigRequest createFromSub(JRTConfigSubscription<T> sub, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        ConfigSubscription.ConfigState configState = sub.getConfigState();
        return JRTClientConfigRequestV3.createWithParams(sub.getKey(), sub.getDefContent(), ConfigUtils.getCanonicalHostName(), configState.getChecksums(), configState.getGeneration(), sub.timingValues().getSubscribeTimeout(), trace, compressionType, vespaVersion);
    }

    public static JRTClientConfigRequest createFromRaw(RawConfig config, long serverTimeout, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        String hostname = ConfigUtils.getCanonicalHostName();
        return JRTClientConfigRequestV3.createWithParams(config.getKey(), DefContent.fromList(config.getDefContent()), hostname, config.getPayloadChecksums(), config.getGeneration(), serverTimeout, trace, compressionType, vespaVersion);
    }

    public static JRTClientConfigRequest createWithParams(ConfigKey<?> reqKey, DefContent defContent, String hostname, PayloadChecksums payloadChecksums, long generation, long serverTimeout, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        return new JRTClientConfigRequestV3(reqKey, hostname, defContent, payloadChecksums, generation, serverTimeout, trace, compressionType, vespaVersion);
    }

    @Override
    public Optional<VespaVersion> getVespaVersion() {
        return this.requestData.getVespaVersion();
    }

    @Override
    public ConfigKey<?> getConfigKey() {
        return this.requestData.getConfigKey();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("request='").append(this.getConfigKey()).append(",").append(this.getClientHostName()).append(",").append(this.getRequestConfigChecksums()).append(",").append(this.getRequestGeneration()).append(",").append(this.getTimeout()).append(",").append(this.getVespaVersion().map(VespaVersion::toString).orElse("")).append("'\n");
        sb.append("response='").append(this.getNewChecksums()).append(",").append(this.getNewGeneration()).append(",").append(this.responseIsApplyOnRestart()).append("'\n");
        return sb.toString();
    }

    @Override
    public String getClientHostName() {
        return this.requestData.getClientHostName();
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public int errorCode() {
        return this.request.errorCode();
    }

    @Override
    public String errorMessage() {
        return this.request.errorMessage();
    }

    @Override
    public String getShortDescription() {
        return this.toString();
    }

    @Override
    public boolean hasUpdatedGeneration() {
        long prevGen = this.getRequestGeneration();
        long newGen = this.getNewGeneration();
        return ConfigUtils.isGenerationNewer(newGen, prevGen);
    }

    @Override
    public long getTimeout() {
        return this.requestData.getTimeout();
    }

    protected PayloadChecksums newConfigChecksums() {
        PayloadChecksums newChecksum = this.getNewChecksums();
        if (PayloadChecksums.empty().equals(newChecksum)) {
            return this.getRequestConfigChecksums();
        }
        return newChecksum;
    }

    protected long newGen() {
        long newGen = this.getNewGeneration();
        if (newGen == 0L) {
            return this.getRequestGeneration();
        }
        return newGen;
    }

    @Override
    public DefContent getDefContent() {
        return this.requestData.getSchema();
    }

    @Override
    public boolean isError() {
        return this.request.isError();
    }

    @Override
    public boolean hasUpdatedConfig() {
        boolean updated;
        PayloadChecksums requestConfigChecksums = this.getRequestConfigChecksums();
        log.log(Level.FINE, () -> "request checksums for " + this.getConfigKey() + ":" + requestConfigChecksums);
        PayloadChecksums newChecksums = this.getNewChecksums();
        log.log(Level.FINE, () -> "new checksums for " + this.getConfigKey() + ": " + newChecksums);
        if (newChecksums.isEmpty()) {
            return false;
        }
        PayloadChecksum respMd5 = newChecksums.getForType(PayloadChecksum.Type.MD5);
        boolean bl = updated = respMd5 != null && !requestConfigChecksums.getForType(PayloadChecksum.Type.MD5).equals(respMd5);
        if (updated) {
            return true;
        }
        PayloadChecksum respXxhash64 = newChecksums.getForType(PayloadChecksum.Type.XXHASH64);
        return respXxhash64 != null && !requestConfigChecksums.getForType(PayloadChecksum.Type.XXHASH64).equals(respXxhash64);
    }

    @Override
    public Trace getResponseTrace() {
        return this.responseData.getResponseTrace();
    }

    @Override
    public String getRequestDefMd5() {
        return this.requestData.getRequestDefMd5();
    }

    @Override
    public PayloadChecksums getRequestConfigChecksums() {
        return this.requestData.getRequestConfigChecksums();
    }

    @Override
    public boolean validateResponse() {
        if (this.request.isError()) {
            return false;
        }
        if (this.request.returnValues().size() == 0) {
            return false;
        }
        if (!this.checkReturnTypes(this.request)) {
            log.warning("Invalid return types for config response: " + this.errorMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean validateParameters() {
        int errorCode = RequestValidation.validateRequest(this);
        return errorCode == 0;
    }

    @Override
    public PayloadChecksums getNewChecksums() {
        return this.responseData.getResponseConfigChecksums();
    }

    @Override
    public long getNewGeneration() {
        return this.responseData.getResponseConfigGeneration();
    }

    @Override
    public boolean responseIsApplyOnRestart() {
        return this.responseData.getResponseApplyOnRestart();
    }

    @Override
    public long getRequestGeneration() {
        return this.requestData.getRequestGeneration();
    }

    protected SlimeResponseData getResponseData() {
        return this.responseData;
    }
}

