/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.DirSource;
import com.yahoo.config.subscription.FileSource;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import java.io.File;

public class ConfigURI {
    private final String configId;
    private final ConfigSource source;

    private ConfigURI(String configId, ConfigSource source) {
        this.configId = configId;
        this.source = source;
    }

    public String getConfigId() {
        return this.configId;
    }

    public ConfigSource getSource() {
        return this.source;
    }

    public static ConfigURI createFromId(String configId) {
        return new ConfigURI(ConfigURI.getConfigId(configId), ConfigURI.getConfigSource(configId));
    }

    private static ConfigSource getConfigSource(String configId) {
        if (configId.startsWith("file:")) {
            return new FileSource(new File(configId.substring(5)));
        }
        if (configId.startsWith("dir:")) {
            return new DirSource(new File(configId.substring(4)));
        }
        return JRTConfigRequester.defaultSourceSet;
    }

    private static String getConfigId(String configId) {
        if (configId.startsWith("file:") || configId.startsWith("dir:")) {
            return "";
        }
        return configId;
    }

    public static ConfigURI createFromIdAndSource(String configId, ConfigSource source) {
        return new ConfigURI(configId, source);
    }
}

