/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import java.util.List;
import java.util.logging.Level;

public class GenericJRTConfigSubscription
extends JRTConfigSubscription<RawConfig> {
    private final List<String> defContent;

    public GenericJRTConfigSubscription(ConfigKey<RawConfig> key, List<String> defContent, JRTConfigRequester requester, TimingValues timingValues) {
        super(key, requester, timingValues);
        this.defContent = defContent;
    }

    @Override
    protected void setNewConfig(JRTClientConfigRequest jrtReq) {
        RawConfig rawConfig = RawConfig.createFromResponseParameters(jrtReq);
        this.setConfig(jrtReq.getNewGeneration(), jrtReq.responseIsApplyOnRestart(), rawConfig, jrtReq.getNewChecksums());
        log.log(Level.FINE, () -> "in setNewConfig, config=" + this.getConfigState().getConfig());
    }

    @Override
    void setGeneration(Long generation) {
        super.setGeneration(generation);
        ConfigSubscription.ConfigState configState = this.getConfigState();
        if (configState.getConfig() != null) {
            ((RawConfig)((Object)configState.getConfig())).setGeneration(generation);
        }
    }

    @Override
    protected void setNewConfigAndGeneration(JRTClientConfigRequest jrtReq) {
        this.setGeneration(jrtReq.getNewGeneration());
        RawConfig rawConfig = RawConfig.createFromResponseParameters(jrtReq);
        this.setConfigAndGeneration(jrtReq.getNewGeneration(), jrtReq.responseIsApplyOnRestart(), rawConfig, jrtReq.getNewChecksums());
    }

    @Override
    void setApplyOnRestart(boolean applyOnRestart) {
        super.setApplyOnRestart(applyOnRestart);
        ConfigSubscription.ConfigState configState = this.getConfigState();
        if (configState.getConfig() != null) {
            ((RawConfig)((Object)configState.getConfig())).setApplyOnRestart(applyOnRestart);
        }
    }

    public RawConfig getRawConfig() {
        return (RawConfig)((Object)this.getConfigState().getConfig());
    }

    @Override
    public DefContent getDefContent() {
        return DefContent.fromList(this.defContent);
    }
}

