/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.yolean.Exceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ConfigDefinition {
    public static final Pattern namePattern = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_]*");
    public static final Pattern namespacePattern = Pattern.compile("[a-zA-Z][a-zA-Z0-9-._]*");
    public static final Logger log = Logger.getLogger(ConfigDefinition.class.getName());
    private final String name;
    private final String namespace;
    ConfigDefinition parent = null;
    private final Map<String, StringDef> stringDefs = new LinkedHashMap<String, StringDef>();
    private final Map<String, BoolDef> boolDefs = new LinkedHashMap<String, BoolDef>();
    private final Map<String, IntDef> intDefs = new LinkedHashMap<String, IntDef>();
    private final Map<String, LongDef> longDefs = new LinkedHashMap<String, LongDef>();
    private final Map<String, DoubleDef> doubleDefs = new LinkedHashMap<String, DoubleDef>();
    private final Map<String, EnumDef> enumDefs = new LinkedHashMap<String, EnumDef>();
    private final Map<String, RefDef> referenceDefs = new LinkedHashMap<String, RefDef>();
    private final Map<String, FileDef> fileDefs = new LinkedHashMap<String, FileDef>();
    private final Map<String, PathDef> pathDefs = new LinkedHashMap<String, PathDef>();
    private final Map<String, OptionalPathDef> optionalPathDefs = new LinkedHashMap<String, OptionalPathDef>();
    private final Map<String, UrlDef> urlDefs = new LinkedHashMap<String, UrlDef>();
    private final Map<String, ModelDef> modelDefs = new LinkedHashMap<String, ModelDef>();
    private final Map<String, StructDef> structDefs = new LinkedHashMap<String, StructDef>();
    private final Map<String, InnerArrayDef> innerArrayDefs = new LinkedHashMap<String, InnerArrayDef>();
    private final Map<String, ArrayDef> arrayDefs = new LinkedHashMap<String, ArrayDef>();
    private final Map<String, LeafMapDef> leafMapDefs = new LinkedHashMap<String, LeafMapDef>();
    private final Map<String, StructMapDef> structMapDefs = new LinkedHashMap<String, StructMapDef>();
    static final Integer INT_MIN = Integer.MIN_VALUE;
    static final Integer INT_MAX = Integer.MAX_VALUE;
    static final Long LONG_MIN = Long.MIN_VALUE;
    static final Long LONG_MAX = Long.MAX_VALUE;
    private static final Double DOUBLE_MIN = -1.0E308;
    private static final Double DOUBLE_MAX = 1.0E308;

    public ConfigDefinition(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private ConfigDefinition getParent() {
        return this.parent;
    }

    private ConfigDefinition getRoot() {
        ConfigDefinition ancestor = this;
        while (ancestor.getParent() != null) {
            ancestor = ancestor.getParent();
        }
        return ancestor;
    }

    private static void defFail(String id, String val, String type, Exception e) {
        throw new IllegalArgumentException("Invalid value '" + val + "' for " + type + " '" + id + "': " + Exceptions.toMessageString((Throwable)e));
    }

    public void verify(String id, String val) {
        if (this.stringDefs.containsKey(id)) {
            this.verifyString(id);
        } else if (this.enumDefs.containsKey(id)) {
            this.verifyEnum(id, val);
        } else if (this.referenceDefs.containsKey(id)) {
            this.verifyReference(id);
        } else if (this.fileDefs.containsKey(id)) {
            this.verifyFile(id);
        } else if (this.pathDefs.containsKey(id)) {
            this.verifyPath(id);
        } else if (this.optionalPathDefs.containsKey(id)) {
            this.verifyOptionalPath(id);
        } else if (this.urlDefs.containsKey(id)) {
            this.verifyUrl(id);
        } else if (this.modelDefs.containsKey(id)) {
            this.verifyModel(id);
        } else if (this.boolDefs.containsKey(id)) {
            this.verifyBool(id, val);
        } else if (this.intDefs.containsKey(id)) {
            this.verifyInt(id, val);
        } else if (this.longDefs.containsKey(id)) {
            this.verifyLong(id, val);
        } else if (this.doubleDefs.containsKey(id)) {
            this.verifyDouble(id, val);
        } else if (this.structDefs.containsKey(id)) {
            this.verifyStruct(id);
        } else if (this.arrayDefs.containsKey(id)) {
            this.verifyArray(id);
        } else if (this.innerArrayDefs.containsKey(id)) {
            this.verifyInnerArray(id);
        } else if (this.leafMapDefs.containsKey(id)) {
            this.verifyLeafMap(id);
        } else if (this.structMapDefs.containsKey(id)) {
            this.verifyStructMap(id);
        } else {
            throw new IllegalArgumentException("No such field in definition " + this.getRoot().getNamespace() + "." + this.getRoot().getName() + ": " + this.getAncestorString() + id);
        }
    }

    private void verifyDouble(String id, String val) {
        try {
            this.verifyDouble(id, Double.parseDouble(val));
        }
        catch (NumberFormatException e) {
            ConfigDefinition.defFail(id, val, "double", e);
        }
    }

    private void verifyBool(String id, String val) {
        if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
            this.verifyBool(id);
        } else {
            ConfigDefinition.defFail(id, val, "bool", null);
        }
    }

    public void verify(String id) {
        this.verify(id, null);
    }

    public void addEnumDef(String id, EnumDef def) {
        this.enumDefs.put(id, def);
    }

    public void addInnerArrayDef(String id) {
        this.innerArrayDefs.put(id, new InnerArrayDef(id, this));
    }

    public void addLeafMapDef(String id) {
        this.leafMapDefs.put(id, new LeafMapDef(id, this));
    }

    public void addEnumDef(String id, List<String> vals, String defVal) {
        ArrayList<String> in = new ArrayList<String>();
        for (String ins : vals) {
            in.add(ins.trim());
        }
        this.enumDefs.put(id, new EnumDef(in, defVal));
    }

    public void addEnumDef(String id, String valsCommaSep, String defVal) {
        String[] valArr = valsCommaSep.split(",");
        this.addEnumDef(id, Arrays.asList(valArr), defVal);
    }

    public void addStringDef(String id, String defVal) {
        this.stringDefs.put(id, new StringDef(defVal));
    }

    public void addStringDef(String id) {
        this.stringDefs.put(id, new StringDef(null));
    }

    public void addIntDef(String id, Integer defVal, Integer min, Integer max) {
        this.intDefs.put(id, new IntDef(defVal, min, max));
    }

    public void addIntDef(String id, Integer defVal) {
        this.addIntDef(id, defVal, INT_MIN, INT_MAX);
    }

    public void addIntDef(String id) {
        this.addIntDef(id, null);
    }

    public void addLongDef(String id, Long defVal, Long min, Long max) {
        this.longDefs.put(id, new LongDef(defVal, min, max));
    }

    public void addLongDef(String id, Long defVal) {
        this.addLongDef(id, defVal, LONG_MIN, LONG_MAX);
    }

    public void addLongDef(String id) {
        this.addLongDef(id, null);
    }

    public void addBoolDef(String id) {
        this.boolDefs.put(id, new BoolDef(null));
    }

    public void addBoolDef(String id, Boolean defVal) {
        this.boolDefs.put(id, new BoolDef(defVal));
    }

    public void addDoubleDef(String id, Double defVal, Double min, Double max) {
        this.doubleDefs.put(id, new DoubleDef(defVal, min, max));
    }

    public void addDoubleDef(String id, Double defVal) {
        this.addDoubleDef(id, defVal, DOUBLE_MIN, DOUBLE_MAX);
    }

    public void addDoubleDef(String id) {
        this.addDoubleDef(id, null);
    }

    public void addReferenceDef(String refId, String defVal) {
        this.referenceDefs.put(refId, new RefDef(defVal));
    }

    public void addReferenceDef(String refId) {
        this.referenceDefs.put(refId, new RefDef(null));
    }

    public void addFileDef(String refId) {
        this.fileDefs.put(refId, new FileDef(null));
    }

    public void addPathDef(String refId) {
        this.pathDefs.put(refId, new PathDef(null));
    }

    public void addOptionalPathDef(String refId) {
        this.optionalPathDefs.put(refId, new OptionalPathDef(null));
    }

    public void addUrlDef(String url, String defVal) {
        this.urlDefs.put(url, new UrlDef(defVal));
    }

    public void addModelDef(String modelName) {
        this.modelDefs.put(modelName, new ModelDef());
    }

    public void addUrlDef(String url) {
        this.urlDefs.put(url, new UrlDef(null));
    }

    public Map<String, StringDef> getStringDefs() {
        return this.stringDefs;
    }

    public Map<String, BoolDef> getBoolDefs() {
        return this.boolDefs;
    }

    public Map<String, IntDef> getIntDefs() {
        return this.intDefs;
    }

    public Map<String, LongDef> getLongDefs() {
        return this.longDefs;
    }

    public Map<String, DoubleDef> getDoubleDefs() {
        return this.doubleDefs;
    }

    public Map<String, RefDef> getReferenceDefs() {
        return this.referenceDefs;
    }

    public Map<String, FileDef> getFileDefs() {
        return this.fileDefs;
    }

    public Map<String, PathDef> getPathDefs() {
        return this.pathDefs;
    }

    public Map<String, OptionalPathDef> getOptionalPathDefs() {
        return this.optionalPathDefs;
    }

    public Map<String, UrlDef> getUrlDefs() {
        return this.urlDefs;
    }

    public Map<String, ModelDef> getModelDefs() {
        return this.modelDefs;
    }

    public Map<String, InnerArrayDef> getInnerArrayDefs() {
        return this.innerArrayDefs;
    }

    public Map<String, LeafMapDef> getLeafMapDefs() {
        return this.leafMapDefs;
    }

    public Map<String, StructMapDef> getStructMapDefs() {
        return this.structMapDefs;
    }

    public InnerArrayDef innerArrayDef(String name) {
        InnerArrayDef ret = this.innerArrayDefs.get(name);
        if (ret != null) {
            return ret;
        }
        ret = new InnerArrayDef(name, this);
        this.innerArrayDefs.put(name, ret);
        return ret;
    }

    public Map<String, StructDef> getStructDefs() {
        return this.structDefs;
    }

    public StructDef structDef(String name) {
        StructDef ret = this.structDefs.get(name);
        if (ret != null) {
            return ret;
        }
        ret = new StructDef(name, this);
        this.structDefs.put(name, ret);
        return ret;
    }

    public Map<String, EnumDef> getEnumDefs() {
        return this.enumDefs;
    }

    public ArrayDef arrayDef(String name) {
        ArrayDef ret = this.arrayDefs.get(name);
        if (ret != null) {
            return ret;
        }
        ret = new ArrayDef(name, this);
        this.arrayDefs.put(name, ret);
        return ret;
    }

    public Map<String, ArrayDef> getArrayDefs() {
        return this.arrayDefs;
    }

    public StructMapDef structMapDef(String name) {
        StructMapDef ret = this.structMapDefs.get(name);
        if (ret != null) {
            return ret;
        }
        ret = new StructMapDef(name, this);
        this.structMapDefs.put(name, ret);
        return ret;
    }

    public LeafMapDef leafMapDef(String name) {
        LeafMapDef ret = this.leafMapDefs.get(name);
        if (ret != null) {
            return ret;
        }
        ret = new LeafMapDef(name, this);
        this.leafMapDefs.put(name, ret);
        return ret;
    }

    private void verifyDouble(String id, Double val) {
        DoubleDef def = this.doubleDefs.get(id);
        if (def == null) {
            throw new IllegalArgumentException("No such double in " + this.verifyWarning(id));
        }
        if (val == null) {
            return;
        }
        if (def.getMin() != null && val < def.getMin()) {
            ConfigDefinition.failTooSmall(val, def.getMin(), this.toString(), this.getAncestorString() + id);
        }
        if (def.getMax() != null && val > def.getMax()) {
            ConfigDefinition.failTooBig(val, def.getMax(), this.toString(), this.getAncestorString() + id);
        }
    }

    private void verifyEnum(String id, String val) {
        EnumDef def = this.enumDefs.get(id);
        if (def == null) {
            throw new IllegalArgumentException("No such enum in " + this.verifyWarning(id));
        }
        if (!def.getVals().contains(val)) {
            throw new IllegalArgumentException("Invalid enum value '" + val + "' in def " + this + " enum '" + this.getAncestorString() + id + "'");
        }
    }

    private void verifyInt(String id, Integer val) {
        IntDef def = this.intDefs.get(id);
        if (def == null) {
            throw new IllegalArgumentException("No such integer in " + this.verifyWarning(id));
        }
        if (val == null) {
            return;
        }
        if (def.getMin() != null && val < def.getMin()) {
            ConfigDefinition.failTooSmall(val, def.getMin(), this.name, id);
        }
        if (def.getMax() != null && val > def.getMax()) {
            ConfigDefinition.failTooBig(val, def.getMax(), this.name, id);
        }
    }

    private void verifyInt(String id, String val) {
        try {
            this.verifyInt(id, Integer.parseInt(val));
        }
        catch (NumberFormatException e) {
            ConfigDefinition.defFail(id, val, "int", e);
        }
    }

    private void verifyLong(String id, String val) {
        try {
            this.verifyLong(id, Long.parseLong(val));
        }
        catch (NumberFormatException e) {
            ConfigDefinition.defFail(id, val, "long", e);
        }
    }

    private void verifyLong(String id, Long val) {
        LongDef def = this.longDefs.get(id);
        if (def == null) {
            throw new IllegalArgumentException("No such long in " + this.verifyWarning(id));
        }
        if (val == null) {
            return;
        }
        if (def.getMin() != null && val < def.getMin()) {
            ConfigDefinition.failTooSmall(val, def.getMin(), this.name, id);
        }
        if (def.getMax() != null && val > def.getMax()) {
            ConfigDefinition.failTooBig(val, def.getMax(), this.name, id);
        }
    }

    private static void failTooSmall(Object val, Object min, String defName, String valKey) {
        throw new IllegalArgumentException("Value '" + valKey + "' outside range in definition '" + defName + "': " + val + "<" + min);
    }

    private static void failTooBig(Object val, Object max, String defName, String valKey) {
        throw new IllegalArgumentException("Value '" + valKey + "' outside range in definition '" + defName + "': " + val + ">" + max);
    }

    private static void failInvalidEnum(Object val, String defName, String defKey) {
        throw new IllegalArgumentException("Invalid enum value '" + val + "' for '" + defKey + "' in definition '" + defName);
    }

    private void verifyString(String id) {
        if (!this.stringDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such string in " + this.verifyWarning(id));
        }
    }

    private void verifyReference(String id) {
        if (!this.referenceDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such reference in " + this.verifyWarning(id));
        }
    }

    private void verifyFile(String id) {
        if (!this.fileDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such file in " + this.verifyWarning(id));
        }
    }

    private void verifyPath(String id) {
        if (!this.pathDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such path in " + this.verifyWarning(id));
        }
    }

    private void verifyOptionalPath(String id) {
        if (!this.optionalPathDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such optional path in " + this.verifyWarning(id));
        }
    }

    private void verifyUrl(String id) {
        if (!this.urlDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such url in " + this.verifyWarning(id));
        }
    }

    private void verifyModel(String field) {
        if (!this.modelDefs.containsKey(field)) {
            throw new IllegalArgumentException("No such model in " + this.verifyWarning(field));
        }
    }

    private void verifyBool(String id) {
        if (!this.boolDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such bool in " + this.verifyWarning(id));
        }
    }

    private void verifyArray(String id) {
        String message = "No such array in " + this.verifyWarning(id);
        if (!this.arrayDefs.containsKey(id)) {
            if (this.innerArrayDefs.containsKey(id)) {
                message = message + ". However, the definition does contain an inner array with the same name";
            }
            throw new IllegalArgumentException(message);
        }
    }

    private void verifyInnerArray(String id) {
        String message = "No such inner array in " + this.verifyWarning(id);
        if (!this.innerArrayDefs.containsKey(id)) {
            if (this.arrayDefs.containsKey(id)) {
                message = message + ". However, the definition does contain an array with the same name";
            }
            throw new IllegalArgumentException(message);
        }
    }

    private void verifyStruct(String id) {
        if (!this.structDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such struct in " + this.verifyWarning(id));
        }
    }

    private void verifyLeafMap(String id) {
        if (!this.leafMapDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such leaf map in " + this.verifyWarning(id));
        }
    }

    private void verifyStructMap(String id) {
        if (!this.structMapDefs.containsKey(id)) {
            throw new IllegalArgumentException("No such struct map in " + this.verifyWarning(id));
        }
    }

    private String verifyWarning(String id) {
        return "definition '" + this.getRoot().toString() + "': " + this.getAncestorString() + id;
    }

    private String getAncestorString() {
        StringBuilder ret = new StringBuilder();
        ConfigDefinition ancestor = this;
        while (ancestor.getParent() != null) {
            ret.insert(0, ancestor.getName() + ".");
            ancestor = ancestor.getParent();
        }
        return ret.toString();
    }

    public String toString() {
        return this.getNamespace() + "." + this.getName();
    }

    public static class InnerArrayDef
    extends ConfigDefinition {
        InnerArrayDef(String name, ConfigDefinition parent) {
            super(name, parent.getNamespace());
            this.parent = parent;
        }
    }

    public static class LeafMapDef
    extends ConfigDefinition {
        private TypeSpec typeSpec;

        LeafMapDef(String name, ConfigDefinition parent) {
            super(name, parent.getNamespace());
            this.parent = parent;
        }

        public TypeSpec getTypeSpec() {
            return this.typeSpec;
        }

        public void setTypeSpec(TypeSpec typeSpec) {
            this.typeSpec = typeSpec;
        }
    }

    public static class EnumDef
    implements DefaultValued<String> {
        private final List<String> vals;
        private final String defVal;

        EnumDef(List<String> vals, String defVal) {
            if (defVal != null && !vals.contains(defVal)) {
                throw new IllegalArgumentException("Def val " + defVal + " is not in given vals " + vals);
            }
            this.vals = vals;
            this.defVal = defVal;
        }

        List<String> getVals() {
            return this.vals;
        }

        @Override
        public String getDefVal() {
            return this.defVal;
        }
    }

    public static class StringDef
    implements DefaultValued<String> {
        private final String defVal;

        StringDef(String def) {
            this.defVal = def;
        }

        @Override
        public String getDefVal() {
            return this.defVal;
        }
    }

    public static class IntDef
    implements DefaultValued<Integer> {
        private final Integer defVal;
        private final Integer min;
        private final Integer max;

        IntDef(Integer def, Integer min, Integer max) {
            this.defVal = def;
            this.min = Objects.requireNonNullElse(min, INT_MIN);
            this.max = Objects.requireNonNullElse(max, INT_MAX);
        }

        @Override
        public Integer getDefVal() {
            return this.defVal;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }
    }

    public static class LongDef
    implements DefaultValued<Long> {
        private final Long defVal;
        private final Long min;
        private final Long max;

        LongDef(Long def, Long min, Long max) {
            this.defVal = def;
            this.min = Objects.requireNonNullElse(min, LONG_MIN);
            this.max = Objects.requireNonNullElse(max, LONG_MAX);
        }

        @Override
        public Long getDefVal() {
            return this.defVal;
        }

        public Long getMin() {
            return this.min;
        }

        public Long getMax() {
            return this.max;
        }
    }

    public static class BoolDef
    implements DefaultValued<Boolean> {
        private final Boolean defVal;

        BoolDef(Boolean def) {
            this.defVal = def;
        }

        @Override
        public Boolean getDefVal() {
            return this.defVal;
        }
    }

    public static class DoubleDef
    implements DefaultValued<Double> {
        private final Double defVal;
        private final Double min;
        private final Double max;

        DoubleDef(Double defVal, Double min, Double max) {
            this.defVal = defVal;
            this.min = Objects.requireNonNullElse(min, DOUBLE_MIN);
            this.max = Objects.requireNonNullElse(max, DOUBLE_MAX);
        }

        @Override
        public Double getDefVal() {
            return this.defVal;
        }

        Double getMin() {
            return this.min;
        }

        Double getMax() {
            return this.max;
        }
    }

    public static class RefDef
    implements DefaultValued<String> {
        private final String defVal;

        RefDef(String defVal) {
            this.defVal = defVal;
        }

        @Override
        public String getDefVal() {
            return this.defVal;
        }
    }

    public static class FileDef
    implements DefaultValued<String> {
        private final String defVal;

        FileDef(String defVal) {
            this.defVal = defVal;
        }

        @Override
        public String getDefVal() {
            return this.defVal;
        }
    }

    public static class PathDef
    implements DefaultValued<String> {
        private final String defVal;

        PathDef(String defVal) {
            this.defVal = defVal;
        }

        @Override
        public String getDefVal() {
            return this.defVal;
        }
    }

    public static class OptionalPathDef
    implements DefaultValued<String> {
        private final String defVal;

        OptionalPathDef(String defVal) {
            this.defVal = defVal;
        }

        @Override
        public String getDefVal() {
            return this.defVal;
        }
    }

    public static class UrlDef
    implements DefaultValued<String> {
        private final String defVal;

        UrlDef(String defVal) {
            this.defVal = defVal;
        }

        @Override
        public String getDefVal() {
            return this.defVal;
        }
    }

    public static class ModelDef {
    }

    public static class StructDef
    extends ConfigDefinition {
        StructDef(String name, ConfigDefinition parent) {
            super(name, parent.getNamespace());
            this.parent = parent;
        }
    }

    public static class ArrayDef
    extends ConfigDefinition {
        private TypeSpec typeSpec;

        ArrayDef(String name, ConfigDefinition parent) {
            super(name, parent.getNamespace());
            this.parent = parent;
        }

        public TypeSpec getTypeSpec() {
            return this.typeSpec;
        }

        public void setTypeSpec(TypeSpec typeSpec) {
            this.typeSpec = typeSpec;
        }

        public void verify(String val, int index) {
            if (val != null && this.getTypeSpec() != null) {
                TypeSpec spec = this.getTypeSpec();
                spec.checkValue(this.getName(), val, index);
            }
        }
    }

    public static class StructMapDef
    extends ConfigDefinition {
        StructMapDef(String name, ConfigDefinition parent) {
            super(name, parent.getNamespace());
            this.parent = parent;
        }
    }

    public static interface DefaultValued<T> {
        public T getDefVal();
    }

    public static class TypeSpec {
        private final String type;
        private Integer index;
        private final String name;
        private final Object defVal;
        private final Object min;
        private final Object max;
        private final List<String> enumVals;

        public TypeSpec(String name, String type, Object defVal, String enumValsCommaSep, Object min, Object max) {
            this.name = name;
            this.type = type;
            this.defVal = defVal;
            this.enumVals = this.getEnumVals(enumValsCommaSep);
            this.min = min;
            this.max = max;
        }

        private List<String> getEnumVals(String commaSep) {
            if (commaSep == null) {
                return null;
            }
            ArrayList<String> in = new ArrayList<String>();
            for (String val : commaSep.split(",")) {
                in.add(val.trim());
            }
            return in;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Object getDef() {
            return this.defVal;
        }

        public Object getMin() {
            return this.min;
        }

        public Object getMax() {
            return this.max;
        }

        public List<String> getEnumVals() {
            return this.enumVals;
        }

        void checkValue(String id, String val, int index) {
            if ("int".equals(this.getType())) {
                this.checkInt(id, val, index);
            } else if ("long".equals(this.getType())) {
                this.checkLong(id, val, index);
            } else if ("double".equals(this.getType())) {
                this.checkDouble(id, val, index);
            } else if ("enum".equals(this.getType())) {
                this.checkEnum(id, val, index);
            }
        }

        private boolean checkEnum(String id, String val, int index) {
            if (!this.getEnumVals().contains(val)) {
                ConfigDefinition.failInvalidEnum(val, id, id + "[" + index + "]");
                return false;
            }
            return true;
        }

        private void checkDouble(String id, String val, int index) {
            try {
                this.checkDouble(Double.parseDouble(val), id, index);
            }
            catch (NumberFormatException e) {
                ConfigDefinition.defFail(id, val, "double", e);
            }
        }

        private void checkLong(String id, String val, int index) {
            try {
                this.checkLong(Long.parseLong(val), id, index);
            }
            catch (NumberFormatException e) {
                ConfigDefinition.defFail(id, val, "long", e);
            }
        }

        private void checkInt(String id, String val, int index) {
            try {
                this.checkInt(Integer.parseInt(val), id, index);
            }
            catch (NumberFormatException e) {
                ConfigDefinition.defFail(id, val, "int", e);
            }
        }

        private void checkInt(Integer theVal, String id, int arrayIndex) {
            if (!"int".equals(this.getType())) {
                throw new IllegalArgumentException("Illegal value '" + theVal + "' for array '" + id + "'");
            }
            if (this.getMax() != null && theVal > (Integer)this.getMax()) {
                ConfigDefinition.failTooBig(theVal, this.getMax(), id, id + "[" + arrayIndex + "]");
            }
            if (this.getMin() != null && theVal < (Integer)this.getMin()) {
                ConfigDefinition.failTooSmall(theVal, this.getMin(), id, id + "[" + arrayIndex + "]");
            }
        }

        private void checkLong(Long theVal, String id, int arrayIndex) {
            if (!"long".equals(this.getType())) {
                throw new IllegalArgumentException("Illegal value '" + theVal + "' for array '" + id + "'");
            }
            if (this.getMax() != null && theVal > (Long)this.getMax()) {
                ConfigDefinition.failTooBig(theVal, this.getMax(), id, id + "[" + arrayIndex + "]");
            }
            if (this.getMin() != null && theVal < (Long)this.getMin()) {
                ConfigDefinition.failTooSmall(theVal, this.getMin(), id, id + "[" + arrayIndex + "]");
            }
        }

        private void checkDouble(Double theVal, String id, int arrayIndex) {
            if (!"double".equals(this.getType())) {
                throw new IllegalArgumentException("Illegal value '" + theVal + "' for array " + id + ", array type is " + this.getType());
            }
            if (this.getMax() != null && theVal > (Double)this.getMax()) {
                ConfigDefinition.failTooBig(theVal, this.getMax(), id, id + "[" + arrayIndex + "]");
            }
            if (this.getMin() != null && theVal < (Double)this.getMin()) {
                ConfigDefinition.failTooSmall(theVal, this.getMin(), id, id + "[" + arrayIndex + "]");
            }
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public Integer getIndex() {
            return this.index;
        }
    }
}

