/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.LeafCNode;
import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.Slime;

public class DefaultValueApplier {
    public Slime applyDefaults(Slime slime, InnerCNode def) {
        this.applyDefaultsRecursive(slime.get(), def);
        return slime;
    }

    private void applyDefaultsRecursive(Cursor cursor, InnerCNode def) {
        if (def.isArray) {
            this.applyDefaultsToArray(cursor, def);
        } else if (def.isMap) {
            this.applyDefaultsToMap(cursor, def);
        } else {
            this.applyDefaultsToObject(cursor, def);
        }
    }

    private void applyDefaultsToMap(final Cursor cursor, final InnerCNode def) {
        cursor.traverse(new ObjectTraverser(){

            public void field(String name, Inspector inspector) {
                DefaultValueApplier.this.applyDefaultsToObject(cursor.field(name), def);
            }
        });
    }

    private void applyDefaultsToArray(final Cursor cursor, final InnerCNode def) {
        cursor.traverse(new ArrayTraverser(){

            public void entry(int idx, Inspector inspector) {
                DefaultValueApplier.this.applyDefaultsToObject(cursor.entry(idx), def);
            }
        });
    }

    private void applyDefaultsToObject(Cursor cursor, InnerCNode def) {
        for (CNode child : def.getChildren()) {
            Cursor childCursor = cursor.field(child.getName());
            if (this.isLeafNode(child) && this.canApplyDefault(childCursor, child)) {
                this.applyDefaultToLeaf(cursor, child);
                continue;
            }
            if (!this.isInnerNode(child)) continue;
            if (!childCursor.valid()) {
                childCursor = child.isArray ? cursor.setArray(child.getName()) : cursor.setObject(child.getName());
            }
            this.applyDefaultsRecursive(childCursor, (InnerCNode)child);
        }
    }

    private boolean isInnerNode(CNode child) {
        return child instanceof InnerCNode;
    }

    private boolean isLeafNode(CNode child) {
        return child instanceof LeafCNode;
    }

    private void applyDefaultToLeaf(Cursor cursor, CNode child) {
        cursor.setString(child.getName(), ((LeafCNode)child).getDefaultValue().getValue());
    }

    private boolean canApplyDefault(Cursor cursor, CNode child) {
        return !cursor.valid() && ((LeafCNode)child).getDefaultValue() != null;
    }
}

