/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.util;

import com.yahoo.collections.Tuple2;
import com.yahoo.io.HexDump;
import com.yahoo.io.IOUtils;
import com.yahoo.net.HostName;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.SlimeFormat;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayload;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigUtils {
    private static final Pattern intPattern = Pattern.compile(".*int.*range.*");
    private static final Pattern doublePattern = Pattern.compile(".*double.*range.*");
    private static final Pattern spaceBeforeCommaPatter = Pattern.compile("\\s,");
    public static final String intFormattedMax = new DecimalFormat("#.#").format(Integer.MAX_VALUE);
    public static final String intFormattedMin = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ENGLISH)).format(Integer.MIN_VALUE);
    public static final String doubleFormattedMax = new DecimalFormat("#.#").format(1.0E308);
    public static final String doubleFormattedMin = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ENGLISH)).format(-1.0E308);

    public static String getMd5(ConfigPayload payload) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            payload.serialize(baos, (SlimeFormat)new JsonFormat(true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MessageDigest md5 = ConfigUtils.getMd5Instance();
        md5.update(baos.toByteArray());
        return HexDump.toHexString((byte[])md5.digest()).toLowerCase();
    }

    public static String getMd5(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if ((line = line.trim()).length() <= 0) continue;
            sb.append(line).append("\n");
        }
        MessageDigest md5 = ConfigUtils.getMd5Instance();
        md5.update(Utf8.toBytes((String)sb.toString()));
        return HexDump.toHexString((byte[])md5.digest()).toLowerCase();
    }

    public static String getMd5(String input) {
        MessageDigest md5 = ConfigUtils.getMd5Instance();
        md5.update(IOUtils.utf8ByteBuffer((String)input));
        return HexDump.toHexString((byte[])md5.digest()).toLowerCase();
    }

    public static String getMd5(Utf8Array input) {
        MessageDigest md5 = ConfigUtils.getMd5Instance();
        md5.update(input.getBytes());
        return HexDump.toHexString((byte[])md5.digest()).toLowerCase();
    }

    private static MessageDigest getMd5Instance() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String stripSpaces(String str) {
        StringBuilder ret = new StringBuilder("");
        boolean inQuotes = false;
        boolean inSpaceSequence = false;
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) {
                if (inQuotes) {
                    ret.append(c);
                    continue;
                }
                if (inSpaceSequence) continue;
                inSpaceSequence = true;
                ret.append(" ");
                continue;
            }
            if (inSpaceSequence) {
                inSpaceSequence = false;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String getDefMd5(List<String> lines) {
        MessageDigest md5;
        ArrayList<String> linesCopy = new ArrayList<String>(lines);
        Iterator it = linesCopy.iterator();
        while (it.hasNext()) {
            String line = ((String)it.next()).trim();
            if (line.startsWith("#") || line.equals("")) continue;
            if (!line.startsWith("version")) break;
            it.remove();
            break;
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : linesCopy) {
            Matcher m = intPattern.matcher(line = line.trim());
            if (m.matches()) {
                line = line.replaceFirst("\\[,", "[" + intFormattedMin + ",");
                line = line.replaceFirst(",\\]", "," + intFormattedMax + "]");
            }
            if ((m = doublePattern.matcher(line)).matches()) {
                line = line.replaceFirst("\\[,", "[" + doubleFormattedMin + ",");
                line = line.replaceFirst(",\\]", "," + doubleFormattedMax + "]");
            }
            if (line.contains("#")) {
                line = line.substring(0, line.indexOf("#"));
                line = line.trim();
            }
            if (line.length() <= 0) continue;
            line = ConfigUtils.stripSpaces(line);
            m = spaceBeforeCommaPatter.matcher(line);
            line = m.replaceAll(",");
            sb.append(line).append("\n");
        }
        md5.update(Utf8.toBytes((String)sb.toString()));
        return HexDump.toHexString((byte[])md5.digest()).toLowerCase();
    }

    public static String getDefVersion(Reader in) {
        return ConfigUtils.getDefKeyword(in, "version");
    }

    public static String getDefNamespace(Reader in) {
        List<String> defLines = ConfigUtils.getDefLines(in);
        String defPackage = ConfigUtils.getDefKeyword(defLines, "package");
        if (!defPackage.isEmpty()) {
            return defPackage;
        }
        return ConfigUtils.getDefKeyword(defLines, "namespace");
    }

    public static String getDefKeyword(Reader in, String keyword) {
        return ConfigUtils.getDefKeyword(ConfigUtils.getDefLines(in), keyword);
    }

    private static String getDefKeyword(List<String> defLines, String keyword) {
        for (String line : defLines) {
            if (!line.startsWith(keyword)) continue;
            String[] v = line.split("=");
            return v[1].trim();
        }
        return "";
    }

    private static List<String> getDefLines(Reader in) {
        if (null == in) {
            throw new IllegalArgumentException("Null reader.");
        }
        ArrayList<String> defLines = new ArrayList<String>();
        try {
            String line;
            LineNumberReader reader = in instanceof LineNumberReader ? (LineNumberReader)in : new LineNumberReader(in);
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
                defLines.add(line);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException", e);
        }
        return defLines;
    }

    public static Tuple2<String, String> getNameAndVersionFromString(String nameCommaVersion) {
        String[] av = nameCommaVersion.split(",");
        return new Tuple2((Object)av[0], (Object)(av.length >= 2 ? av[1] : ""));
    }

    public static Tuple2<String, String> getNameAndNamespaceFromString(String nameDotNamespace) {
        if (!nameDotNamespace.contains(".")) {
            return new Tuple2((Object)nameDotNamespace, (Object)"");
        }
        String name = nameDotNamespace.substring(nameDotNamespace.lastIndexOf(".") + 1);
        String namespace = nameDotNamespace.substring(0, nameDotNamespace.lastIndexOf("."));
        return new Tuple2((Object)name, (Object)namespace);
    }

    public static ConfigDefinitionKey getConfigDefinitionKeyFromString(String input) {
        String namespace;
        String name;
        if (!input.contains(".")) {
            name = input;
            namespace = "";
        } else if (input.lastIndexOf(".") == input.indexOf(".")) {
            Tuple2<String, String> tuple = ConfigUtils.getNameAndNamespaceFromString(input);
            boolean containsVersion = false;
            for (int i = 0; i < ((String)tuple.first).length(); ++i) {
                if (!Character.isDigit(((String)tuple.first).charAt(i))) continue;
                containsVersion = true;
                break;
            }
            if (containsVersion) {
                name = (String)tuple.second;
                namespace = "";
            } else {
                name = (String)tuple.first;
                namespace = (String)tuple.second;
            }
        } else {
            Tuple2<String, String> tuple = ConfigUtils.getNameAndNamespaceFromString(input);
            String tempName = (String)tuple.second;
            tuple = ConfigUtils.getNameAndNamespaceFromString(tempName);
            name = (String)tuple.first;
            namespace = (String)tuple.second;
        }
        return new ConfigDefinitionKey(name, namespace);
    }

    public static ConfigDefinitionKey createConfigDefinitionKeyFromZKString(String nodeName) {
        String namespace;
        String name;
        if (nodeName.contains(".")) {
            Tuple2<String, String> tuple = ConfigUtils.getNameAndVersionFromString(nodeName);
            String tempName = (String)tuple.first;
            tuple = ConfigUtils.getNameAndNamespaceFromString(tempName);
            name = (String)tuple.first;
            namespace = (String)tuple.second;
        } else {
            Tuple2<String, String> tuple = ConfigUtils.getNameAndVersionFromString(nodeName);
            name = (String)tuple.first;
            namespace = "";
        }
        return new ConfigDefinitionKey(name, namespace);
    }

    public static ConfigDefinitionKey createConfigDefinitionKeyFromDefFile(File file) throws IOException {
        String[] fileName = file.getName().split("\\.");
        assert (fileName.length >= 2);
        String name = fileName[fileName.length - 2];
        byte[] content = IOUtils.readFileBytes((File)file);
        return ConfigUtils.createConfigDefinitionKeyFromDefContent(name, content);
    }

    public static ConfigDefinitionKey createConfigDefinitionKeyFromDefContent(String name, byte[] content) {
        String namespace = ConfigUtils.getDefNamespace(new StringReader(Utf8.toString((byte[])content)));
        if (namespace.isEmpty()) {
            namespace = "config";
        }
        return new ConfigDefinitionKey(name, namespace);
    }

    public static String escapeConfigFormatValue(String input) {
        if (input == null) {
            return "null";
        }
        StringBuilder outputBuf = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\\') {
                outputBuf.append("\\\\");
                continue;
            }
            if (input.charAt(i) == '\"') {
                outputBuf.append("\\\"");
                continue;
            }
            if (input.charAt(i) == '\n') {
                outputBuf.append("\\n");
                continue;
            }
            if (input.charAt(i) == '\u0000') {
                System.err.println("WARNING: null byte in config value");
                outputBuf.append("\\x00");
                continue;
            }
            outputBuf.append(input.charAt(i));
        }
        return outputBuf.toString();
    }

    public static String getDefMd5FromRequest(String defMd5, List<String> defContent) {
        if ((defMd5 == null || defMd5.isEmpty()) && defContent != null) {
            return ConfigUtils.getDefMd5(defContent);
        }
        return defMd5;
    }

    public static String getCanonicalHostName() {
        return HostName.getLocalhost();
    }

    public static String getEnvValue(String defaultValue, String ... envVars) {
        String value = null;
        for (String envVar : envVars) {
            if (value != null && !value.isEmpty()) continue;
            value = envVar;
        }
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public static boolean isGenerationNewer(long newGen, long oldGen) {
        return oldGen < newGen || newGen == 0L;
    }
}

