/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.collections.Pair;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.StringNode;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CfgConfigPayloadBuilder {
    private static final Logger log = Logger.getLogger(CfgConfigPayloadBuilder.class.getName());

    public ConfigPayload deserialize(List<String> lines) {
        return ConfigPayload.fromBuilder(this.deserializeToBuilder(lines));
    }

    public ConfigPayloadBuilder deserializeToBuilder(List<String> lines) {
        int lineNum = 1;
        ConfigPayloadBuilder payloadBuilder = new ConfigPayloadBuilder();
        for (String line : lines) {
            if (log.isLoggable((Level)LogLevel.SPAM)) {
                log.log((Level)LogLevel.SPAM, "line " + lineNum + ": '" + line + "'");
            }
            this.parseLine(line, lineNum, payloadBuilder);
            ++lineNum;
        }
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "payload=" + payloadBuilder.toString());
        }
        return payloadBuilder;
    }

    private void parseLine(String line, int lineNum, ConfigPayloadBuilder payloadBuilder) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("#")) {
            return;
        }
        Pair<String, String> fieldAndValue = this.parseFieldAndValue(trimmedLine);
        String field = (String)fieldAndValue.getFirst();
        String value = (String)fieldAndValue.getSecond();
        if (field == null || value == null) {
            log.log((Level)LogLevel.DEBUG, "Got field without value in line " + lineNum + ": " + line + ", skipping");
            return;
        }
        field = field.trim();
        value = value.trim();
        this.validateField(field, trimmedLine, lineNum);
        this.validateValue(value, trimmedLine, lineNum);
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "field=" + field + ",value=" + value);
        }
        List<String> fields = this.parseFieldList(field);
        ConfigPayloadBuilder currentBuilder = payloadBuilder;
        for (int fieldNum = 0; fieldNum < fields.size(); ++fieldNum) {
            ConfigPayloadBuilder.MapBuilder map;
            ConfigPayloadBuilder.Array array;
            boolean isLeaf;
            String fieldName = fields.get(fieldNum);
            boolean bl = isLeaf = fieldNum == fields.size() - 1;
            if (isLeaf) {
                if (this.isArray(fieldName)) {
                    array = currentBuilder.getArray(this.getArrayName(fieldName));
                    array.set(this.getArrayIndex(fieldName), this.removeQuotes(value));
                    continue;
                }
                if (this.isMap(fieldName)) {
                    map = currentBuilder.getMap(this.getMapName(fieldName));
                    map.put(this.getMapKey(fieldName), this.removeQuotes(value));
                    continue;
                }
                currentBuilder.setField(fieldName, this.removeQuotes(value));
                continue;
            }
            if (this.isArray(fieldName)) {
                array = currentBuilder.getArray(this.getArrayName(fieldName));
                currentBuilder = array.get(this.getArrayIndex(fieldName));
                continue;
            }
            if (this.isMap(fieldName)) {
                map = currentBuilder.getMap(this.getMapName(fieldName));
                currentBuilder = map.get(this.getMapKey(fieldName));
                continue;
            }
            currentBuilder = currentBuilder.getObject(fieldName);
        }
    }

    Pair<String, String> parseFieldAndValue(String line) {
        String field = null;
        StringBuffer sb = new StringBuffer();
        boolean inMapKey = false;
        for (char c : line.toCharArray()) {
            if (c == '{') {
                inMapKey = true;
            }
            if (c == '}') {
                inMapKey = false;
            }
            if (c == ' ' && !inMapKey && field == null) {
                field = sb.toString();
                sb = new StringBuffer();
                continue;
            }
            sb.append(c);
        }
        String value = sb.toString();
        return new Pair(field, (Object)value);
    }

    List<String> parseFieldList(String field) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inMapKey = false;
        for (char c : field.toCharArray()) {
            if (c == '{') {
                inMapKey = true;
            }
            if (c == '}') {
                inMapKey = false;
            }
            if (c == '.' && !inMapKey) {
                ret.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(c);
        }
        ret.add(sb.toString());
        return ret;
    }

    private void validateField(String field, String line, int lineNum) {
        if (field.length() == 0) {
            throw new ConfigurationRuntimeException("Error on line " + lineNum + ": " + line + "\n'" + field + "' is not a valid field name");
        }
    }

    private void validateValue(String value, String line, int lineNum) {
        if (value.length() == 0) {
            throw new ConfigurationRuntimeException("Error on line " + lineNum + ": " + line + "\n'" + value + "' is not a valid value");
        }
    }

    private boolean isArray(String name) {
        return name.endsWith("]") && !name.startsWith("[");
    }

    private boolean isMap(String name) {
        return name.contains("{");
    }

    private String removeQuotes(String s) {
        return StringNode.unescapeQuotedString((String)s);
    }

    private String getMapName(String name) {
        if (name.contains("{")) {
            return name.substring(0, name.indexOf("{"));
        }
        return name;
    }

    private String getMapKey(String name) {
        if (name.contains("{")) {
            return this.removeQuotes(name.substring(name.indexOf("{") + 1, name.indexOf("}")));
        }
        return "";
    }

    private String getArrayName(String name) {
        if (name.contains("[")) {
            return name.substring(0, name.indexOf("["));
        }
        return name;
    }

    private int getArrayIndex(String name) {
        if (name.contains("[")) {
            return Integer.parseInt(name.substring(name.indexOf("[") + 1, name.indexOf("]")));
        }
        return 0;
    }
}

