/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.vespa.config.Connection;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.logging.Logger;

public class JRTConnection
implements Connection {
    public static final Logger logger = Logger.getLogger(JRTConnection.class.getPackage().getName());
    private final String address;
    private final Supervisor supervisor;
    private Target target;
    private long lastConnectionAttempt = 0L;
    private long lastSuccess = 0L;
    private long lastFailure = 0L;
    private static final long delayBetweenConnectionMessage = 30000L;
    private static SimpleDateFormat yyyyMMddz = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    public JRTConnection(String address, Supervisor supervisor) {
        this.address = address;
        this.supervisor = supervisor;
    }

    @Override
    public void invokeAsync(Request request, double jrtTimeout, RequestWaiter requestWaiter) {
        this.getTarget().invokeAsync(request, jrtTimeout, requestWaiter);
    }

    @Override
    public void invokeSync(Request request, double jrtTimeout) {
        this.getTarget().invokeSync(request, jrtTimeout);
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public synchronized Target getTarget() {
        if (this.target == null || !this.target.isValid()) {
            if (System.currentTimeMillis() - this.lastConnectionAttempt > 30000L) {
                logger.fine("Connecting to " + this.address);
            }
            this.lastConnectionAttempt = System.currentTimeMillis();
            this.target = this.supervisor.connect(new Spec(this.address));
        }
        return this.target;
    }

    @Override
    public synchronized void setError(int errorCode) {
        this.lastFailure = System.currentTimeMillis();
    }

    @Override
    public synchronized void setSuccess() {
        this.lastSuccess = System.currentTimeMillis();
    }

    public void setLastSuccess() {
        this.lastSuccess = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Address: ");
        sb.append(this.address);
        if (this.lastSuccess > 0L) {
            sb.append("\n");
            sb.append("Last success: ");
            sb.append(yyyyMMddz.format(this.lastSuccess));
        }
        if (this.lastFailure > 0L) {
            sb.append("\n");
            sb.append("Last failure: ");
            sb.append(yyyyMMddz.format(this.lastFailure));
        }
        return sb.toString();
    }

    static {
        yyyyMMddz.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

