/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.Slime;
import com.yahoo.text.Utf8;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ConfigVerification {
    private static final int port = 19071;
    private static final String prefix = "http://";

    public static void main(String[] args) throws IOException {
        ArrayList<String> configservers = new ArrayList<String>();
        String tenant = "default";
        String appName = "default";
        String environment = "prod";
        String region = "default";
        String instance = "default";
        for (String arg : args) {
            configservers.add(prefix + arg + ":19071/config/v2/tenant/" + tenant + "/application/" + appName + "/environment/" + environment + "/region/" + region + "/instance/" + instance + "/?recursive=true");
        }
        System.exit(ConfigVerification.compareConfigs(ConfigVerification.listConfigs(configservers)));
    }

    private static Map<String, Stack<String>> listConfigs(List<String> urls) throws IOException {
        Map<String, String> outputs = ConfigVerification.performRequests(urls);
        LinkedHashMap<String, Stack<String>> recurseMappings = new LinkedHashMap<String, Stack<String>>();
        for (Map.Entry<String, String> entry : outputs.entrySet()) {
            Slime slime = new JsonDecoder().decode(new Slime(), Utf8.toBytes((String)entry.getValue()));
            final ArrayList list = new ArrayList();
            slime.get().field("configs").traverse(new ArrayTraverser(){

                public void entry(int idx, Inspector inspector) {
                    list.add(inspector.asString());
                }
            });
            Stack stack = new Stack();
            Collections.sort(list);
            stack.addAll(list);
            recurseMappings.put(entry.getKey(), stack);
        }
        return recurseMappings;
    }

    private static Map<String, String> performRequests(List<String> urls) throws IOException {
        LinkedHashMap<String, String> outputs = new LinkedHashMap<String, String>();
        for (String url : urls) {
            outputs.put(url, ConfigVerification.performRequest(url));
        }
        return outputs;
    }

    private static int compareConfigs(Map<String, Stack<String>> mappings) throws IOException {
        for (int n = 0; n < mappings.values().iterator().next().size(); ++n) {
            ArrayList<String> recurseUrls = new ArrayList<String>();
            for (Map.Entry<String, Stack<String>> entry : mappings.entrySet()) {
                recurseUrls.add(entry.getValue().pop());
            }
            int ret = ConfigVerification.compareOutputs(ConfigVerification.performRequests(recurseUrls));
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    private static int compareOutputs(Map<String, String> outputs) {
        Map.Entry<String, String> firstEntry = outputs.entrySet().iterator().next();
        for (Map.Entry<String, String> entry : outputs.entrySet()) {
            if (entry.getValue().equals(firstEntry.getValue())) continue;
            System.out.println("output from '" + entry.getKey() + "' did not equal output from '" + firstEntry.getKey() + "'");
            return -1;
        }
        return 0;
    }

    private static String performRequest(String url) throws IOException {
        int ch;
        URLConnection connection = new URL(url).openConnection();
        InputStream response = connection.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((ch = response.read()) > -1) {
            baos.write(ch);
        }
        return Utf8.toString((byte[])baos.toByteArray());
    }
}

