/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigHandle;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.SubscriberClosedException;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.config.subscription.impl.JrtConfigRequesters;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.yolean.Exceptions;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@Deprecated(forRemoval=true, since="7")
public class ConfigSubscriber
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(ConfigSubscriber.class.getName());
    private State state = State.OPEN;
    protected final List<ConfigHandle<? extends ConfigInstance>> subscriptionHandles = new CopyOnWriteArrayList<ConfigHandle<? extends ConfigInstance>>();
    private final ConfigSource source;
    private final Object monitor = new Object();
    private final Throwable stackTraceAtConstruction;
    private final JrtConfigRequesters requesters = new JrtConfigRequesters();
    private long generation = -1L;
    private boolean applyOnRestart = false;

    public ConfigSubscriber() {
        this(JRTConfigRequester.defaultSourceSet);
    }

    public ConfigSubscriber(ConfigSource source) {
        this.source = source;
        this.stackTraceAtConstruction = new Throwable();
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId) {
        return this.subscribe(configClass, configId, this.source, new TimingValues());
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId, long timeoutMillis) {
        return this.subscribe(configClass, configId, this.source, new TimingValues().setSubscribeTimeout(timeoutMillis));
    }

    <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId, ConfigSource source, TimingValues timingValues) {
        this.checkStateBeforeSubscribe();
        ConfigKey<T> configKey = new ConfigKey<T>(configClass, configId);
        ConfigSubscription<T> sub = ConfigSubscription.get(configKey, this.requesters, source, timingValues);
        ConfigHandle<T> handle = new ConfigHandle<T>(sub);
        this.subscribeAndHandleErrors(sub, configKey, handle, timingValues);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStateBeforeSubscribe() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.state != State.OPEN) {
                throw new IllegalStateException("Adding subscription after calling nextConfig() is not allowed");
            }
        }
    }

    protected void subscribeAndHandleErrors(ConfigSubscription<?> sub, ConfigKey<?> configKey, ConfigHandle<?> handle, TimingValues timingValues) {
        this.subscriptionHandles.add(handle);
        boolean subOk = sub.subscribe(timingValues.getSubscribeTimeout());
        this.throwIfExceptionSet(sub);
        if (!subOk) {
            throw new ConfigurationRuntimeException("Subscribe for '" + configKey + "' timed out (timeout was " + timingValues.getSubscribeTimeout() + " ms): " + sub);
        }
    }

    public boolean nextConfig(boolean isInitializing) {
        return this.nextConfig(1000L, isInitializing);
    }

    @Deprecated
    public boolean nextConfig() {
        return this.nextConfig(false);
    }

    public boolean nextConfig(long timeoutMillis, boolean isInitializing) {
        return this.acquireSnapshot(timeoutMillis, true, isInitializing);
    }

    @Deprecated
    public boolean nextConfig(long timeoutMillis) {
        return this.nextConfig(timeoutMillis, false);
    }

    public boolean nextGeneration(boolean isInitializing) {
        return this.nextGeneration(1000L, isInitializing);
    }

    @Deprecated
    public boolean nextGeneration() {
        return this.nextGeneration(false);
    }

    public boolean nextGeneration(long timeoutMillis, boolean isInitializing) {
        return this.acquireSnapshot(timeoutMillis, false, isInitializing);
    }

    @Deprecated
    public boolean nextGeneration(long timeoutMillis) {
        return this.nextGeneration(timeoutMillis, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireSnapshot(long timeoutInMillis, boolean requireChange, boolean isInitializing) {
        boolean reconfigDue;
        boolean applyOnRestartOnly;
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                throw new SubscriberClosedException();
            }
            this.state = State.FROZEN;
            applyOnRestartOnly = this.applyOnRestart;
        }
        boolean expiredOnEntry = timeoutInMillis <= 0L;
        long started = this.now(expiredOnEntry);
        long timeLeftMillis = timeoutInMillis;
        boolean anyConfigChanged = false;
        Long currentGen = null;
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.setChanged(false);
        }
        do {
            boolean allGenerationsChanged = true;
            boolean allGenerationsTheSame = true;
            for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
                ConfigSubscription<? extends ConfigInstance> subscription = h.subscription();
                log.log(Level.FINEST, () -> "Calling nextConfig for " + subscription.getKey());
                if (!subscription.nextConfig(timeLeftMillis)) {
                    log.log(Level.FINEST, () -> "No new config for " + subscription.getKey());
                    return false;
                }
                log.log(Level.FINEST, () -> "Got new generation or config for " + subscription.getKey());
                this.throwIfExceptionSet(subscription);
                ConfigSubscription.ConfigState<? extends ConfigInstance> config = subscription.getConfigState();
                if (currentGen == null) {
                    currentGen = config.getGeneration();
                }
                allGenerationsTheSame &= currentGen.equals(config.getGeneration());
                allGenerationsChanged &= config.isGenerationChanged();
                anyConfigChanged |= config.isConfigChanged();
                applyOnRestartOnly |= config.applyOnRestart();
                timeLeftMillis = timeoutInMillis + started - this.now(expiredOnEntry);
            }
            boolean bl = reconfigDue = !(!isInitializing && applyOnRestartOnly || !anyConfigChanged && requireChange || !allGenerationsChanged || !allGenerationsTheSame);
            if (applyOnRestartOnly && !isInitializing) {
                Object object2 = this.monitor;
                synchronized (object2) {
                    this.applyOnRestart = applyOnRestartOnly;
                }
            }
            if (reconfigDue || timeLeftMillis <= 0L) continue;
            this.sleep(timeLeftMillis);
        } while (!reconfigDue && timeLeftMillis > 0L);
        if (reconfigDue) {
            log.log(Level.FINE, () -> "Reconfig will happen for generation " + this.generation);
            this.markSubsChangedSeen(currentGen);
            Object object3 = this.monitor;
            synchronized (object3) {
                this.generation = currentGen;
            }
        }
        return reconfigDue;
    }

    private long now(boolean alreadyExpired) {
        return alreadyExpired ? 0L : System.currentTimeMillis();
    }

    private void sleep(long timeLeftMillis) {
        try {
            Thread.sleep(Math.min(10L, timeLeftMillis));
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
    }

    protected void throwIfExceptionSet(ConfigSubscription<? extends ConfigInstance> sub) {
        RuntimeException subThrowable = sub.getException();
        if (subThrowable != null) {
            sub.setException(null);
            throw subThrowable;
        }
    }

    private void markSubsChangedSeen(Long requiredGen) {
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            ConfigSubscription<? extends ConfigInstance> sub = h.subscription();
            h.setChanged(sub.isConfigChangedAndReset(requiredGen));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Iterator<ConfigHandle<? extends ConfigInstance>> iterator = this.monitor;
        synchronized (iterator) {
            if (this.state == State.CLOSED) {
                return;
            }
            this.state = State.CLOSED;
        }
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.subscription().close();
        }
        this.requesters.close();
        log.log(Level.FINE, () -> "Config subscriber has been closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<ConfigHandle<? extends ConfigInstance>> iterator = this.monitor;
        synchronized (iterator) {
            sb.append("Subscriber state:").append(this.state.toString());
        }
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            sb.append("\n").append(h.toString());
        }
        return sb.toString();
    }

    public Thread startConfigThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        t.setName("Vespa config thread");
        t.start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State state() {
        Object object = this.monitor;
        synchronized (object) {
            return this.state;
        }
    }

    public void reload(long generation) {
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.subscription().reload(generation);
        }
    }

    public ConfigSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.monitor;
        synchronized (object) {
            return this.state == State.CLOSED;
        }
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(SingleSubscriber<T> singleSubscriber, Class<T> configClass, String configId) {
        if (!this.subscriptionHandles.isEmpty()) {
            throw new IllegalStateException("Can not start single-subscription because subscriptions were previously opened on this");
        }
        ConfigHandle handle = this.subscribe(configClass, configId);
        if (!this.nextConfig()) {
            throw new ConfigurationRuntimeException("Initial config of " + configClass.getName() + " failed");
        }
        singleSubscriber.configure(handle.getConfig());
        this.startConfigThread(() -> {
            while (!this.isClosed()) {
                boolean hasNewConfig = false;
                try {
                    hasNewConfig = this.nextConfig();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Exception on receiving config. Ignoring this change.", e);
                }
                try {
                    if (!hasNewConfig) continue;
                    singleSubscriber.configure(handle.getConfig());
                }
                catch (Exception e) {
                    log.warning("Exception on applying config " + configClass.getName() + " for config id " + configId + ": Ignoring this change: " + Exceptions.toMessageString((Throwable)e));
                }
            }
        });
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGeneration() {
        Object object = this.monitor;
        synchronized (object) {
            return this.generation;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                log.log(Level.WARNING, this.stackTraceAtConstruction, () -> String.format("%s: Closing subscription from finalizer() - close() has not been called (keys=%s)", super.toString(), this.subscriptionHandles.stream().map(handle -> handle.subscription().getKey().toString()).collect(Collectors.toList())));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected static enum State {
        OPEN,
        FROZEN,
        CLOSED;

    }

    public static interface SingleSubscriber<T extends ConfigInstance> {
        public void configure(T var1);
    }
}

