/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PayloadChecksum {
    private static final Pattern hexChecksumPattern = Pattern.compile("[0-9a-fA-F]+");
    private final String checksum;
    private final Type type;

    public PayloadChecksum(String checksum, Type type) {
        this.checksum = checksum;
        this.type = type;
    }

    public static PayloadChecksum empty(Type type) {
        return new PayloadChecksum("", type);
    }

    public static PayloadChecksum fromPayload(Payload payload, Type type) {
        switch (type) {
            case MD5: {
                return PayloadChecksum.fromMd5Data(payload.getData());
            }
            case XXHASH64: {
                return PayloadChecksum.fromXxhash64Data(payload.getData());
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private static PayloadChecksum fromMd5Data(AbstractUtf8Array data) {
        return new PayloadChecksum(ConfigUtils.getMd5(data), Type.MD5);
    }

    private static PayloadChecksum fromXxhash64Data(AbstractUtf8Array data) {
        return new PayloadChecksum(ConfigUtils.getXxhash64(data), Type.XXHASH64);
    }

    public boolean isEmpty() {
        switch (this.type) {
            case MD5: {
                return this.equals(PayloadChecksum.empty(Type.MD5));
            }
            case XXHASH64: {
                return this.equals(PayloadChecksum.empty(Type.XXHASH64));
            }
        }
        throw new IllegalArgumentException("Unknown type " + this.type);
    }

    public String asString() {
        return this.checksum;
    }

    public Type type() {
        return this.type;
    }

    public boolean valid() {
        if (this.checksum.equals("")) {
            return true;
        }
        Matcher m = hexChecksumPattern.matcher(this.checksum);
        return m.matches();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checksum, this.type});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayloadChecksum that = (PayloadChecksum)o;
        return Objects.equals(this.checksum, that.checksum) && this.type == that.type;
    }

    public String toString() {
        return this.type.name() + ":" + this.checksum;
    }

    public static enum Type {
        MD5,
        XXHASH64;

    }
}

