/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PayloadChecksums {
    private final Map<PayloadChecksum.Type, PayloadChecksum> checksums = new LinkedHashMap<PayloadChecksum.Type, PayloadChecksum>();

    private PayloadChecksums() {
        this(false);
    }

    private PayloadChecksums(boolean addEmptyChecksumForAllTypes) {
        if (addEmptyChecksumForAllTypes) {
            Arrays.stream(PayloadChecksum.Type.values()).forEach(type -> this.checksums.put((PayloadChecksum.Type)((Object)type), PayloadChecksum.empty(type)));
        }
    }

    public static PayloadChecksums empty() {
        return new PayloadChecksums(true);
    }

    public static PayloadChecksums from(PayloadChecksum ... checksums) {
        PayloadChecksums payloadChecksums = new PayloadChecksums();
        Arrays.stream(checksums).filter(Objects::nonNull).forEach(payloadChecksums::add);
        return payloadChecksums;
    }

    public static PayloadChecksums from(String configMd5, String configXxhash64) {
        return new PayloadChecksums().add(new PayloadChecksum(configMd5, PayloadChecksum.Type.MD5)).add(new PayloadChecksum(configXxhash64, PayloadChecksum.Type.XXHASH64));
    }

    public static PayloadChecksums fromPayload(Payload payload) {
        return new PayloadChecksums().add(new PayloadChecksum(ConfigUtils.getMd5(payload.getData()), PayloadChecksum.Type.MD5)).add(new PayloadChecksum(ConfigUtils.getXxhash64(payload.getData()), PayloadChecksum.Type.XXHASH64));
    }

    private PayloadChecksums add(PayloadChecksum checksum) {
        this.checksums.put(checksum.type(), checksum);
        return this;
    }

    public void removeChecksumsOfType(PayloadChecksum.Type type) {
        this.checksums.remove((Object)type);
    }

    public PayloadChecksum getForType(PayloadChecksum.Type type) {
        return this.checksums.get((Object)type);
    }

    public boolean valid() {
        return this.checksums.values().stream().allMatch(PayloadChecksum::valid);
    }

    public boolean isEmpty() {
        return this.equals(PayloadChecksums.empty());
    }

    public String toString() {
        return this.checksums.values().stream().map(checksum -> checksum.type().name() + ":" + checksum.asString()).collect(Collectors.joining(","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayloadChecksums that = (PayloadChecksums)o;
        return Objects.equals(this.checksums, that.checksums);
    }

    public int hashCode() {
        return Objects.hash(this.checksums);
    }
}

