/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequestV3;
import com.yahoo.vespa.config.protocol.Payload;

public class MockConnection
implements ConnectionPool,
Connection {
    private Request lastRequest;
    private final ResponseHandler responseHandler;
    private int numberOfRequests = 0;
    private final int numSpecs;

    public MockConnection() {
        this(new OKResponseHandler());
    }

    public MockConnection(ResponseHandler responseHandler) {
        this(responseHandler, 1);
    }

    public MockConnection(ResponseHandler responseHandler, int numSpecs) {
        this.responseHandler = responseHandler;
        this.numSpecs = numSpecs;
    }

    @Override
    public void invokeAsync(Request request, double jrtTimeout, RequestWaiter requestWaiter) {
        ++this.numberOfRequests;
        this.lastRequest = request;
        this.responseHandler.handle(request, requestWaiter);
    }

    @Override
    public void invokeSync(Request request, double jrtTimeout) {
        ++this.numberOfRequests;
        this.lastRequest = request;
    }

    @Override
    public String getAddress() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public Connection getCurrent() {
        return this;
    }

    @Override
    public Connection switchConnection(Connection connection) {
        return this;
    }

    @Override
    public int getSize() {
        return this.numSpecs;
    }

    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public Request getRequest() {
        return this.lastRequest;
    }

    public static abstract class AbstractResponseHandler
    implements ResponseHandler {
        @Override
        public void handle(Request request, RequestWaiter requestWaiter) {
            this.createResponse(request);
            requestWaiter.handleRequestDone(request);
        }

        protected abstract void createResponse(Request var1);
    }

    public static interface ResponseHandler {
        public void handle(Request var1, RequestWaiter var2);
    }

    static class OKResponseHandler
    extends AbstractResponseHandler {
        long generation = 1L;

        OKResponseHandler() {
        }

        @Override
        protected void createResponse(Request request) {
            JRTServerConfigRequestV3 jrtReq = JRTServerConfigRequestV3.createFromRequest(request);
            Payload payload = Payload.from(ConfigPayload.empty());
            jrtReq.addOkResponse(payload, this.generation, false, PayloadChecksums.fromPayload(payload));
            ++this.generation;
        }
    }
}

