/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSet;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.DirSource;
import com.yahoo.config.subscription.FileSource;
import com.yahoo.config.subscription.JarSource;
import com.yahoo.config.subscription.RawSource;
import com.yahoo.config.subscription.impl.ConfigSetSubscription;
import com.yahoo.config.subscription.impl.FileConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.config.subscription.impl.JarConfigSubscription;
import com.yahoo.config.subscription.impl.JrtConfigRequesters;
import com.yahoo.config.subscription.impl.RawConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.DefContent;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConfigSubscription<T extends ConfigInstance> {
    protected static final Logger log = Logger.getLogger(ConfigSubscription.class.getName());
    private final AtomicReference<ConfigState<T>> config = new AtomicReference();
    protected final ConfigKey<T> key;
    protected final Class<T> configClass;
    private volatile RuntimeException exception = null;
    private State state = State.OPEN;
    private final AtomicReference<Long> reloadedGeneration = new AtomicReference();

    ConfigSubscription(ConfigKey<T> key) {
        this.key = key;
        this.configClass = key.getConfigClass();
        this.config.set(new ConfigState());
        this.getConfigState().getChecksums().removeChecksumsOfType(PayloadChecksum.Type.MD5);
    }

    public static <T extends ConfigInstance> ConfigSubscription<T> get(ConfigKey<T> key, JrtConfigRequesters requesters, ConfigSource source, TimingValues timingValues) {
        String configId = key.getConfigId();
        if (source instanceof RawSource || configId.startsWith("raw:")) {
            return ConfigSubscription.getRawSub(key, source);
        }
        if (source instanceof FileSource || configId.startsWith("file:")) {
            return ConfigSubscription.getFileSub(key, source);
        }
        if (source instanceof DirSource || configId.startsWith("dir:")) {
            return ConfigSubscription.getDirFileSub(key, source);
        }
        if (source instanceof JarSource || configId.startsWith("jar:")) {
            return ConfigSubscription.getJarSub(key, source);
        }
        if (source instanceof ConfigSet) {
            return new ConfigSetSubscription<T>(key, source);
        }
        if (source instanceof ConfigSourceSet) {
            JRTConfigRequester requester = requesters.getRequester((ConfigSourceSet)source, timingValues);
            return new JRTConfigSubscription<T>(key, requester, timingValues);
        }
        throw new IllegalArgumentException("Unknown source type: " + source);
    }

    private static <T extends ConfigInstance> JarConfigSubscription<T> getJarSub(ConfigKey<T> key, ConfigSource source) {
        String jarName;
        String path = "config/";
        if (source instanceof JarSource) {
            JarSource js = (JarSource)source;
            jarName = js.getJarFile().getName();
            if (js.getPath() != null) {
                path = js.getPath();
            }
        } else {
            jarName = key.getConfigId().replace("jar:", "").replaceFirst("\\!/.*", "");
            if (key.getConfigId().contains("!/")) {
                path = key.getConfigId().replaceFirst(".*\\!/", "");
            }
        }
        return new JarConfigSubscription<T>(key, jarName, path);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getFileSub(ConfigKey<T> key, ConfigSource source) {
        File file = source instanceof FileSource ? ((FileSource)source).getFile() : new File(key.getConfigId().replace("file:", ""));
        return new FileConfigSubscription<T>(key, file);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getRawSub(ConfigKey<T> key, ConfigSource source) {
        String payload = source instanceof RawSource ? ((RawSource)source).payload : key.getConfigId().replace("raw:", "");
        return new RawConfigSubscription<T>(key, payload);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getDirFileSub(ConfigKey<T> key, ConfigSource source) {
        String name;
        File file;
        Object dir = key.getConfigId().replace("dir:", "");
        if (source instanceof DirSource) {
            dir = ((DirSource)source).getDir().toString();
        }
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        if (!(file = new File((String)dir + (name = ConfigSubscription.getConfigFilename(key)))).exists()) {
            throw new IllegalArgumentException("Could not find a config file for '" + key.getName() + "' in '" + (String)dir + "'");
        }
        return new FileConfigSubscription<T>(key, file);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigSubscription) {
            ConfigSubscription other = (ConfigSubscription)o;
            return this.key.equals(other.key);
        }
        return false;
    }

    public boolean isConfigChangedAndReset(Long requiredGen) {
        ConfigState<T> prev = this.config.get();
        while (prev.getGeneration().equals(requiredGen) && !this.config.compareAndSet(prev, prev.createUnchanged())) {
            prev = this.config.get();
        }
        return !prev.getGeneration().equals(requiredGen) || prev.isConfigChanged();
    }

    void setConfig(Long generation, boolean applyOnRestart, T config, PayloadChecksums payloadChecksums) {
        this.config.set(new ConfigState<T>(true, generation, applyOnRestart, true, config, payloadChecksums));
    }

    void setConfigAndGeneration(Long generation, boolean applyOnRestart, T config, PayloadChecksums payloadChecksums) {
        ConfigState<T> prev = this.config.get();
        boolean configChanged = !Objects.equals(prev.getConfig(), config);
        String message = "Config has changed unexpectedly for " + this.key + ", generation " + generation;
        if (configChanged) {
            if (log.isLoggable(Level.FINE)) {
                message = message + ", config in state :" + prev.getConfig() + ", new config: " + config;
            }
            log.log(Level.WARNING, message);
        }
        this.config.set(new ConfigState<T>(true, generation, applyOnRestart, configChanged, config, payloadChecksums));
    }

    protected void setConfigIncGen(T config) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState<T>(true, prev.getGeneration() + 1L, prev.applyOnRestart(), true, config, prev.payloadChecksums));
    }

    protected void setConfigIfChanged(T config) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState<T>(true, prev.getGeneration(), prev.applyOnRestart(), !Objects.equals(prev.getConfig(), config), config, prev.payloadChecksums));
    }

    void setGeneration(Long generation) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState<T>(true, generation, prev.applyOnRestart(), prev.isConfigChanged(), prev.getConfig(), prev.payloadChecksums));
    }

    void setApplyOnRestart(boolean applyOnRestart) {
        ConfigState<T> prev = this.config.get();
        this.config.set(new ConfigState<T>(prev.isGenerationChanged(), prev.getGeneration(), applyOnRestart, prev.isConfigChanged(), prev.getConfig(), prev.payloadChecksums));
    }

    public ConfigState<T> getConfigState() {
        return this.config.get();
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.key.toString());
        ConfigState<T> c = this.config.get();
        s.append(", Current generation: ").append(c.getGeneration()).append(", Generation changed: ").append(c.isGenerationChanged()).append(", Config changed: ").append(c.isConfigChanged());
        if (this.exception != null) {
            s.append(", Exception: ").append(this.exception);
        }
        return s.toString();
    }

    public ConfigKey<T> getKey() {
        return this.key;
    }

    public abstract boolean nextConfig(long var1);

    public abstract boolean subscribe(long var1);

    public void setException(RuntimeException e) {
        this.exception = e;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    boolean hasException() {
        return this.exception != null;
    }

    public void close() {
        this.state = State.CLOSED;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    static <T extends ConfigInstance> String getConfigFilename(ConfigKey<T> key) {
        return key.getName() + ".cfg";
    }

    public void reload(long generation) {
        this.reloadedGeneration.set(generation);
    }

    protected boolean checkReloaded() {
        Long reloaded = this.reloadedGeneration.getAndSet(null);
        if (reloaded != null) {
            this.setGeneration(reloaded);
            return true;
        }
        return false;
    }

    public DefContent getDefContent() {
        return DefContent.fromClass(this.configClass);
    }

    static enum State {
        OPEN,
        CLOSED;

    }

    public static class ConfigState<T extends ConfigInstance> {
        private final boolean configChanged;
        private final boolean generationChanged;
        private final T config;
        private final Long generation;
        private final boolean applyOnRestart;
        private final PayloadChecksums payloadChecksums;

        private ConfigState(boolean generationChanged, Long generation, boolean applyOnRestart, boolean configChanged, T config, PayloadChecksums payloadChecksums) {
            this.generationChanged = generationChanged;
            this.generation = generation;
            this.applyOnRestart = applyOnRestart;
            this.configChanged = configChanged;
            this.config = config;
            this.payloadChecksums = payloadChecksums;
        }

        private ConfigState(Long generation, T config, PayloadChecksums payloadChecksums) {
            this(false, generation, false, false, config, payloadChecksums);
        }

        private ConfigState() {
            this(false, 0L, false, false, null, PayloadChecksums.empty());
        }

        private ConfigState<T> createUnchanged() {
            return new ConfigState<T>(this.generation, this.config, this.payloadChecksums);
        }

        public boolean isConfigChanged() {
            return this.configChanged;
        }

        public boolean isGenerationChanged() {
            return this.generationChanged;
        }

        public Long getGeneration() {
            return this.generation;
        }

        public boolean applyOnRestart() {
            return this.applyOnRestart;
        }

        public T getConfig() {
            return this.config;
        }

        public PayloadChecksums getChecksums() {
            return this.payloadChecksums;
        }
    }
}

