/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.vespa.config.Connection;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JRTConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(JRTConnection.class.getName());
    private final String address;
    private final Supervisor supervisor;
    private Target target;

    public JRTConnection(String address, Supervisor supervisor) {
        this.address = address;
        this.supervisor = supervisor;
    }

    @Override
    public void invokeAsync(Request request, double jrtTimeout, RequestWaiter requestWaiter) {
        this.getTarget().invokeAsync(request, jrtTimeout, requestWaiter);
    }

    @Override
    public void invokeSync(Request request, double jrtTimeout) {
        this.getTarget().invokeSync(request, jrtTimeout);
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public synchronized Target getTarget() {
        if (this.target == null || !this.target.isValid()) {
            logger.log(Level.INFO, "Connecting to " + this.address);
            this.target = this.supervisor.connect(new Spec(this.address));
        }
        return this.target;
    }

    public String toString() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JRTConnection that = (JRTConnection)o;
        return this.address.equals(that.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }
}

