/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequestV3;
import com.yahoo.vespa.config.protocol.Payload;

public class MockConnection
implements ConnectionPool,
Connection {
    private Request lastRequest;
    private final ResponseHandler responseHandler;
    private int numberOfRequests = 0;
    private final int numSpecs;

    public MockConnection() {
        this(new OKResponseHandler());
    }

    public MockConnection(ResponseHandler responseHandler) {
        this(responseHandler, 1);
    }

    public MockConnection(ResponseHandler responseHandler, int numSpecs) {
        this.responseHandler = responseHandler;
        this.numSpecs = numSpecs;
    }

    @Override
    public void invokeAsync(Request request, double jrtTimeout, RequestWaiter requestWaiter) {
        ++this.numberOfRequests;
        this.lastRequest = request;
        this.responseHandler.requestWaiter(requestWaiter).request(request);
        Thread t = new Thread(this.responseHandler);
        t.setDaemon(true);
        t.run();
    }

    @Override
    public void invokeSync(Request request, double jrtTimeout) {
        ++this.numberOfRequests;
        this.lastRequest = request;
    }

    @Override
    public String getAddress() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public Connection getCurrent() {
        return this;
    }

    @Override
    public Connection switchConnection(Connection connection) {
        return this;
    }

    @Override
    public int getSize() {
        return this.numSpecs;
    }

    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public Request getRequest() {
        return this.lastRequest;
    }

    public static abstract class AbstractResponseHandler
    implements ResponseHandler {
        private RequestWaiter requestWaiter;
        protected Request request;

        @Override
        public RequestWaiter requestWaiter() {
            return this.requestWaiter;
        }

        @Override
        public Request request() {
            return this.request;
        }

        @Override
        public ResponseHandler requestWaiter(RequestWaiter requestWaiter) {
            this.requestWaiter = requestWaiter;
            return this;
        }

        @Override
        public ResponseHandler request(Request request) {
            this.request = request;
            return this;
        }

        @Override
        public void run() {
            this.createResponse();
            this.requestWaiter.handleRequestDone(this.request);
        }

        protected abstract void createResponse();
    }

    public static interface ResponseHandler
    extends Runnable {
        public RequestWaiter requestWaiter();

        public Request request();

        public ResponseHandler requestWaiter(RequestWaiter var1);

        public ResponseHandler request(Request var1);
    }

    static class OKResponseHandler
    extends AbstractResponseHandler {
        long generation = 1L;

        OKResponseHandler() {
        }

        @Override
        protected void createResponse() {
            JRTServerConfigRequestV3 jrtReq = JRTServerConfigRequestV3.createFromRequest(this.request);
            Payload payload = Payload.from(ConfigPayload.empty());
            jrtReq.addOkResponse(payload, this.generation, false, PayloadChecksums.fromPayload(payload));
            ++this.generation;
        }
    }
}

