/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSet;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.reflect.Constructor;

public class ConfigSetSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private final ConfigSet set;
    private final ConfigKey<T> subKey;

    ConfigSetSubscription(ConfigKey<T> key, ConfigSource cset) {
        super(key);
        if (!(cset instanceof ConfigSet)) {
            throw new IllegalArgumentException("Source is not a ConfigSet: " + cset);
        }
        this.set = (ConfigSet)cset;
        this.subKey = new ConfigKey(this.configClass, key.getConfigId());
        if (!this.set.contains(this.subKey)) {
            throw new IllegalArgumentException("The given ConfigSet " + this.set + " does not contain a config for " + this.subKey);
        }
        this.setGeneration(0L);
    }

    @Override
    public boolean nextConfig(long timeout) {
        long end = System.currentTimeMillis() + timeout;
        do {
            T myInstance = this.getNewInstance();
            ConfigSubscription.ConfigState configState = this.getConfigState();
            if (this.checkReloaded()) {
                this.setConfigIfChanged(myInstance);
                return true;
            }
            if (!myInstance.equals(configState.getConfig())) {
                this.setConfigIncGen(myInstance);
                return true;
            }
            this.sleep();
        } while (System.currentTimeMillis() < end);
        return false;
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("nextConfig aborted", e);
        }
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }

    private T getNewInstance() {
        try {
            ConfigInstance.Builder builder = this.set.get(this.subKey);
            Constructor<?> constructor = builder.getClass().getDeclaringClass().getConstructor(builder.getClass());
            return (T)((ConfigInstance)constructor.newInstance(builder));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

