/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ErrorCode;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.NoCopyByteArrayOutputStream;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.RequestValidation;
import com.yahoo.vespa.config.protocol.SlimeRequestData;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.logging.Logger;

public class JRTServerConfigRequestV3
implements JRTServerConfigRequest {
    protected static final Logger log = Logger.getLogger(JRTServerConfigRequestV3.class.getName());
    private static final JsonFactory jsonFactory = new JsonFactory();
    protected final Request request;
    private final SlimeRequestData requestData;
    private boolean applyOnRestart = false;
    private boolean isDelayed = false;
    private Trace requestTrace = null;

    protected JRTServerConfigRequestV3(Request request) {
        this.requestData = new SlimeRequestData(request);
        this.request = request;
    }

    protected static JsonGenerator createJsonGenerator(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        return jsonFactory.createGenerator((OutputStream)byteArrayOutputStream);
    }

    protected static Value createResponseValue(ByteArrayOutputStream byteArrayOutputStream) {
        return new StringValue(new Utf8Array(byteArrayOutputStream.toByteArray()));
    }

    protected static void setResponseField(JsonGenerator jsonGenerator, String fieldName, String value) throws IOException {
        jsonGenerator.writeStringField(fieldName, value);
    }

    protected static void setResponseField(JsonGenerator jsonGenerator, String fieldName, long value) throws IOException {
        jsonGenerator.writeNumberField(fieldName, value);
    }

    protected static void setResponseField(JsonGenerator jsonGenerator, String fieldName, boolean value) throws IOException {
        jsonGenerator.writeBooleanField(fieldName, value);
    }

    @Override
    public void addOkResponse(Payload payload, long generation, boolean applyOnRestart, PayloadChecksums payloadChecksums) {
        this.applyOnRestart = applyOnRestart;
        Payload responsePayload = payload.withCompression(this.getCompressionType());
        NoCopyByteArrayOutputStream byteArrayOutputStream = new NoCopyByteArrayOutputStream(4096);
        try {
            JsonGenerator jsonGenerator = JRTServerConfigRequestV3.createJsonGenerator(byteArrayOutputStream);
            jsonGenerator.writeStartObject();
            this.addCommonReturnValues(jsonGenerator);
            if (payloadChecksums.getForType(PayloadChecksum.Type.MD5) != null) {
                JRTServerConfigRequestV3.setResponseField(jsonGenerator, "configMD5", payloadChecksums.getForType(PayloadChecksum.Type.MD5).asString());
            }
            if (payloadChecksums.getForType(PayloadChecksum.Type.XXHASH64) != null) {
                JRTServerConfigRequestV3.setResponseField(jsonGenerator, "configXxhash64", payloadChecksums.getForType(PayloadChecksum.Type.XXHASH64).asString());
            }
            JRTServerConfigRequestV3.setResponseField(jsonGenerator, "generation", generation);
            JRTServerConfigRequestV3.setResponseField(jsonGenerator, "applyOnRestart", applyOnRestart);
            jsonGenerator.writeObjectFieldStart("compressionInfo");
            if (responsePayload == null) {
                throw new RuntimeException("Payload is null for ' " + this + ", not able to create response");
            }
            CompressionInfo compressionInfo = responsePayload.getCompressionInfo();
            compressionInfo.serialize(jsonGenerator);
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not add OK response for " + this);
        }
        this.request.returnValues().add(JRTServerConfigRequestV3.createResponseValue(byteArrayOutputStream));
        ByteBuffer buf = responsePayload.getData().wrap();
        if (buf.hasArray() && buf.remaining() == buf.array().length) {
            this.request.returnValues().add((Value)new DataValue(buf.array()));
        } else {
            byte[] dst = new byte[buf.remaining()];
            buf.get(dst);
            this.request.returnValues().add((Value)new DataValue(dst));
        }
    }

    @Override
    public long getProtocolVersion() {
        return 3L;
    }

    @Override
    public boolean applyOnRestart() {
        return this.applyOnRestart;
    }

    public static JRTServerConfigRequestV3 createFromRequest(Request req) {
        return new JRTServerConfigRequestV3(req);
    }

    @Override
    public ConfigKey<?> getConfigKey() {
        return this.requestData.getConfigKey();
    }

    @Override
    public DefContent getDefContent() {
        return this.getSchema();
    }

    @Override
    public boolean noCache() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("request='").append(this.getConfigKey()).append(",").append(this.getClientHostName()).append(",").append(this.getRequestConfigChecksums()).append(",").append(this.getRequestGeneration()).append(",").append(this.getTimeout()).append("'\n");
        return sb.toString();
    }

    @Override
    public Payload payloadFromResponse(ConfigResponse response) {
        return Payload.from(response.getPayload(), response.getCompressionInfo());
    }

    private DefContent getSchema() {
        return this.requestData.getSchema();
    }

    @Override
    public String getClientHostName() {
        return this.requestData.getClientHostName();
    }

    @Override
    public Trace getRequestTrace() {
        if (this.requestTrace == null) {
            this.requestTrace = this.requestData.getRequestTrace();
        }
        return this.requestTrace;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public boolean validateParameters() {
        int errorCode = RequestValidation.validateRequest(this);
        if (errorCode != 0) {
            this.addErrorResponse(errorCode);
        }
        return errorCode == 0;
    }

    @Override
    public String getRequestConfigMd5() {
        return this.requestData.getRequestConfigMd5();
    }

    @Override
    public String getRequestDefMd5() {
        return this.requestData.getRequestDefMd5();
    }

    @Override
    public PayloadChecksums getRequestConfigChecksums() {
        return this.requestData.getRequestConfigChecksums();
    }

    private void addErrorResponse(int errorCode) {
        this.addErrorResponse(errorCode, ErrorCode.getName(errorCode));
    }

    @Override
    public void setDelayedResponse(boolean delayedResponse) {
        this.isDelayed = delayedResponse;
    }

    @Override
    public void addErrorResponse(int errorCode, String name) {
        NoCopyByteArrayOutputStream byteArrayOutputStream = new NoCopyByteArrayOutputStream();
        try {
            JsonGenerator jsonWriter = jsonFactory.createGenerator((OutputStream)byteArrayOutputStream);
            jsonWriter.writeStartObject();
            this.addCommonReturnValues(jsonWriter);
            jsonWriter.writeEndObject();
            jsonWriter.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not add error response for " + this);
        }
        this.request.setError(errorCode, name);
        this.request.returnValues().add(JRTServerConfigRequestV3.createResponseValue(byteArrayOutputStream));
    }

    protected void addCommonReturnValues(JsonGenerator jsonGenerator) throws IOException {
        ConfigKey<?> key = this.requestData.getConfigKey();
        JRTServerConfigRequestV3.setResponseField(jsonGenerator, "version", this.getProtocolVersion());
        JRTServerConfigRequestV3.setResponseField(jsonGenerator, "defName", key.getName());
        JRTServerConfigRequestV3.setResponseField(jsonGenerator, "defNamespace", key.getNamespace());
        JRTServerConfigRequestV3.setResponseField(jsonGenerator, "defMD5", this.requestData.getRequestDefMd5());
        JRTServerConfigRequestV3.setResponseField(jsonGenerator, "configId", key.getConfigId());
        JRTServerConfigRequestV3.setResponseField(jsonGenerator, "clientHostname", this.requestData.getClientHostName());
        jsonGenerator.writeFieldName("trace");
        jsonGenerator.writeRawValue(this.getRequestTrace().toString(true));
    }

    @Override
    public long getRequestGeneration() {
        return this.requestData.getRequestGeneration();
    }

    @Override
    public boolean isDelayedResponse() {
        return this.isDelayed;
    }

    @Override
    public int errorCode() {
        return this.request.errorCode();
    }

    @Override
    public String errorMessage() {
        return this.request.errorMessage();
    }

    @Override
    public String getShortDescription() {
        return this.toString();
    }

    protected CompressionType getCompressionType() {
        return this.requestData.getCompressionType();
    }

    @Override
    public long getTimeout() {
        return this.requestData.getTimeout();
    }

    @Override
    public Optional<VespaVersion> getVespaVersion() {
        return this.requestData.getVespaVersion();
    }

    @Override
    public PayloadChecksums configPayloadChecksums() {
        return this.requestData.getRequestConfigChecksums();
    }
}

