/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.benchmark;

import com.yahoo.collections.Tuple2;
import com.yahoo.io.IOUtils;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.TransportMetrics;
import com.yahoo.system.CommandLineParser;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequestV3;
import com.yahoo.vespa.config.protocol.JRTConfigRequestFactory;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

public class LoadTester {
    private final Transport transport = new Transport("rpc-client");
    protected Supervisor supervisor = new Supervisor(this.transport);
    private List<ConfigKey<?>> configs = new ArrayList();
    private Map<ConfigDefinitionKey, Tuple2<String, String[]>> defs = new HashMap<ConfigDefinitionKey, Tuple2<String, String[]>>();
    private final CompressionType compressionType = JRTConfigRequestFactory.getCompressionType();
    private final String host;
    private final int port;
    private final int iterations;
    private final int threads;
    private final String configFile;
    private final String defPath;
    private final boolean debug;

    LoadTester(String host, int port, int iterations, int threads, String configFile, String defPath, boolean debug) {
        this.host = host;
        this.port = port;
        this.iterations = iterations;
        this.threads = threads;
        this.configFile = configFile;
        this.defPath = defPath;
        this.debug = debug;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        CommandLineParser parser = new CommandLineParser("LoadTester", args);
        parser.addLegalUnarySwitch("-d", "debug");
        parser.addRequiredBinarySwitch("-c", "host (config proxy or server)");
        parser.addRequiredBinarySwitch("-p", "port");
        parser.addRequiredBinarySwitch("-i", "iterations per thread");
        parser.addRequiredBinarySwitch("-t", "threads");
        parser.addLegalBinarySwitch("-l", "config file, on form name,configid. (To get list: vespa-configproxy-cmd -m cache | cut -d ',' -f1-2)");
        parser.addLegalBinarySwitch("-dd", "dir with def files, must be of form name.def");
        parser.parse();
        String host = (String)parser.getBinarySwitches().get("-c");
        int port = Integer.parseInt((String)parser.getBinarySwitches().get("-p"));
        int iterations = Integer.parseInt((String)parser.getBinarySwitches().get("-i"));
        int threads = Integer.parseInt((String)parser.getBinarySwitches().get("-t"));
        String configFile = (String)parser.getBinarySwitches().get("-l");
        String defPath = (String)parser.getBinarySwitches().get("-dd");
        boolean debug = parser.getUnarySwitches().contains("-d");
        new LoadTester(host, port, iterations, threads, configFile, defPath, debug).runLoad();
    }

    private void runLoad() throws IOException, InterruptedException {
        this.configs = this.readConfigs(this.configFile);
        this.defs = this.readDefs(this.defPath);
        this.validateConfigs(this.configs, this.defs);
        ArrayList<LoadThread> threadList = new ArrayList<LoadThread>();
        Metrics m = new Metrics();
        long startInNanos = System.nanoTime();
        for (int i = 0; i < this.threads; ++i) {
            LoadThread lt = new LoadThread(this.iterations, this.host, this.port);
            threadList.add(lt);
            lt.start();
        }
        for (LoadThread lt : threadList) {
            lt.join();
            m.merge(lt.metrics);
        }
        float durationInSeconds = (float)(System.nanoTime() - startInNanos) / 1.0E9f;
        this.printResults(durationInSeconds, this.threads, this.iterations, m);
    }

    private Map<ConfigDefinitionKey, Tuple2<String, String[]>> readDefs(String defPath) throws IOException {
        HashMap<ConfigDefinitionKey, Tuple2<String, String[]>> ret = new HashMap<ConfigDefinitionKey, Tuple2<String, String[]>>();
        if (defPath == null) {
            return ret;
        }
        File defDir = new File(defPath);
        if (!defDir.isDirectory()) {
            System.out.println("# Given def file dir is not a directory: " + defDir.getPath() + " , will not send def contents in requests.");
            return ret;
        }
        File[] files = defDir.listFiles();
        if (files == null) {
            System.out.println("# Given def file dir has no files: " + defDir.getPath() + " , will not send def contents in requests.");
            return ret;
        }
        for (File f : files) {
            String name = f.getName();
            if (!name.endsWith(".def")) continue;
            String contents = IOUtils.readFile((File)f);
            ConfigDefinitionKey key = ConfigUtils.createConfigDefinitionKeyFromDefFile(f);
            ret.put(key, (Tuple2<String, String[]>)new Tuple2((Object)ConfigUtils.getDefMd5(Arrays.asList(contents.split("\n"))), (Object)contents.split("\n")));
        }
        System.out.println("#  Read " + ret.size() + " def files from " + defDir.getPath());
        return ret;
    }

    private void printResults(float durationInSeconds, long threads, long iterations, Metrics metrics) {
        StringBuilder sb = new StringBuilder();
        sb.append("#reqs/sec #avglatency #minlatency #maxlatency #failedrequests\n");
        sb.append((float)(iterations * threads) / durationInSeconds).append(",");
        sb.append(metrics.latencyInMillis / threads / iterations).append(",");
        sb.append(metrics.minLatency).append(",");
        sb.append(metrics.maxLatency).append(",");
        sb.append(metrics.failedRequests);
        sb.append("\n");
        sb.append('#').append(TransportMetrics.getInstance().snapshot().toString()).append('\n');
        System.out.println(sb);
    }

    private List<ConfigKey<?>> readConfigs(String configsList) throws IOException {
        ArrayList ret = new ArrayList();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configsList), StandardCharsets.UTF_8));
        String str = br.readLine();
        while (str != null) {
            String[] nameAndId = str.split(",");
            Tuple2<String, String> nameAndNamespace = ConfigUtils.getNameAndNamespaceFromString(nameAndId[0]);
            ConfigKey key = new ConfigKey((String)nameAndNamespace.first, nameAndId[1], (String)nameAndNamespace.second);
            ret.add(key);
            str = br.readLine();
        }
        br.close();
        return ret;
    }

    private void validateConfigs(List<ConfigKey<?>> configs, Map<ConfigDefinitionKey, Tuple2<String, String[]>> defs) {
        for (ConfigKey<?> configKey : configs) {
            ConfigDefinitionKey dKey = new ConfigDefinitionKey(configKey);
            Tuple2<String, String[]> defContent = defs.get(dKey);
            if (defContent != null) continue;
            throw new IllegalArgumentException("No matching config definition for " + configKey + ", known config definitions: " + defs.keySet());
        }
    }

    private class LoadThread
    extends Thread {
        private final int iterations;
        private final Spec spec;
        private final Metrics metrics = new Metrics();

        LoadThread(int iterations, String host, int port) {
            this.iterations = iterations;
            this.spec = new Spec(host, port);
        }

        @Override
        public void run() {
            Target target = this.connect(this.spec);
            int numberOfConfigs = LoadTester.this.configs.size();
            for (int i = 0; i < this.iterations; ++i) {
                ConfigKey<?> reqKey = LoadTester.this.configs.get(ThreadLocalRandom.current().nextInt(numberOfConfigs));
                JRTClientConfigRequest request = this.createRequest(reqKey);
                if (LoadTester.this.debug) {
                    System.out.println("# Requesting: " + reqKey);
                }
                long start = System.nanoTime();
                target.invokeSync(request.getRequest(), 10.0);
                long durationInMillis = (System.nanoTime() - start) / 1000000L;
                if (request.isError()) {
                    target = this.handleError(request, this.spec, target);
                    continue;
                }
                this.metrics.update(durationInMillis);
            }
        }

        private JRTClientConfigRequest createRequest(ConfigKey<?> reqKey) {
            ConfigDefinitionKey dKey = new ConfigDefinitionKey(reqKey);
            Tuple2<String, String[]> defContent = LoadTester.this.defs.get(dKey);
            ConfigKey<?> fullKey = ConfigKey.createFull(reqKey.getName(), reqKey.getConfigId(), reqKey.getNamespace());
            long serverTimeout = 1000L;
            return JRTClientConfigRequestV3.createWithParams(fullKey, DefContent.fromList(List.of((String[])defContent.second)), ConfigUtils.getCanonicalHostName(), PayloadChecksums.empty(), 0L, 1000L, Trace.createDummy(), LoadTester.this.compressionType, Optional.empty());
        }

        private Target connect(Spec spec) {
            return LoadTester.this.supervisor.connect(spec);
        }

        private Target handleError(JRTClientConfigRequest request, Spec spec, Target target) {
            if (List.of("Connection lost", "Connection down").contains(request.errorMessage())) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                System.out.println("# Connection lost, reconnecting...");
                target.close();
                target = this.connect(spec);
            } else {
                System.err.println(request.errorMessage());
            }
            this.metrics.incFailedRequests();
            return target;
        }
    }

    private static class Metrics {
        long latencyInMillis = 0L;
        long failedRequests = 0L;
        long maxLatency = Long.MIN_VALUE;
        long minLatency = Long.MAX_VALUE;

        private Metrics() {
        }

        public void merge(Metrics m) {
            this.latencyInMillis += m.latencyInMillis;
            this.failedRequests += m.failedRequests;
            this.updateMin(m.minLatency);
            this.updateMax(m.maxLatency);
        }

        public void update(long latency) {
            this.latencyInMillis += latency;
            this.updateMin(latency);
            this.updateMax(latency);
        }

        private void updateMin(long latency) {
            if (latency < this.minLatency) {
                this.minLatency = latency;
            }
        }

        private void updateMax(long latency) {
            if (latency > this.maxLatency) {
                this.maxLatency = latency;
            }
        }

        private void incFailedRequests() {
            ++this.failedRequests;
        }
    }
}

