/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import java.util.Random;

public class TimingValues {
    public static final long defaultNextConfigTimeout = 1000L;
    private final long successTimeout;
    private final long errorTimeout;
    private final long initialTimeout;
    private long subscribeTimeout = 55000L;
    private long configuredErrorTimeout = -1L;
    private long fixedDelay = 5000L;
    private final Random rand;

    public TimingValues() {
        this.successTimeout = 600000L;
        this.errorTimeout = 20000L;
        this.initialTimeout = 15000L;
        this.rand = new Random(System.currentTimeMillis());
    }

    public TimingValues(long successTimeout, long errorTimeout, long initialTimeout, long subscribeTimeout, long fixedDelay) {
        this.successTimeout = successTimeout;
        this.errorTimeout = errorTimeout;
        this.initialTimeout = initialTimeout;
        this.subscribeTimeout = subscribeTimeout;
        this.fixedDelay = fixedDelay;
        this.rand = new Random(System.currentTimeMillis());
    }

    private TimingValues(long successTimeout, long errorTimeout, long initialTimeout, long subscribeTimeout, long fixedDelay, Random rand) {
        this.successTimeout = successTimeout;
        this.errorTimeout = errorTimeout;
        this.initialTimeout = initialTimeout;
        this.subscribeTimeout = subscribeTimeout;
        this.fixedDelay = fixedDelay;
        this.rand = rand;
    }

    public TimingValues(TimingValues tv, Random random) {
        this(tv.successTimeout, tv.errorTimeout, tv.initialTimeout, tv.subscribeTimeout, tv.fixedDelay, random);
    }

    public long getSuccessTimeout() {
        return this.successTimeout;
    }

    public long getErrorTimeout() {
        return this.errorTimeout;
    }

    public long getSubscribeTimeout() {
        return this.subscribeTimeout;
    }

    public TimingValues setSubscribeTimeout(long t) {
        this.subscribeTimeout = t;
        return this;
    }

    public TimingValues setConfiguredErrorTimeout(long t) {
        this.configuredErrorTimeout = t;
        return this;
    }

    public long getFixedDelay() {
        return this.fixedDelay;
    }

    public TimingValues setFixedDelay(long t) {
        this.fixedDelay = t;
        return this;
    }

    public long getPlusMinusFractionRandom(long value, float fraction) {
        return Math.round((float)value - (float)value * fraction + this.rand.nextFloat() * 2.0f * (float)value * fraction);
    }

    public String toString() {
        return "TimingValues [successTimeout=" + this.successTimeout + ", errorTimeout=" + this.errorTimeout + ", initialTimeout=" + this.initialTimeout + ", subscribeTimeout=" + this.subscribeTimeout + ", configuredErrorTimeout=" + this.configuredErrorTimeout + ", fixedDelay=" + this.fixedDelay + ", rand=" + this.rand + "]";
    }
}

