/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.PayloadChecksum;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class JRTConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private JRTConfigRequester requester;
    private final TimingValues timingValues;
    private Instant lastOK = Instant.MIN;
    private BlockingQueue<JRTClientConfigRequest> reqQueue = new LinkedBlockingQueue<JRTClientConfigRequest>();
    private ConfigSourceSet sources;

    public JRTConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source, TimingValues timingValues) {
        super(key, subscriber);
        this.timingValues = timingValues;
        if (source instanceof ConfigSourceSet) {
            this.sources = (ConfigSourceSet)source;
        }
    }

    @Override
    public boolean nextConfig(long timeoutMillis) {
        JRTClientConfigRequest jrtReq = this.pollQueue(timeoutMillis);
        if (jrtReq == null) {
            return this.newConfigOrException();
        }
        log.log(Level.FINE, () -> "Polled queue and found config " + jrtReq);
        if (jrtReq.hasUpdatedGeneration()) {
            this.setApplyOnRestart(jrtReq.responseIsApplyOnRestart());
            if (jrtReq.hasUpdatedConfig()) {
                this.setNewConfig(jrtReq);
            } else {
                this.setGeneration(jrtReq.getNewGeneration());
            }
        }
        return this.newConfigOrException();
    }

    private boolean newConfigOrException() {
        ConfigSubscription.ConfigState configState = this.getConfigState();
        return configState.isGenerationChanged() || configState.isConfigChanged() || this.hasException();
    }

    private JRTClientConfigRequest pollQueue(long timeoutMillis) {
        try {
            return this.reqQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            throw new ConfigInterruptedException(e1);
        }
    }

    protected void setNewConfig(JRTClientConfigRequest jrtReq) {
        IllegalArgumentException badConfigE = null;
        Object configInstance = null;
        try {
            configInstance = this.toConfigInstance(jrtReq);
        }
        catch (IllegalArgumentException e) {
            badConfigE = e;
        }
        this.setConfig(jrtReq.getNewGeneration(), jrtReq.responseIsApplyOnRestart(), configInstance, jrtReq.getNewChecksums());
        if (badConfigE != null) {
            throw new IllegalArgumentException("Bad config from jrt", badConfigE);
        }
    }

    private T toConfigInstance(JRTClientConfigRequest jrtRequest) {
        Payload payload = jrtRequest.getNewPayload();
        ConfigPayload configPayload = ConfigPayload.fromUtf8Array(payload.withCompression(CompressionType.UNCOMPRESSED).getData());
        Object configInstance = configPayload.toInstance(this.configClass, jrtRequest.getConfigKey().getConfigId());
        configInstance.setConfigMd5(jrtRequest.getNewChecksums().getForType(PayloadChecksum.Type.MD5).asString());
        return (T)configInstance;
    }

    void updateConfig(JRTClientConfigRequest jrtReq) {
        this.reqQueue.clear();
        if (!this.reqQueue.offer(jrtReq)) {
            this.setException((RuntimeException)new ConfigurationRuntimeException("Failed offering returned request to queue of subscription " + this));
        }
    }

    @Override
    public boolean subscribe(long timeout) {
        this.lastOK = Instant.now();
        this.requester = this.getRequester();
        this.requester.request(this);
        JRTClientConfigRequest req = (JRTClientConfigRequest)this.reqQueue.peek();
        while (req == null && Instant.now().isBefore(this.lastOK.plus(Duration.ofMillis(timeout)))) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ConfigInterruptedException(e);
            }
            req = (JRTClientConfigRequest)this.reqQueue.peek();
        }
        return req != null;
    }

    private JRTConfigRequester getRequester() {
        JRTConfigRequester requester = this.subscriber.requesters().get(this.sources);
        if (requester == null) {
            requester = JRTConfigRequester.create(this.sources, this.timingValues);
            this.subscriber.requesters().put(this.sources, requester);
        }
        return requester;
    }

    @Override
    public void close() {
        super.close();
        this.reqQueue = new LinkedBlockingQueue<JRTClientConfigRequest>(){

            @Override
            public void put(JRTClientConfigRequest e) {
            }
        };
    }

    public TimingValues timingValues() {
        return this.timingValues;
    }

    public JRTConfigRequester requester() {
        return this.requester;
    }

    @Override
    public void reload(long generation) {
        log.log(Level.FINE, "reload() is without effect on a JRTConfigSubscription.");
    }

    void setLastCallBackOKTS(Instant lastCallBackOKTS) {
        this.lastOK = lastCallBackOKTS;
    }

    static void printStatus(JRTClientConfigRequest request, String message) {
        String name = request.getConfigKey().getName();
        if (name.equals("components") || name.equals("chains")) {
            log.log(Level.INFO, message + ":" + name + ":, request=" + request);
        }
    }
}

