/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.Payload;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SlimeConfigResponse
implements ConfigResponse {
    private final AbstractUtf8Array payload;
    private final CompressionInfo compressionInfo;
    private final long generation;
    private final boolean applyOnRestart;
    private final String configMd5;

    public static SlimeConfigResponse fromConfigPayload(ConfigPayload payload, long generation, boolean applyOnRestart, String configMd5) {
        AbstractUtf8Array data = payload.toUtf8Array(true);
        return new SlimeConfigResponse(data, generation, applyOnRestart, configMd5, CompressionInfo.create(CompressionType.UNCOMPRESSED, data.getByteLength()));
    }

    public SlimeConfigResponse(AbstractUtf8Array payload, long generation, boolean applyOnRestart, String configMd5, CompressionInfo compressionInfo) {
        this.payload = payload;
        this.generation = generation;
        this.applyOnRestart = applyOnRestart;
        this.configMd5 = configMd5;
        this.compressionInfo = compressionInfo;
    }

    @Override
    public AbstractUtf8Array getPayload() {
        return this.payload;
    }

    @Override
    public long getGeneration() {
        return this.generation;
    }

    @Override
    public boolean applyOnRestart() {
        return this.applyOnRestart;
    }

    @Override
    public String getConfigMd5() {
        return this.configMd5;
    }

    @Override
    public void serialize(OutputStream os, CompressionType type) throws IOException {
        ByteBuffer buf = Payload.from(this.payload, this.compressionInfo).withCompression(type).getData().wrap();
        os.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
    }

    public String toString() {
        return "generation=" + this.generation + "\nconfigmd5=" + this.configMd5 + "\n" + Payload.from(this.payload, this.compressionInfo).withCompression(CompressionType.UNCOMPRESSED);
    }

    @Override
    public CompressionInfo getCompressionInfo() {
        return this.compressionInfo;
    }
}

