/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.CfgConfigPayloadBuilder;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

public class FileConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    final File file;
    long ts;

    FileConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber, File f) {
        super(key, subscriber);
        this.setGeneration(0L);
        this.file = f;
        if (!this.file.exists() && !this.file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + this.file);
        }
    }

    @Override
    public boolean nextConfig(long timeout) {
        if (!this.file.exists() && !this.file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + this.file);
        }
        if (this.checkReloaded()) {
            log.log(Level.FINE, () -> "User forced config reload at " + System.currentTimeMillis());
            this.setConfigIfChanged(this.updateConfig());
            ConfigSubscription.ConfigState configState = this.getConfigState();
            log.log(Level.FINE, () -> "Config updated at " + System.currentTimeMillis() + ", changed: " + configState.isConfigChanged());
            log.log(Level.FINE, () -> "Config: " + configState.getConfig().toString());
            return true;
        }
        if (this.file.lastModified() != this.ts) {
            this.setConfigIncGen(this.updateConfig());
            return true;
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
        return false;
    }

    private T updateConfig() {
        this.ts = this.file.lastModified();
        try {
            ConfigPayload payload = new CfgConfigPayloadBuilder().deserialize(Arrays.asList(IOUtils.readFile((File)this.file).split("\n")));
            return (T)payload.toInstance(this.configClass, this.key.getConfigId());
        }
        catch (IOException e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }
}

