/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.nio.ByteBuffer;

public class LZ4PayloadCompressor {
    private static final String VESPA_CONFIG_PROTOCOL_COMPRESSION_LEVEL = "VESPA_CONFIG_PROTOCOL_COMPRESSION_LEVEL";
    private static final Compressor compressor = new Compressor(CompressionType.LZ4, LZ4PayloadCompressor.getCompressionLevel());

    private static int getCompressionLevel() {
        return Integer.parseInt(ConfigUtils.getEnvValue("0", System.getenv(VESPA_CONFIG_PROTOCOL_COMPRESSION_LEVEL), System.getProperty(VESPA_CONFIG_PROTOCOL_COMPRESSION_LEVEL)));
    }

    public byte[] compress(byte[] input) {
        return compressor.compressUnconditionally(input);
    }

    public byte[] compress(ByteBuffer input) {
        return compressor.compressUnconditionally(input);
    }

    public byte[] decompress(byte[] input, int uncompressedLen) {
        return compressor.decompressUnconditionally(input, 0, uncompressedLen);
    }

    public byte[] decompress(ByteBuffer input, int uncompressedLen) {
        ByteBuffer uncompressed = ByteBuffer.allocate(uncompressedLen);
        compressor.decompressUnconditionally(input, uncompressed);
        return uncompressed.array();
    }
}

