/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JRTConnectionPool
implements ConnectionPool {
    private static final Logger log = Logger.getLogger(JRTConnectionPool.class.getName());
    private final Supervisor supervisor;
    private final Map<String, JRTConnection> connections = new LinkedHashMap<String, JRTConnection>();
    private ConfigSourceSet sourceSet = null;
    private volatile JRTConnection currentConnection;

    public JRTConnectionPool(ConfigSourceSet sourceSet) {
        this.supervisor = new Supervisor(new Transport("config-jrtpool-" + sourceSet.hashCode())).useSmallBuffers();
        this.addSources(sourceSet);
    }

    public JRTConnectionPool(List<String> addresses) {
        this(new ConfigSourceSet(addresses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSources(ConfigSourceSet sourceSet) {
        this.sourceSet = sourceSet;
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            for (String address : sourceSet.getSources()) {
                this.connections.put(address, new JRTConnection(address, this.supervisor));
            }
        }
        this.setNewCurrentConnection();
    }

    @Override
    public synchronized JRTConnection getCurrent() {
        return this.currentConnection;
    }

    @Override
    public synchronized JRTConnection setNewCurrentConnection() {
        List<JRTConnection> sources = this.getSources();
        this.currentConnection = sources.get(ThreadLocalRandom.current().nextInt(0, sources.size()));
        log.log(Level.INFO, () -> "Choosing new connection: " + this.currentConnection);
        return this.currentConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<JRTConnection> getSources() {
        ArrayList<JRTConnection> ret;
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            ret = new ArrayList<JRTConnection>(this.connections.values());
        }
        return ret;
    }

    ConfigSourceSet getSourceSet() {
        return this.sourceSet;
    }

    @Override
    public void setError(Connection connection, int errorCode) {
        connection.setError(errorCode);
        this.setNewCurrentConnection();
    }

    public JRTConnectionPool updateSources(List<String> addresses) {
        ConfigSourceSet newSources = new ConfigSourceSet(addresses);
        return this.updateSources(newSources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRTConnectionPool updateSources(ConfigSourceSet sourceSet) {
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            for (JRTConnection conn : this.connections.values()) {
                conn.getTarget().close();
            }
            this.connections.clear();
            this.addSources(sourceSet);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            for (JRTConnection conn : this.connections.values()) {
                sb.append(conn.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void close() {
        this.supervisor.transport().shutdown().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Map<String, JRTConnection> map = this.connections;
        synchronized (map) {
            return this.connections.size();
        }
    }

    @Override
    public Supervisor getSupervisor() {
        return this.supervisor;
    }
}

