/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.protocol.JRTConfigRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestValidation {
    private static final Logger log = Logger.getLogger(RequestValidation.class.getName());
    private static final Pattern md5Pattern = Pattern.compile("[0-9a-zA-Z]+");

    public static int validateRequest(JRTConfigRequest request) {
        ConfigKey<?> key = request.getConfigKey();
        if (!RequestValidation.verifyName(key.getName())) {
            log.log(Level.INFO, "Illegal name '" + key.getName() + "'");
            return 100100;
        }
        if (!RequestValidation.verifyNamespace(key.getNamespace())) {
            log.log(Level.INFO, "Illegal name space '" + key.getNamespace() + "'");
            return 100108;
        }
        if (!RequestValidation.verifyMd5(key.getMd5())) {
            log.log(Level.INFO, "Illegal md5 sum '" + key.getNamespace() + "'");
            return 100103;
        }
        if (!RequestValidation.verifyMd5(request.getRequestConfigMd5())) {
            log.log(Level.INFO, "Illegal config md5 '" + request.getRequestConfigMd5() + "'");
            return 100104;
        }
        if (!RequestValidation.verifyGeneration(request.getRequestGeneration())) {
            log.log(Level.INFO, "Illegal generation '" + request.getRequestGeneration() + "'");
            return 100106;
        }
        if (!RequestValidation.verifyTimeout(request.getTimeout())) {
            log.log(Level.INFO, "Illegal timeout '" + request.getTimeout() + "'");
            return 100105;
        }
        if (!RequestValidation.verifyHostname(request.getClientHostName())) {
            log.log(Level.INFO, "Illegal client host name '" + request.getClientHostName() + "'");
            return 100110;
        }
        return 0;
    }

    public static boolean verifyName(String name) {
        Matcher m = ConfigDefinition.namePattern.matcher(name);
        return m.matches();
    }

    public static boolean verifyMd5(String md5) {
        if (md5.equals("")) {
            return true;
        }
        if (md5.length() != 32) {
            return false;
        }
        Matcher m = md5Pattern.matcher(md5);
        return m.matches();
    }

    public static boolean verifyTimeout(Long timeout) {
        return timeout > 0L;
    }

    private static boolean verifyGeneration(Long generation) {
        return generation >= 0L;
    }

    private static boolean verifyNamespace(String namespace) {
        Matcher m = ConfigDefinition.namespacePattern.matcher(namespace);
        return m.matches();
    }

    private static boolean verifyHostname(String clientHostName) {
        return !"".equals(clientHostName);
    }
}

