/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.TimingValues;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class JRTManagedConnectionPools {
    private final Map<ConfigSourceSet, CountedPool> pools = new HashMap<ConfigSourceSet, CountedPool>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRTConfigRequester acquire(ConfigSourceSet sourceSet, TimingValues timingValues) {
        CountedPool countedPool;
        Map<ConfigSourceSet, CountedPool> map = this.pools;
        synchronized (map) {
            countedPool = this.pools.get(sourceSet);
            if (countedPool == null) {
                countedPool = new CountedPool(new JRTConnectionPool(sourceSet));
                this.pools.put(sourceSet, countedPool);
            }
            ++countedPool.count;
        }
        return new JRTConfigRequester(sourceSet, countedPool.scheduler, countedPool.pool, timingValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(ConfigSourceSet sourceSet) {
        CountedPool countedPool;
        Map<ConfigSourceSet, CountedPool> map = this.pools;
        synchronized (map) {
            countedPool = this.pools.get(sourceSet);
            if (countedPool != null) {
                --countedPool.count;
            }
            if (countedPool == null || countedPool.count > 0L) {
                return;
            }
            this.pools.remove(sourceSet);
        }
        countedPool.pool.close();
        countedPool.scheduler.shutdown();
        try {
            countedPool.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed shutting down scheduler:", e);
        }
    }

    private static class CountedPool {
        long count;
        final JRTConnectionPool pool;
        final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, new JRTSourceThreadFactory());

        CountedPool(JRTConnectionPool requester) {
            this.pool = requester;
            this.count = 0L;
        }
    }

    private static class JRTSourceThreadFactory
    implements ThreadFactory {
        private JRTSourceThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, String.format("jrt-config-requester-%d", System.currentTimeMillis()));
            t.setDaemon(true);
            return t;
        }
    }
}

