/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigFileFormat;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.Payload;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class SlimeConfigResponse
implements ConfigResponse {
    private final Utf8Array payload;
    private final CompressionInfo compressionInfo;
    private final InnerCNode targetDef;
    private final long generation;
    private final boolean internalRedeploy;
    private final String configMd5;

    public static SlimeConfigResponse fromConfigPayload(ConfigPayload payload, InnerCNode targetDef, long generation, boolean internalRedeploy, String configMd5) {
        Utf8Array data = payload.toUtf8Array(true);
        return new SlimeConfigResponse(data, targetDef, generation, internalRedeploy, configMd5, CompressionInfo.create(CompressionType.UNCOMPRESSED, data.getByteLength()));
    }

    public SlimeConfigResponse(Utf8Array payload, InnerCNode targetDef, long generation, boolean internalRedeploy, String configMd5, CompressionInfo compressionInfo) {
        this.payload = payload;
        this.targetDef = targetDef;
        this.generation = generation;
        this.internalRedeploy = internalRedeploy;
        this.configMd5 = configMd5;
        this.compressionInfo = compressionInfo;
    }

    @Override
    public Utf8Array getPayload() {
        return this.payload;
    }

    @Override
    public List<String> getLegacyPayload() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ConfigFileFormat format = new ConfigFileFormat(this.targetDef);
        Payload v1payload = Payload.from(this.payload, this.compressionInfo).withCompression(CompressionType.UNCOMPRESSED);
        try {
            ConfigPayload.fromUtf8Array(v1payload.getData()).serialize(baos, format);
            return Arrays.asList(baos.toString("UTF-8").split("\\n"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getGeneration() {
        return this.generation;
    }

    @Override
    public boolean isInternalRedeploy() {
        return this.internalRedeploy;
    }

    @Override
    public String getConfigMd5() {
        return this.configMd5;
    }

    @Override
    public void serialize(OutputStream os, CompressionType type) throws IOException {
        os.write(Payload.from(this.payload, this.compressionInfo).withCompression(type).getData().getBytes());
    }

    public String toString() {
        return "generation=" + this.generation + "\nconfigmd5=" + this.configMd5 + "\n" + Payload.from(this.payload, this.compressionInfo).withCompression(CompressionType.UNCOMPRESSED);
    }

    @Override
    public CompressionInfo getCompressionInfo() {
        return this.compressionInfo;
    }
}

