/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import java.util.List;
import java.util.logging.Level;

public class GenericJRTConfigSubscription
extends JRTConfigSubscription<RawConfig> {
    private final List<String> defContent;

    public GenericJRTConfigSubscription(ConfigKey<RawConfig> key, List<String> defContent, ConfigSubscriber subscriber, ConfigSource source, TimingValues timingValues) {
        super(key, subscriber, source, timingValues);
        this.defContent = defContent;
    }

    @Override
    protected void setNewConfig(JRTClientConfigRequest jrtReq) {
        this.setConfig(jrtReq.getNewGeneration(), jrtReq.responseIsInternalRedeploy(), RawConfig.createFromResponseParameters(jrtReq));
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "in setNewConfig, config=" + this.getConfigState().getConfig());
        }
    }

    @Override
    void setGeneration(Long generation) {
        super.setGeneration(generation);
        ConfigSubscription.ConfigState configState = this.getConfigState();
        if (configState.getConfig() != null) {
            ((RawConfig)((Object)configState.getConfig())).setGeneration(generation);
        }
    }

    @Override
    void setInternalRedeploy(boolean internalRedeploy) {
        super.setInternalRedeploy(internalRedeploy);
        ConfigSubscription.ConfigState configState = this.getConfigState();
        if (configState.getConfig() != null) {
            ((RawConfig)((Object)configState.getConfig())).setInternalRedeploy(internalRedeploy);
        }
    }

    public RawConfig getRawConfig() {
        return (RawConfig)((Object)this.getConfigState().getConfig());
    }

    @Override
    public DefContent getDefContent() {
        return DefContent.fromList(this.defContent);
    }
}

