/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.log.LogLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class ConfigSourceSet
implements ConfigSource {
    private static final Logger log = Logger.getLogger(ConfigSourceSet.class.getName());
    private final Set<String> sources = new LinkedHashSet<String>();

    public ConfigSourceSet() {
    }

    public ConfigSourceSet(List<String> addresses) {
        for (String a : addresses) {
            this.sources.add(a.trim().toLowerCase());
        }
    }

    public ConfigSourceSet(String[] addresses) {
        this(Arrays.asList(addresses));
    }

    public ConfigSourceSet(String address) {
        this(new String[]{address});
    }

    public Set<String> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigSourceSet)) {
            return false;
        }
        ConfigSourceSet css = (ConfigSourceSet)o;
        return this.sources.equals(css.sources);
    }

    public int hashCode() {
        return this.sources.hashCode();
    }

    public String toString() {
        return this.sources.toString();
    }

    public static ConfigSourceSet createDefault() {
        String configSources = System.getenv("VESPA_CONFIG_SOURCES");
        if (configSources != null) {
            log.log(LogLevel.INFO, "Using config sources from VESPA_CONFIG_SOURCES: " + configSources);
            return new ConfigSourceSet(ConfigSourceSet.checkSourcesSyntax(configSources));
        }
        String[] def = new String[]{"tcp/localhost:" + System.getProperty("vespa.config.port", "19090")};
        String[] sourceSet = ConfigSourceSet.checkSourcesSyntax(System.getProperty("configsources"));
        return new ConfigSourceSet(sourceSet == null ? def : sourceSet);
    }

    private static String[] checkSourcesSyntax(String sources) {
        String[] sourceSet = null;
        if (sources != null) {
            sourceSet = sources.split(",");
            int i = 0;
            for (String s : sourceSet) {
                if (!s.startsWith("tcp/")) {
                    sourceSet[i] = "tcp/" + sourceSet[i];
                }
                ++i;
            }
        }
        return sourceSet;
    }
}

