/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.slime.Inspector;
import com.yahoo.vespa.config.protocol.CompressionType;
import java.io.IOException;

public class CompressionInfo {
    private static final String COMPRESSION_TYPE = "compressionType";
    private static final String UNCOMPRESSED_SIZE = "uncompressedSize";
    private final CompressionType compressionType;
    private final int uncompressedSize;

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    private CompressionInfo(CompressionType compressionType, int uncompressedSize) {
        this.compressionType = compressionType;
        this.uncompressedSize = uncompressedSize;
    }

    public static CompressionInfo uncompressed() {
        return new CompressionInfo(CompressionType.UNCOMPRESSED, 0);
    }

    public static CompressionInfo create(CompressionType type, int uncompressedSize) {
        return new CompressionInfo(type, uncompressedSize);
    }

    public static CompressionInfo fromSlime(Inspector field) {
        CompressionType type = CompressionType.parse(field.field(COMPRESSION_TYPE).asString());
        int uncompressedSize = (int)field.field(UNCOMPRESSED_SIZE).asLong();
        return new CompressionInfo(type, uncompressedSize);
    }

    public void serialize(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStringField(COMPRESSION_TYPE, this.compressionType.name());
        jsonGenerator.writeNumberField(UNCOMPRESSED_SIZE, this.uncompressedSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressionInfo that = (CompressionInfo)o;
        if (this.uncompressedSize != that.uncompressedSize) {
            return false;
        }
        return this.compressionType == that.compressionType;
    }

    public int hashCode() {
        int result = this.compressionType.hashCode();
        result = 31 * result + this.uncompressedSize;
        return result;
    }
}

