/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.protocol.CompressionInfo;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.Payload;
import java.io.IOException;
import java.io.OutputStream;

public class SlimeConfigResponse
implements ConfigResponse {
    private final Utf8Array payload;
    private final CompressionInfo compressionInfo;
    private final long generation;
    private final boolean internalRedeploy;
    private final String configMd5;

    public static SlimeConfigResponse fromConfigPayload(ConfigPayload payload, long generation, boolean internalRedeploy, String configMd5) {
        Utf8Array data = payload.toUtf8Array(true);
        return new SlimeConfigResponse(data, generation, internalRedeploy, configMd5, CompressionInfo.create(CompressionType.UNCOMPRESSED, data.getByteLength()));
    }

    public SlimeConfigResponse(Utf8Array payload, long generation, boolean internalRedeploy, String configMd5, CompressionInfo compressionInfo) {
        this.payload = payload;
        this.generation = generation;
        this.internalRedeploy = internalRedeploy;
        this.configMd5 = configMd5;
        this.compressionInfo = compressionInfo;
    }

    @Override
    public Utf8Array getPayload() {
        return this.payload;
    }

    @Override
    public long getGeneration() {
        return this.generation;
    }

    @Override
    public boolean isInternalRedeploy() {
        return this.internalRedeploy;
    }

    @Override
    public String getConfigMd5() {
        return this.configMd5;
    }

    @Override
    public void serialize(OutputStream os, CompressionType type) throws IOException {
        os.write(Payload.from(this.payload, this.compressionInfo).withCompression(type).getData().getBytes());
    }

    public String toString() {
        return "generation=" + this.generation + "\nconfigmd5=" + this.configMd5 + "\n" + Payload.from(this.payload, this.compressionInfo).withCompression(CompressionType.UNCOMPRESSED);
    }

    @Override
    public CompressionInfo getCompressionInfo() {
        return this.compressionInfo;
    }
}

