/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.config.UrlReference;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigTransformer;
import com.yahoo.vespa.config.UrlDownloader;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigPayloadApplier<T extends ConfigInstance.Builder> {
    private static final Logger log = Logger.getLogger(ConfigPayloadApplier.class.getPackage().getName());
    private final ConfigInstance.Builder rootBuilder;
    private final ConfigTransformer.PathAcquirer pathAcquirer;
    private final UrlDownloader urlDownloader;
    private final Stack<NamedBuilder> stack = new Stack();
    private final Map<String, Method> methodCache = new HashMap<String, Method>();
    private Set<String> pathFieldSet = new HashSet<String>();
    private Set<String> urlFieldSet = new HashSet<String>();
    private final Map<String, Constructor<?>> constructorCache = new HashMap();

    public ConfigPayloadApplier(T builder) {
        this(builder, new IdentityPathAcquirer(), null);
    }

    public ConfigPayloadApplier(T builder, ConfigTransformer.PathAcquirer pathAcquirer, UrlDownloader urlDownloader) {
        this.rootBuilder = builder;
        this.pathAcquirer = pathAcquirer;
        this.urlDownloader = urlDownloader;
        this.debug("rootBuilder=" + this.rootBuilder);
    }

    public void applyPayload(ConfigPayload payload) {
        this.stack.push(new NamedBuilder((ConfigBuilder)this.rootBuilder));
        try {
            this.handleValue((Inspector)payload.getSlime().get());
        }
        catch (Exception e) {
            throw new RuntimeException("Not able to create config builder for payload:" + payload.toString() + ", " + Exceptions.toMessageString((Throwable)e), e);
        }
    }

    private void handleValue(Inspector inspector) {
        switch (inspector.type()) {
            case NIX: 
            case BOOL: 
            case LONG: 
            case DOUBLE: 
            case STRING: 
            case DATA: {
                this.handleLeafValue(inspector);
                break;
            }
            case ARRAY: {
                this.handleARRAY(inspector);
                break;
            }
            case OBJECT: {
                this.handleOBJECT(inspector);
                break;
            }
            default: {
                assert (false) : "Should not be reached";
                break;
            }
        }
    }

    private void handleARRAY(Inspector inspector) {
        this.trace("Array");
        inspector.traverse(new ArrayTraverser(){

            public void entry(int idx, Inspector inspector) {
                ConfigPayloadApplier.this.handleArrayEntry(idx, inspector);
            }
        });
    }

    private void handleArrayEntry(int idx, Inspector inspector) {
        try {
            this.trace("entry, idx=" + idx);
            this.trace("top of stack=" + this.stack.peek().toString());
            String name = this.stack.peek().nameStack().peek();
            if (inspector.type().equals((Object)com.yahoo.slime.Type.OBJECT)) {
                NamedBuilder builder = this.createBuilder(this.stack.peek(), name);
                if (builder == null) {
                    return;
                }
                this.stack.push(builder);
            }
            this.handleValue(inspector);
            if (inspector.type().equals((Object)com.yahoo.slime.Type.OBJECT)) {
                this.stack.peek().nameStack().pop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleOBJECT(Inspector inspector) {
        this.trace("Object");
        this.printStack();
        inspector.traverse(new ObjectTraverser(){

            public void field(String name, Inspector inspector) {
                ConfigPayloadApplier.this.handleObjectEntry(name, inspector);
            }
        });
        this.trace("Should pop a builder from stack");
        NamedBuilder builder = this.stack.pop();
        this.printStack();
        if (!this.stack.empty()) {
            this.trace("builder= " + builder);
            try {
                this.invokeSetter(this.stack.peek().builder, builder.peekName(), builder.builder);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set '" + builder.peekName() + "' for value '" + builder.builder() + "'", e);
            }
        }
    }

    private void handleObjectEntry(String name, Inspector inspector) {
        try {
            this.trace("field, name=" + name);
            NamedBuilder parentBuilder = this.stack.peek();
            if (inspector.type().equals((Object)com.yahoo.slime.Type.OBJECT)) {
                if (this.isMapField(parentBuilder, name)) {
                    parentBuilder.nameStack().push(name);
                    this.handleMap(inspector);
                    parentBuilder.nameStack().pop();
                    return;
                }
                NamedBuilder builder = this.createBuilder(parentBuilder, name);
                if (builder == null) {
                    return;
                }
                this.stack.push(builder);
            } else if (inspector.type().equals((Object)com.yahoo.slime.Type.ARRAY)) {
                for (int i = 0; i < inspector.children(); ++i) {
                    this.trace("Pushing " + name);
                    parentBuilder.nameStack().push(name);
                }
            } else {
                parentBuilder.nameStack().push(name);
            }
            this.handleValue(inspector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMap(Inspector inspector) {
        inspector.traverse(new ObjectTraverser(){

            public void field(String name, Inspector inspector) {
                switch (inspector.type()) {
                    case OBJECT: {
                        ConfigPayloadApplier.this.handleInnerMap(name, inspector);
                        break;
                    }
                    case ARRAY: {
                        throw new IllegalArgumentException("Never herd of array inside maps before");
                    }
                    default: {
                        ConfigPayloadApplier.this.setMapLeafValue(name, ConfigPayloadApplier.this.getValueFromInspector(inspector));
                    }
                }
            }
        });
    }

    private void handleInnerMap(String name, Inspector inspector) {
        NamedBuilder builder = this.createBuilder(this.stack.peek(), this.stack.peek().peekName());
        if (builder == null) {
            throw new RuntimeException("Missing map builder (this should never happen): " + this.stack.peek());
        }
        this.setMapLeafValue(name, builder.builder());
        this.stack.push(builder);
        inspector.traverse(new ObjectTraverser(){

            public void field(String name, Inspector inspector) {
                ConfigPayloadApplier.this.handleObjectEntry(name, inspector);
            }
        });
        this.stack.pop();
    }

    private void setMapLeafValue(String key, Object value) {
        NamedBuilder parent = this.stack.peek();
        ConfigBuilder builder = parent.builder();
        String methodName = parent.peekName();
        try {
            if (this.isPathField(builder, methodName)) {
                FileReference wrappedPath = this.resolvePath((String)value);
                this.invokeSetter(builder, methodName, key, wrappedPath);
            } else if (this.isUrlField(builder, methodName)) {
                UrlReference url = this.resolveUrl((String)value);
                this.invokeSetter(builder, methodName, key, url);
            } else {
                this.invokeSetter(builder, methodName, key, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Name: " + methodName + ", value '" + value + "'", e);
        }
        catch (NoSuchMethodException e) {
            log.log(LogLevel.INFO, "Skipping unknown field " + methodName + " in " + this.rootBuilder);
        }
    }

    private boolean isMapField(NamedBuilder parentBuilder, String name) {
        ConfigBuilder builder = parentBuilder.builder();
        try {
            Field f = builder.getClass().getField(name);
            return f.getType().getName().equals("java.util.Map");
        }
        catch (Exception e) {
            return false;
        }
    }

    NamedBuilder createBuilder(NamedBuilder parentBuilder, String name) {
        ConfigBuilder builder = parentBuilder.builder();
        Object newBuilder = this.getBuilderForStruct(name, builder.getClass().getDeclaringClass());
        if (newBuilder == null) {
            return null;
        }
        this.trace("New builder for " + name + "=" + newBuilder);
        this.trace("Pushing builder for " + name + "=" + newBuilder + " onto stack");
        return new NamedBuilder((ConfigBuilder)newBuilder, name);
    }

    private void handleLeafValue(Inspector value) {
        this.trace("String ");
        this.printStack();
        NamedBuilder peek = this.stack.peek();
        this.trace("popping name stack");
        String name = peek.nameStack().pop();
        this.printStack();
        ConfigBuilder builder = peek.builder();
        this.trace("name=" + name + ",builder=" + builder + ",value=" + value.toString());
        this.setValueForLeafNode(builder, name, value);
    }

    private void setValueForLeafNode(Object builder, String methodName, Inspector value) {
        try {
            if (this.isPathField(builder, methodName)) {
                FileReference wrappedPath = this.resolvePath(Utf8.toString((byte[])value.asUtf8()));
                this.invokeSetter(builder, methodName, wrappedPath);
            } else if (this.isUrlField(builder, methodName)) {
                UrlReference url = this.resolveUrl(Utf8.toString((byte[])value.asUtf8()));
                this.invokeSetter(builder, methodName, url);
            } else {
                Object object = this.getValueFromInspector(value);
                this.invokeSetter(builder, methodName, object);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Name: " + methodName + ", value '" + value + "'", e);
        }
        catch (NoSuchMethodException e) {
            log.log(LogLevel.INFO, "Skipping unknown field " + methodName + " in " + builder.getClass());
        }
    }

    private FileReference resolvePath(String value) {
        Path path = this.pathAcquirer.getPath(this.newFileReference(value));
        return this.newFileReference(path.toString());
    }

    private UrlReference resolveUrl(String url) {
        if (this.urlDownloader == null) {
            throw new RuntimeException("Resolving url field failed due to missing URL downloader.");
        }
        File file = this.urlDownloader.waitFor(new UrlReference(url), 3600L);
        return new UrlReference(file.getAbsolutePath());
    }

    private FileReference newFileReference(String fileReference) {
        try {
            Constructor constructor = FileReference.class.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return (FileReference)constructor.newInstance(fileReference);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed invoking FileReference constructor.", e);
        }
    }

    private static String methodCacheKey(Object builder, String methodName, Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append(builder.getClass().getName()).append(".").append(methodName);
        for (Object param : params) {
            sb.append(".").append(param.getClass().getName());
        }
        return sb.toString();
    }

    private Method lookupSetter(Object builder, String methodName, Object ... params) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            parameterTypes[i] = params[i].getClass();
        }
        Method method = builder.getClass().getDeclaredMethod(methodName, parameterTypes);
        method.setAccessible(true);
        this.trace("method=" + method + ",params=" + params);
        return method;
    }

    private void invokeSetter(Object builder, String methodName, Object ... params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String key = ConfigPayloadApplier.methodCacheKey(builder, methodName, params);
        Method method = this.methodCache.get(key);
        if (method == null) {
            method = this.lookupSetter(builder, methodName, params);
            this.methodCache.put(key, method);
        }
        method.invoke(builder, params);
    }

    private Object getValueFromInspector(Inspector inspector) {
        switch (inspector.type()) {
            case STRING: {
                return Utf8.toString((byte[])inspector.asUtf8());
            }
            case LONG: {
                return String.valueOf(inspector.asLong());
            }
            case DOUBLE: {
                return String.valueOf(inspector.asDouble());
            }
            case NIX: {
                return null;
            }
            case BOOL: {
                return String.valueOf(inspector.asBool());
            }
            case DATA: {
                return String.valueOf(inspector.asData());
            }
        }
        throw new IllegalArgumentException("Unhandled type " + inspector.type());
    }

    private boolean isPathField(Object builder, String methodName) {
        return this.isFieldType(this.pathFieldSet, builder, methodName, (Type)((Object)FileReference.class));
    }

    private boolean isUrlField(Object builder, String methodName) {
        return this.isFieldType(this.urlFieldSet, builder, methodName, (Type)((Object)UrlReference.class));
    }

    private boolean isFieldType(Set<String> fieldSet, Object builder, String methodName, Type type) {
        String key = ConfigPayloadApplier.fieldKey(builder, methodName);
        if (fieldSet.contains(key)) {
            return true;
        }
        boolean isType = false;
        try {
            Field field = builder.getClass().getDeclaredField(methodName);
            Type fieldType = field.getGenericType();
            if (fieldType instanceof Class && fieldType == type) {
                isType = true;
            } else if (fieldType instanceof ParameterizedType) {
                isType = this.isParameterizedWith((ParameterizedType)fieldType, type);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (isType) {
            fieldSet.add(key);
        }
        return isType;
    }

    private static String fieldKey(Object builder, String methodName) {
        return builder.getClass().getName() + "." + methodName;
    }

    private boolean isParameterizedWith(ParameterizedType fieldType, Type type) {
        int numTypeArgs = fieldType.getActualTypeArguments().length;
        if (numTypeArgs > 0) {
            return fieldType.getActualTypeArguments()[numTypeArgs - 1] == type;
        }
        return false;
    }

    private String capitalize(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name.substring(0, 1).toUpperCase()).append(name.substring(1));
        return sb.toString();
    }

    private Constructor<?> lookupBuilderForStruct(String structName, String name, Class<?> currentClass) {
        String currentClassName = currentClass.getName();
        this.trace("structName=" + structName + ", name=" + name + ",current class=" + currentClassName);
        Class<?> structClass = this.getInnerClass(currentClass, currentClassName + "$" + structName);
        if (structClass == null) {
            log.info("Could not find nested class '" + currentClassName + "$" + structName + "'. Ignoring it, assuming it's been added to a newer version of the config.");
            return null;
        }
        return this.getStructBuilderConstructor(structClass, currentClassName, structName);
    }

    private Constructor<?> getStructBuilderConstructor(Class<?> structClass, String currentClassName, String builderName) {
        String structBuilderName = currentClassName + "$" + builderName + "$Builder";
        Class<?> structBuilderClass = this.getInnerClass(structClass, structBuilderName);
        if (structBuilderClass == null) {
            throw new RuntimeException("Could not find builder class " + structBuilderName);
        }
        try {
            return structBuilderClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not create class ''" + structBuilderClass.getName() + "'");
        }
    }

    private Class<?> getInnerClass(Class<?> clazz, String name) {
        for (Class<?> cls : clazz.getDeclaredClasses()) {
            if (!cls.getName().equals(name)) continue;
            this.trace("Found class " + cls.getName());
            return cls;
        }
        return null;
    }

    private static String constructorCacheKey(String builderName, String name, Class<?> currentClass) {
        return builderName + "." + name + "." + currentClass.getName();
    }

    private Object getBuilderForStruct(String name, Class<?> currentClass) {
        Object builder;
        String structName = this.capitalize(name);
        String key = ConfigPayloadApplier.constructorCacheKey(structName, name, currentClass);
        Constructor<?> ctor = this.constructorCache.get(key);
        if (ctor == null) {
            ctor = this.lookupBuilderForStruct(structName, name, currentClass);
            if (ctor == null) {
                return null;
            }
            this.constructorCache.put(key, ctor);
        }
        try {
            builder = ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create class ''" + ctor.getDeclaringClass().getName() + "'");
        }
        return builder;
    }

    private void debug(String message) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, message);
        }
    }

    private void trace(String message) {
        if (log.isLoggable((Level)LogLevel.SPAM)) {
            log.log((Level)LogLevel.SPAM, message);
        }
    }

    private void printStack() {
        this.trace("stack=" + this.stack.toString());
    }

    static class IdentityPathAcquirer
    implements ConfigTransformer.PathAcquirer {
        IdentityPathAcquirer() {
        }

        @Override
        public Path getPath(FileReference fileReference) {
            return new File(fileReference.value()).toPath();
        }
    }

    private static class NamedBuilder {
        private final ConfigBuilder builder;
        private final Stack<String> names = new Stack();

        NamedBuilder(ConfigBuilder builder) {
            this.builder = builder;
        }

        NamedBuilder(ConfigBuilder builder, String name) {
            this(builder);
            this.names.push(name);
        }

        ConfigBuilder builder() {
            return this.builder;
        }

        String peekName() {
            return this.names.peek();
        }

        Stack<String> nameStack() {
            return this.names;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.builder() == null ? "null" : this.builder.toString()).append(" names=").append(this.names);
            return sb.toString();
        }
    }
}

