/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigHandle;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.yolean.Exceptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ConfigSubscriber
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(ConfigSubscriber.class.getName());
    private State state = State.OPEN;
    protected final List<ConfigHandle<? extends ConfigInstance>> subscriptionHandles = new CopyOnWriteArrayList<ConfigHandle<? extends ConfigInstance>>();
    private final ConfigSource source;
    private final Object monitor = new Object();
    private final Throwable stackTraceAtConstruction;
    private long generation = -1L;
    private boolean internalRedeploy = false;
    protected Map<ConfigSourceSet, JRTConfigRequester> requesters = new HashMap<ConfigSourceSet, JRTConfigRequester>();

    public ConfigSubscriber() {
        this(JRTConfigRequester.defaultSourceSet);
    }

    public ConfigSubscriber(ConfigSource source) {
        this.source = source;
        this.stackTraceAtConstruction = new Throwable();
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId) {
        return this.subscribe(configClass, configId, this.source, new TimingValues());
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId, long timeoutMillis) {
        return this.subscribe(configClass, configId, this.source, new TimingValues().setSubscribeTimeout(timeoutMillis));
    }

    <T extends ConfigInstance> ConfigHandle<T> subscribe(Class<T> configClass, String configId, ConfigSource source, TimingValues timingValues) {
        this.checkStateBeforeSubscribe();
        ConfigKey<T> configKey = new ConfigKey<T>(configClass, configId);
        ConfigSubscription<T> sub = ConfigSubscription.get(configKey, this, source, timingValues);
        ConfigHandle<T> handle = new ConfigHandle<T>(sub);
        this.subscribeAndHandleErrors(sub, configKey, handle, timingValues);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStateBeforeSubscribe() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.state != State.OPEN) {
                throw new IllegalStateException("Adding subscription after calling nextConfig() is not allowed");
            }
        }
    }

    protected void subscribeAndHandleErrors(ConfigSubscription<?> sub, ConfigKey<?> configKey, ConfigHandle<?> handle, TimingValues timingValues) {
        this.subscriptionHandles.add(handle);
        boolean subOk = sub.subscribe(timingValues.getSubscribeTimeout());
        this.throwIfExceptionSet(sub);
        if (!subOk) {
            throw new ConfigurationRuntimeException("Subscribe for '" + configKey + "' timed out (timeout was " + timingValues.getSubscribeTimeout() + " ms): " + sub);
        }
    }

    public boolean nextConfig() {
        return this.nextConfig(1000L);
    }

    public boolean nextConfig(long timeoutMillis) {
        return this.acquireSnapshot(timeoutMillis, true);
    }

    public boolean nextGeneration() {
        return this.nextGeneration(1000L);
    }

    public boolean nextGeneration(long timeoutMillis) {
        return this.acquireSnapshot(timeoutMillis, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireSnapshot(long timeoutInMillis, boolean requireChange) {
        boolean reconfigDue;
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == State.CLOSED) {
                return false;
            }
            this.state = State.FROZEN;
        }
        long started = System.currentTimeMillis();
        long timeLeftMillis = timeoutInMillis;
        boolean anyConfigChanged = false;
        Long currentGen = null;
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.setChanged(false);
        }
        boolean internalRedeployOnly = true;
        do {
            boolean allGenerationsChanged = true;
            boolean allGenerationsTheSame = true;
            for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
                ConfigSubscription<? extends ConfigInstance> subscription = h.subscription();
                if (!subscription.nextConfig(timeLeftMillis)) {
                    return false;
                }
                this.throwIfExceptionSet(subscription);
                ConfigSubscription.ConfigState<? extends ConfigInstance> config = subscription.getConfigState();
                if (currentGen == null) {
                    currentGen = config.getGeneration();
                }
                allGenerationsTheSame &= currentGen.equals(config.getGeneration());
                allGenerationsChanged &= config.isGenerationChanged();
                anyConfigChanged |= config.isConfigChanged();
                internalRedeployOnly &= config.isInternalRedeploy();
                timeLeftMillis = timeoutInMillis + started - System.currentTimeMillis();
            }
            boolean bl = reconfigDue = (anyConfigChanged || !requireChange) && allGenerationsChanged && allGenerationsTheSame;
            if (reconfigDue || timeLeftMillis <= 0L) continue;
            this.sleep(timeLeftMillis);
        } while (!reconfigDue && timeLeftMillis > 0L);
        if (reconfigDue) {
            this.markSubsChangedSeen(currentGen);
            Object object2 = this.monitor;
            synchronized (object2) {
                this.internalRedeploy = internalRedeployOnly;
                this.generation = currentGen;
            }
        }
        return reconfigDue;
    }

    private void sleep(long timeLeftMillis) {
        try {
            Thread.sleep(Math.min(10L, timeLeftMillis));
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
    }

    protected void throwIfExceptionSet(ConfigSubscription<? extends ConfigInstance> sub) {
        RuntimeException subThrowable = sub.getException();
        if (subThrowable != null) {
            sub.setException(null);
            throw subThrowable;
        }
    }

    private void markSubsChangedSeen(Long requiredGen) {
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            ConfigSubscription<? extends ConfigInstance> sub = h.subscription();
            h.setChanged(sub.isConfigChangedAndReset(requiredGen));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Iterator<ConfigHandle<? extends ConfigInstance>> iterator = this.monitor;
        synchronized (iterator) {
            this.state = State.CLOSED;
        }
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.subscription().close();
        }
        this.closeRequesters();
        log.log((Level)LogLevel.DEBUG, "Config subscriber has been closed.");
    }

    protected void closeRequesters() {
        for (JRTConfigRequester requester : this.requesters.values()) {
            requester.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<ConfigHandle<? extends ConfigInstance>> iterator = this.monitor;
        synchronized (iterator) {
            sb.append("Subscriber state:").append(this.state.toString());
        }
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            sb.append("\n").append(h.toString());
        }
        return sb.toString();
    }

    public Thread startConfigThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        t.setName("Vespa config thread");
        t.start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State state() {
        Object object = this.monitor;
        synchronized (object) {
            return this.state;
        }
    }

    public void reload(long generation) {
        for (ConfigHandle<? extends ConfigInstance> h : this.subscriptionHandles) {
            h.subscription().reload(generation);
        }
    }

    public ConfigSource getSource() {
        return this.source;
    }

    public Map<ConfigSourceSet, JRTConfigRequester> requesters() {
        return this.requesters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.monitor;
        synchronized (object) {
            return this.state == State.CLOSED;
        }
    }

    public <T extends ConfigInstance> ConfigHandle<T> subscribe(SingleSubscriber<T> singleSubscriber, Class<T> configClass, String configId) {
        if (!this.subscriptionHandles.isEmpty()) {
            throw new IllegalStateException("Can not start single-subscription because subscriptions were previously opened on this.");
        }
        ConfigHandle handle = this.subscribe(configClass, configId);
        if (!this.nextConfig()) {
            throw new ConfigurationRuntimeException("Initial config of " + configClass.getName() + " failed.");
        }
        singleSubscriber.configure(handle.getConfig());
        this.startConfigThread(() -> {
            while (!this.isClosed()) {
                try {
                    if (!this.nextConfig() || !handle.isChanged()) continue;
                    singleSubscriber.configure(handle.getConfig());
                }
                catch (Exception e) {
                    log.log((Level)LogLevel.ERROR, "Exception from config system, continuing config thread: " + Exceptions.toMessageString((Throwable)e));
                }
            }
        });
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGeneration() {
        Object object = this.monitor;
        synchronized (object) {
            return this.generation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInternalRedeploy() {
        Object object = this.monitor;
        synchronized (object) {
            return this.internalRedeploy;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed()) {
                log.log(LogLevel.WARNING, this.stackTraceAtConstruction, () -> String.format("%s: Closing subscription from finalizer() - close() has not been called (keys=%s)", super.toString(), this.subscriptionHandles.stream().map(handle -> handle.subscription().getKey().toString()).collect(Collectors.toList())));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static interface SingleSubscriber<T extends ConfigInstance> {
        public void configure(T var1);
    }

    protected static enum State {
        OPEN,
        FROZEN,
        CLOSED;

    }
}

