/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.UrlReference;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlDownloader {
    private static final Logger log = Logger.getLogger(UrlDownloader.class.getName());
    private static final int BASE_ERROR_CODE = 65536;
    public static final int DOES_NOT_EXIST = 65537;
    public static final int INTERNAL_ERROR = 65538;
    public static final int HTTP_ERROR = 65539;
    private final Supervisor supervisor = new Supervisor(new Transport());
    private final Spec spec = new Spec(Defaults.getDefaults().vespaHostname(), Defaults.getDefaults().vespaConfigProxyRpcPort());
    private Target target;

    public void shutdown() {
        this.supervisor.transport().shutdown().join();
    }

    private void connect() {
        try {
            for (int timeRemaining = 5000; timeRemaining > 0; timeRemaining -= 500) {
                this.target = this.supervisor.connect(this.spec);
                Request request = new Request("frt.rpc.ping");
                this.target.invokeSync(request, 5.0);
                if (!request.isError()) {
                    log.log((Level)LogLevel.DEBUG, "Successfully connected to '" + this.spec + "', this = " + System.identityHashCode(this));
                    return;
                }
                this.target.close();
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.target != null && this.target.isValid();
    }

    private boolean temporaryError(Request req) {
        return false;
    }

    public File waitFor(UrlReference urlReference, long timeout) {
        long start = System.currentTimeMillis() / 1000L;
        if (!this.isValid()) {
            this.connect();
        }
        long timeLeft = timeout;
        do {
            Request request = new Request("url.waitFor");
            request.parameters().add((Value)new StringValue(urlReference.value()));
            double rpcTimeout = Math.min((double)timeLeft, 3600.0);
            log.log((Level)LogLevel.DEBUG, "InvokeSync waitFor " + urlReference + " with " + rpcTimeout + " seconds timeout");
            this.target.invokeSync(request, rpcTimeout);
            if (request.checkReturnTypes("s")) {
                return new File(request.returnValues().get(0).asString());
            }
            if (!request.isError()) {
                throw new RuntimeException("Invalid response: " + request.returnValues());
            }
            if (this.temporaryError(request)) {
                log.log(LogLevel.INFO, "Retrying waitFor for " + urlReference + ": " + request.errorCode() + " -- " + request.errorMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted sleep between retries of waitFor", e);
                }
            } else {
                throw new RuntimeException("Wait for " + urlReference + " failed: " + request.errorMessage() + " (" + request.errorCode() + ")");
            }
        } while ((timeLeft = start + timeout - System.currentTimeMillis() / 1000L) > 0L);
        throw new RuntimeException("Timed out waiting for " + urlReference + " after " + timeout);
    }
}

