/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.NoCopyByteArrayOutputStream;
import com.yahoo.vespa.config.protocol.RequestValidation;
import com.yahoo.vespa.config.protocol.SlimeRequestData;
import com.yahoo.vespa.config.protocol.SlimeResponseData;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Logger;

public abstract class SlimeClientConfigRequest
implements JRTClientConfigRequest {
    protected static final Logger log = Logger.getLogger(SlimeClientConfigRequest.class.getName());
    protected final SlimeRequestData requestData;
    private final SlimeResponseData responseData;
    protected final Request request;

    protected SlimeClientConfigRequest(ConfigKey<?> key, String hostname, DefContent defSchema, String configMd5, long generation, long timeout, Trace trace, CompressionType compressionType, Optional<VespaVersion> vespaVersion) {
        Slime data = SlimeRequestData.encodeRequest(key, hostname, defSchema, configMd5, generation, timeout, trace, this.getProtocolVersion(), compressionType, vespaVersion);
        Request jrtReq = new Request(this.getJRTMethodName());
        jrtReq.parameters().add((Value)new StringValue(SlimeClientConfigRequest.encodeAsUtf8String(data, true)));
        this.requestData = new SlimeRequestData(jrtReq, data);
        this.responseData = new SlimeResponseData(jrtReq);
        this.request = jrtReq;
    }

    protected abstract String getJRTMethodName();

    protected static String encodeAsUtf8String(Slime data, boolean compact) {
        NoCopyByteArrayOutputStream baos = new NoCopyByteArrayOutputStream();
        try {
            new JsonFormat(compact).encode((OutputStream)baos, data);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode config request", e);
        }
        return Utf8.toString((byte[])((ByteArrayOutputStream)baos).toByteArray());
    }

    @Override
    public ConfigKey<?> getConfigKey() {
        return this.requestData.getConfigKey();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("request='").append(this.getConfigKey()).append(",").append(this.getClientHostName()).append(",").append(this.getRequestConfigMd5()).append(",").append(this.getRequestGeneration()).append(",").append(this.getTimeout()).append(",").append(this.getVespaVersion()).append("'\n");
        sb.append("response='").append(this.getNewConfigMd5()).append(",").append(this.getNewGeneration()).append(",").append(this.responseIsInternalRedeploy()).append("'\n");
        return sb.toString();
    }

    @Override
    public String getClientHostName() {
        return this.requestData.getClientHostName();
    }

    @Override
    public long getWantedGeneration() {
        return this.requestData.getWantedGeneration();
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public int errorCode() {
        return this.request.errorCode();
    }

    @Override
    public String errorMessage() {
        return this.request.errorMessage();
    }

    @Override
    public String getShortDescription() {
        return this.toString();
    }

    @Override
    public boolean hasUpdatedGeneration() {
        long prevGen = this.getRequestGeneration();
        long newGen = this.getNewGeneration();
        return ConfigUtils.isGenerationNewer(newGen, prevGen);
    }

    @Override
    public long getTimeout() {
        return this.requestData.getTimeout();
    }

    protected String newConfMd5() {
        String newMd5 = this.getNewConfigMd5();
        if ("".equals(newMd5)) {
            return this.getRequestConfigMd5();
        }
        return newMd5;
    }

    protected long newGen() {
        long newGen = this.getNewGeneration();
        if (newGen == 0L) {
            return this.getRequestGeneration();
        }
        return newGen;
    }

    @Override
    public DefContent getDefContent() {
        return this.requestData.getSchema();
    }

    @Override
    public boolean isError() {
        return this.request.isError();
    }

    @Override
    public boolean containsPayload() {
        return false;
    }

    @Override
    public boolean hasUpdatedConfig() {
        String respMd5 = this.getNewConfigMd5();
        return !respMd5.equals("") && !this.getRequestConfigMd5().equals(respMd5);
    }

    @Override
    public Trace getResponseTrace() {
        return this.responseData.getResponseTrace();
    }

    @Override
    public String getRequestConfigMd5() {
        return this.requestData.getRequestConfigMd5();
    }

    @Override
    public boolean validateResponse() {
        if (this.request.isError()) {
            return false;
        }
        if (this.request.returnValues().size() == 0) {
            return false;
        }
        if (!this.checkReturnTypes(this.request)) {
            log.warning("Invalid return types for config response: " + this.errorMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean validateParameters() {
        int errorCode = RequestValidation.validateRequest(this);
        return errorCode == 0;
    }

    protected abstract boolean checkReturnTypes(Request var1);

    @Override
    public String getNewConfigMd5() {
        return this.responseData.getResponseConfigMd5();
    }

    @Override
    public long getNewGeneration() {
        return this.responseData.getResponseConfigGeneration();
    }

    @Override
    public boolean responseIsInternalRedeploy() {
        return this.responseData.getResponseInternalRedeployment();
    }

    @Override
    public long getRequestGeneration() {
        return this.requestData.getRequestGeneration();
    }

    protected SlimeResponseData getResponseData() {
        return this.responseData;
    }

    @Override
    public Optional<VespaVersion> getVespaVersion() {
        return this.requestData.getVespaVersion();
    }
}

