/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigHandle;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSubscriber;

public class ConfigGetter<T extends ConfigInstance> {
    private final Class<T> clazz;
    private final ConfigSource source;

    public ConfigGetter(Class<T> clazz) {
        this(null, clazz);
    }

    public ConfigGetter(ConfigSource source, Class<T> clazz) {
        this.clazz = clazz;
        this.source = source;
    }

    public synchronized T getConfig(String configId) {
        ConfigSubscriber subscriber = this.source == null ? new ConfigSubscriber() : new ConfigSubscriber(this.source);
        ConfigHandle<T> h = subscriber.subscribe(this.clazz, configId);
        subscriber.nextConfig();
        T ret = h.getConfig();
        subscriber.close();
        return ret;
    }

    public static <T extends ConfigInstance> T getConfig(Class<T> c, String configId) {
        ConfigGetter<T> getter = new ConfigGetter<T>(c);
        return getter.getConfig(configId);
    }

    public static <T extends ConfigInstance> T getConfig(Class<T> c, String configId, ConfigSource source) {
        ConfigGetter<T> getter = new ConfigGetter<T>(source, c);
        return getter.getConfig(configId);
    }
}

