/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequestV3;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class JRTConfigRequestFactory {
    public static final String VESPA_CONFIG_PROTOCOL_VERSION = "VESPA_CONFIG_PROTOCOL_VERSION";
    private static final CompressionType compressionType = JRTConfigRequestFactory.getCompressionType();
    private static final String VESPA_CONFIG_PROTOCOL_COMPRESSION = "VESPA_CONFIG_PROTOCOL_COMPRESSION";
    public static final String VESPA_VERSION = "VESPA_VERSION";

    public static <T extends ConfigInstance> JRTClientConfigRequest createFromSub(JRTConfigSubscription<T> sub) {
        return JRTClientConfigRequestV3.createFromSub(sub, Trace.createNew(), compressionType, JRTConfigRequestFactory.getVespaVersion());
    }

    public static JRTClientConfigRequest createFromRaw(RawConfig config, long serverTimeout) {
        return JRTClientConfigRequestV3.createFromRaw(config, serverTimeout, Trace.createNew(), compressionType, JRTConfigRequestFactory.getVespaVersion());
    }

    public static String getProtocolVersion() {
        return "3";
    }

    static String getProtocolVersion(String env, String alternateEnv, String property) {
        return ConfigUtils.getEnvValue("3", env, alternateEnv, property);
    }

    public static Set<Long> supportedProtocolVersions() {
        return Collections.singleton(3L);
    }

    public static CompressionType getCompressionType() {
        return JRTConfigRequestFactory.getCompressionType(System.getenv(VESPA_CONFIG_PROTOCOL_COMPRESSION), System.getenv("services__config_protocol_compression"), System.getProperty(VESPA_CONFIG_PROTOCOL_COMPRESSION));
    }

    static CompressionType getCompressionType(String env, String alternateEnv, String property) {
        return CompressionType.valueOf(ConfigUtils.getEnvValue("LZ4", env, alternateEnv, property));
    }

    static Optional<VespaVersion> getVespaVersion() {
        String envValue = ConfigUtils.getEnvValue("", System.getenv(VESPA_VERSION), System.getProperty(VESPA_VERSION));
        if (envValue != null && !envValue.isEmpty()) {
            return Optional.of(VespaVersion.fromString(envValue));
        }
        return Optional.of(JRTConfigRequestFactory.getCompiledVespaVersion());
    }

    static VespaVersion getCompiledVespaVersion() {
        return VespaVersion.fromString(String.format("%d.%d.%d", 6, 232, 4));
    }
}

