/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigPayloadApplier;
import java.nio.file.Path;

public class ConfigTransformer<T extends ConfigInstance> {
    private final Class<T> clazz;
    private static volatile PathAcquirer pathAcquirer = new ConfigPayloadApplier.IdentityPathAcquirer();

    public static void setPathAcquirer(PathAcquirer pathAcquirer) {
        ConfigTransformer.pathAcquirer = pathAcquirer == null ? new ConfigPayloadApplier.IdentityPathAcquirer() : pathAcquirer;
    }

    public ConfigTransformer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public ConfigInstance.Builder toConfigBuilder(ConfigPayload payload) {
        ConfigInstance.Builder builder = this.getRootBuilder();
        ConfigPayloadApplier<ConfigInstance.Builder> creator = new ConfigPayloadApplier<ConfigInstance.Builder>(builder, pathAcquirer);
        creator.applyPayload(payload);
        return builder;
    }

    private ConfigInstance.Builder getRootBuilder() {
        Class<?>[] classes;
        ConfigInstance.Builder builder = null;
        for (Class<?> c : classes = this.clazz.getDeclaredClasses()) {
            if (!c.getName().endsWith("Builder")) continue;
            try {
                builder = (ConfigInstance.Builder)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate builder for " + this.clazz.getName(), e);
            }
        }
        if (builder == null) {
            throw new RuntimeException("Could not find builder for " + this.clazz.getName());
        }
        return builder;
    }

    public static interface PathAcquirer {
        public Path getPath(FileReference var1);
    }
}

