/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.protocol;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.text.Utf8Array;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ErrorCode;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.protocol.NoCopyByteArrayOutputStream;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.RequestValidation;
import com.yahoo.vespa.config.protocol.SlimeRequestData;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Logger;

abstract class SlimeServerConfigRequest
implements JRTServerConfigRequest {
    protected static final Logger log = Logger.getLogger(SlimeServerConfigRequest.class.getName());
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final SlimeRequestData requestData;
    private boolean isDelayed = false;
    private Trace requestTrace = null;
    protected final Request request;

    protected SlimeServerConfigRequest(Request request) {
        this.requestData = new SlimeRequestData(request);
        this.request = request;
    }

    protected static JsonGenerator createJsonGenerator(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        return jsonFactory.createGenerator((OutputStream)byteArrayOutputStream);
    }

    @Override
    public ConfigKey<?> getConfigKey() {
        return this.requestData.getConfigKey();
    }

    @Override
    public DefContent getDefContent() {
        return this.getSchema();
    }

    @Override
    public boolean noCache() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("request='").append(this.getConfigKey()).append(",").append(this.getClientHostName()).append(",").append(this.getRequestConfigMd5()).append(",").append(this.getRequestGeneration()).append(",").append(this.getTimeout()).append("'\n");
        return sb.toString();
    }

    @Override
    public Payload payloadFromResponse(ConfigResponse response) {
        return Payload.from(response.getPayload(), response.getCompressionInfo());
    }

    private DefContent getSchema() {
        return this.requestData.getSchema();
    }

    @Override
    public long getWantedGeneration() {
        return this.requestData.getWantedGeneration();
    }

    @Override
    public String getClientHostName() {
        return this.requestData.getClientHostName();
    }

    @Override
    public Trace getRequestTrace() {
        if (this.requestTrace == null) {
            this.requestTrace = this.requestData.getRequestTrace();
        }
        return this.requestTrace;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public boolean validateParameters() {
        int errorCode = RequestValidation.validateRequest(this);
        if (errorCode != 0) {
            this.addErrorResponse(errorCode);
        }
        return errorCode == 0;
    }

    @Override
    public String getRequestConfigMd5() {
        return this.requestData.getRequestConfigMd5();
    }

    private void addErrorResponse(int errorCode) {
        this.addErrorResponse(errorCode, ErrorCode.getName(errorCode));
    }

    @Override
    public void setDelayedResponse(boolean delayedResponse) {
        this.isDelayed = delayedResponse;
    }

    @Override
    public void addErrorResponse(int errorCode, String name) {
        NoCopyByteArrayOutputStream byteArrayOutputStream = new NoCopyByteArrayOutputStream();
        try {
            JsonGenerator jsonWriter = jsonFactory.createGenerator((OutputStream)byteArrayOutputStream);
            jsonWriter.writeStartObject();
            this.addCommonReturnValues(jsonWriter);
            jsonWriter.writeEndObject();
            jsonWriter.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not add error response for " + this);
        }
        this.request.setError(errorCode, name);
        this.request.returnValues().add(SlimeServerConfigRequest.createResponseValue(byteArrayOutputStream));
    }

    protected static Value createResponseValue(ByteArrayOutputStream byteArrayOutputStream) {
        return new StringValue(new Utf8Array(byteArrayOutputStream.toByteArray()));
    }

    protected void addCommonReturnValues(JsonGenerator jsonGenerator) throws IOException {
        ConfigKey<?> key = this.requestData.getConfigKey();
        SlimeServerConfigRequest.setResponseField(jsonGenerator, "version", this.getProtocolVersion());
        SlimeServerConfigRequest.setResponseField(jsonGenerator, "defName", key.getName());
        SlimeServerConfigRequest.setResponseField(jsonGenerator, "defNamespace", key.getNamespace());
        SlimeServerConfigRequest.setResponseField(jsonGenerator, "defMD5", key.getMd5());
        SlimeServerConfigRequest.setResponseField(jsonGenerator, "configId", key.getConfigId());
        SlimeServerConfigRequest.setResponseField(jsonGenerator, "clientHostname", this.requestData.getClientHostName());
        jsonGenerator.writeFieldName("trace");
        jsonGenerator.writeRawValue(this.getRequestTrace().toString(true));
    }

    protected static void setResponseField(JsonGenerator jsonGenerator, String fieldName, String value) throws IOException {
        jsonGenerator.writeStringField(fieldName, value);
    }

    protected static void setResponseField(JsonGenerator jsonGenerator, String fieldName, long value) throws IOException {
        jsonGenerator.writeNumberField(fieldName, value);
    }

    @Override
    public long getRequestGeneration() {
        return this.requestData.getRequestGeneration();
    }

    @Override
    public boolean isDelayedResponse() {
        return this.isDelayed;
    }

    @Override
    public int errorCode() {
        return this.request.errorCode();
    }

    @Override
    public String errorMessage() {
        return this.request.errorMessage();
    }

    @Override
    public String getShortDescription() {
        return this.toString();
    }

    protected CompressionType getCompressionType() {
        return this.requestData.getCompressionType();
    }

    @Override
    public long getTimeout() {
        return this.requestData.getTimeout();
    }

    @Override
    public Optional<VespaVersion> getVespaVersion() {
        return this.requestData.getVespaVersion();
    }
}

