/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.CfgConfigPayloadBuilder;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import java.util.Arrays;

public class RawConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    final String inputPayload;
    String payload;

    RawConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber, String pl) {
        super(key, subscriber);
        this.inputPayload = pl;
    }

    @Override
    public boolean nextConfig(long timeout) {
        if (this.checkReloaded()) {
            return true;
        }
        if (this.payload == null) {
            this.payload = this.inputPayload;
            this.setGeneration(0L);
            this.setGenerationChanged(true);
            this.setConfigChanged(true);
            ConfigPayload configPayload = new CfgConfigPayloadBuilder().deserialize(Arrays.asList(this.payload.split("\n")));
            this.config = configPayload.toInstance(this.configClass, this.key.getConfigId());
            return true;
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
        this.setGenerationChanged(false);
        this.setConfigChanged(false);
        return false;
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }
}

